/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.swing.testcase;

import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.gui.E2EBuilderQuestionDialog;
import ch.e2e.builder.base.gui.ModulePopupMenu;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.util.DateTimeUtil;
import ch.e2e.builder.trace.gui.testcase.InspectionTreePanel;
import ch.e2e.builder.trace.gui.testcase.MainPanelView;
import ch.e2e.builder.trace.testcase.TestcaseDefaults;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.TraceSettings;
import ch.e2e.builder.trace.testcase.event.TestcaseEvent;
import ch.e2e.builder.trace.tree.RefreshAsynchronousTreeEvent;
import ch.e2e.builder.traceviewer.TraceViewer;
import ch.e2e.builder.traceviewer.execute.AsyncTraceAction;
import ch.e2e.builder.traceviewer.execute.AsyncTraceTransactionFactory;
import ch.e2e.builder.traceviewer.testcase.AbstractAsyncTestcaseFolder;
import ch.e2e.builder.traceviewer.testcase.AbstractAsynchronousTestcase;
import ch.e2e.builder.traceviewer.testcase.AsynchronousTestcaseFolder;
import ch.e2e.builder.traceviewer.testcase.Identifier;
import ch.e2e.builder.traceviewer.testcase.PersistentStateTestcaseFolder;
import ch.e2e.builder.traceviewer.tree.menu.RefreshConfigurationEvent;
import ch.e2e.builder.traceviewer.tree.menu.RefreshIdentifiersEvent;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecutionVetoException;
import ch.e2e.io.FilesNotDeletedException;
import com.jidesoft.grid.AutoFilterTableHeader;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.TableModelWrapperUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class AsynchronousTracePanel
extends MainPanelView {
    private static final TraceSettings.TraceLevel DEFAULT_TRACE_LEVEL = TraceSettings.TraceLevel.Moderate;
    private static int DEFAULT_TRACE_MAX_SIZE;
    private static final String TRANSLATION_KEY_PREFIX = "async.trace.panel.";
    private static final String _TOOLTIP = ".tooltip";
    private static final String TITLE_LOCATION = "title.location";
    private static final String TITLE_CONFIGURATION = "title.configuration";
    private static final String TITLE_TRACE = "title.trace";
    private static final String BUTTON_CUSTOM_LOCATION = "button.custom.location";
    private static final String BUTTON_BRIDGE_LOCATION = "button.bridge.location";
    private static final String BUTTON_DELETE_ALL_TRACES = "button.clear.all";
    private static final String BUTTON_DELETE_CONFIGURATION = "button.delete.configuration";
    private static final String BUTTON_GET_CONFIGURATION = "button.get.configuration";
    private static final String BUTTON_GET_TRACE = "button.get.trace";
    private static final String BUTTON_INSPECTION_LIST = "button.inspection.list";
    private static final String BUTTON_LIST_TRACES = "button.list.traces";
    private static final String BUTTON_SET_CONFIGURATION = "button.set.configuration";
    private static final String BUTTON_SYSTEM_LOCATION = "button.system.location";
    private static final String LABEL_CLASSIFIER = "label.classifier";
    private static final String LABEL_MAX_SIZE = "label.max.size";
    private static final String LABEL_OPERATION = "label.operation";
    private static final String LABEL_TRACE_LEVEL = "label.trace.level";
    private static final String LABEL_BRIDGE_HOST = "label.bridge.host";
    private static final String LABEL_BRIDGE_PROTOCOL = "label.bridge.protocol";
    private static final String LABEL_BRIDGE_PORT = "label.bridge.port";
    private static final String LABEL_BRIDGE_USER = "label.bridge.user";
    private static final String LABEL_BRIDGE_PASSWORD = "label.bridge.password";
    private static final String LABEL_BRIDGE_PATH_PREFIX = "label.bridge.pathPrefix";
    private static final String LABEL_BRIDGE_SERVICE = "label.bridge.service";
    private static final String LABEL_USE_OAUTH2 = "label.use.oauth2";
    private static final String LABEL_OAUTH2_USER = "label.oauth2.user";
    private static final String LABEL_OAUTH2_PASSWORD = "label.oauth2.password";
    private static final String QUESTION_CLEAR_ALL_TITLE = "question.clear.all.title";
    private static final String QUESTION_CLEAR_ALL_SUBTITLE = "question.clear.all.subtitle";
    private static final String QUESTION_CLEAR_ALL_QUESTION = "question.clear.all.question";
    private static final int MIN_MAX_SIZE = 1;
    private static final int MAX_MAX_SIZE = 1000;
    private static final int DEFAULT_MAX_SIZE = 10;
    private final TraceViewer traceViewer;
    private AbstractAsyncTestcaseFolder root;
    private LocationPanel locationPanel;
    private ConfigurationPanel configPanel;
    private TracePanel tracePanel;

    public AsynchronousTracePanel(TraceViewer traceViewer) {
        this.traceViewer = traceViewer;
        this.createGui();
    }

    public void refresh() {
        this.locationPanel.refresh();
        this.configPanel.refresh();
        this.tracePanel.refresh();
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object root) {
        if (this.root != root) {
            this.root = (AbstractAsyncTestcaseFolder)root;
            this.refresh();
        }
    }

    public Object getPrintableObject() {
        return null;
    }

    private void createGui() {
        this.locationPanel = new LocationPanel();
        this.configPanel = new ConfigurationPanel();
        this.tracePanel = new TracePanel();
        this.setLayout(new BorderLayout(0, 5));
        JPanel topPanel = new JPanel(new BorderLayout(0, 5));
        topPanel.add((Component)this.locationPanel, "First");
        topPanel.add((Component)this.configPanel, "Last");
        this.add(topPanel, "First");
        this.add(this.tracePanel, "Center");
    }

    private String getTranslation(String key) {
        return this.traceViewer.getTranslation(TRANSLATION_KEY_PREFIX + key, key);
    }

    static {
        try {
            DEFAULT_TRACE_MAX_SIZE = (int)TestcaseDefaults.getInstance().getInteger("testcase.trace.max.size.default");
        }
        catch (MissingResourceException e) {
            DEFAULT_TRACE_MAX_SIZE = 10;
        }
    }

    private static enum Status {
        unknown,
        deactivated,
        activated;

    }

    private class InspectionListDialog
    extends E2EBuilderDialog {
        private static final String TITLE = "inspection.list.dialog.title";
        private static final String INTERNAL_TITLE = "inspection.list.dialog.internal.title";
        private static final String SUBTITLE = "inspection.list.dialog.subtitle";
        private final InspectionTreePanel inspectionTree;

        public InspectionListDialog() {
            super(AsynchronousTracePanel.this.getTranslation(TITLE), AsynchronousTracePanel.this.getTranslation(INTERNAL_TITLE), AsynchronousTracePanel.this.getTranslation(SUBTITLE), 3);
            this.inspectionTree = new InspectionTreePanel();
            this.add((Component)this.inspectionTree);
        }

        public void setInspectionList(File inspectionListFile, Collection<String> inspectionIds) {
            if (inspectionListFile.canRead()) {
                try {
                    this.inspectionTree.setRoot(DomUtilities.parse((File)inspectionListFile, (boolean)false, (boolean)false, (boolean)false), inspectionIds);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.inspectionTree.setRoot(null, Collections.emptyList());
            }
        }

        public Collection<String> getInspectionIds() {
            return this.inspectionTree.getInspectionIds();
        }
    }

    private class TracesTableModel
    extends AbstractTableModel {
        private final List<String> columnNames = new ArrayList<String>();
        private final List<Boolean> changeInfos = new ArrayList<Boolean>();
        private final List<List<String>> traceRows = new ArrayList<List<String>>();
        private List<Identifier> traces = Collections.emptyList();

        public TracesTableModel(AbstractAsyncTestcaseFolder testcaseFolder) {
            if (testcaseFolder != null) {
                this.setColumnNames(testcaseFolder);
            }
        }

        public void setTraces(List<Identifier> traces) {
            this.changeInfos.clear();
            for (Identifier identifier : traces) {
                this.changeInfos.add(!this.traces.contains(identifier));
            }
            this.traces = traces;
            this.traceRows.clear();
            for (Identifier trace : traces) {
                ArrayList<String> columns = new ArrayList<String>(this.columnNames.size());
                columns.add(DateTimeUtil.formatLocalDateTime((Instant)trace.getFirstEntry()));
                columns.add(DateTimeUtil.formatLocalDateTime((Instant)trace.getLastEntry()));
                columns.addAll(trace.getPrimaryKeyValues());
                this.traceRows.add(columns);
            }
            this.fireTableDataChanged();
        }

        public Identifier getTrace(int rowIndex) {
            return this.traces.get(rowIndex);
        }

        public boolean hasChanged(int rowIndex) {
            return this.changeInfos.get(rowIndex);
        }

        @Override
        public int getRowCount() {
            return this.traceRows.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.traceRows.get(rowIndex).get(columnIndex);
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNames.get(columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        private void setColumnNames(AbstractAsyncTestcaseFolder testcaseFolder) {
            this.columnNames.add(AsynchronousTracePanel.this.traceViewer.getTranslation("async.traces.table.header.first.entry"));
            this.columnNames.add(AsynchronousTracePanel.this.traceViewer.getTranslation("async.traces.table.header.last.entry"));
            this.columnNames.addAll(testcaseFolder.getPrimaryKeyNames());
        }
    }

    private static class SortableTracesTableModel
    extends SortableTableModel {
        public SortableTracesTableModel(TableModel tableModel, AbstractAsyncTestcaseFolder testcaseFolder) {
            super(tableModel);
            this.setSortingColumns(this.createSortItems(testcaseFolder.getPrimaryKeyNames().size()));
        }

        private List<ISortableTableModel.SortItem> createSortItems(int numberOfPrimaryKeys) {
            int n = numberOfPrimaryKeys + 2;
            ArrayList<ISortableTableModel.SortItem> items = new ArrayList<ISortableTableModel.SortItem>(n);
            items.add(new ISortableTableModel.SortItem(1, false));
            items.add(new ISortableTableModel.SortItem(0, false));
            for (int i = 2; i < n; ++i) {
                items.add(new ISortableTableModel.SortItem(i, true));
            }
            return items;
        }
    }

    private static class TracesTable
    extends SortableTable {
        private TracesTable() {
        }

        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component comp = super.prepareRenderer(renderer, row, column);
            if (!this.isCellSelected(row, column) && !this.isCellEditable(row, column)) {
                int actualRow = TableModelWrapperUtils.getActualRowAt((TableModel)this.getModel(), (int)row);
                if (((TracesTableModel)TableModelWrapperUtils.getActualTableModel((TableModel)this.getModel())).hasChanged(actualRow)) {
                    Font font = comp.getFont();
                    comp.setFont(font.deriveFont(1));
                }
            }
            return comp;
        }
    }

    private class TracePanel
    extends JPanel
    implements EventExecuter {
        private final Map<AbstractAsyncTestcaseFolder.Key, TracesTable> traces = new HashMap<AbstractAsyncTestcaseFolder.Key, TracesTable>();
        private TracesTable tracesItem;
        private final MouseAdapter popupListener = this.createPopupListener();
        private final MouseAdapter doubleClickMouseListener = this.createDoubleClickMouseListener();
        private final JScrollPane scrollPane = new JScrollPane();
        private JButton getButton;
        private final boolean chooseDebugFile = Boolean.getBoolean("ch.e2e.builder.traceviewer.asyncResponse.log.choose.file");

        public TracePanel() {
            this.createGui();
            EventController.register((EventExecuter)this, RefreshIdentifiersEvent.class);
        }

        public void refresh() {
            if (AsynchronousTracePanel.this.root != null) {
                this.tracesItem = this.traces.computeIfAbsent(AsynchronousTracePanel.this.root.computeKey(), this::createTraces);
                this.scrollPane.setViewportView((Component)((Object)this.tracesItem));
            }
        }

        private TracesTable createTraces(AbstractAsyncTestcaseFolder.Key key) {
            this.tracesItem = new TracesTable();
            if (AsynchronousTracePanel.this.root != null) {
                this.tracesItem.setTableHeader((JTableHeader)this.createAutoFilterTableHeader());
                this.tracesItem.setShowVerticalLines(false);
                this.tracesItem.setSelectionMode(0);
                this.tracesItem.getSelectionModel().addListSelectionListener(this::traceSelected);
                this.tracesItem.addMouseWheelListener(this::mouseWheelMoved);
                this.tracesItem.addMouseListener(this.doubleClickMouseListener);
                this.tracesItem.addMouseListener(this.popupListener);
                this.tracesItem.setModel((TableModel)new FilterableTableModel((TableModel)((Object)new SortableTracesTableModel(new TracesTableModel(AsynchronousTracePanel.this.root), AsynchronousTracePanel.this.root))));
            }
            return this.tracesItem;
        }

        public Identifier getIdentifier() {
            int actualRow = TableModelWrapperUtils.getActualRowAt((TableModel)this.tracesItem.getModel(), (int)this.tracesItem.getSelectedRow());
            return this.getActualTableModel().getTrace(actualRow);
        }

        public void setTraces(List<Identifier> traces) {
            if (AsynchronousTracePanel.this.root != null) {
                this.getActualTableModel().setTraces(traces);
            }
        }

        private TracesTableModel getActualTableModel() {
            return (TracesTableModel)TableModelWrapperUtils.getActualTableModel((TableModel)this.tracesItem.getModel());
        }

        public void setSelectedIndex(int index) {
            this.tracesItem.getSelectionModel().setSelectionInterval(index, index);
        }

        public void execute(EventObject event) throws EventExecutionVetoException {
            AbstractAsyncTestcaseFolder testcaseFolder = (AbstractAsyncTestcaseFolder)((TestcaseEvent)event).getTestcaseObject();
            this.setTraces(testcaseFolder.getIdentifiers());
        }

        private void createGui() {
            this.setBorder(BorderFactory.createTitledBorder(AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.TITLE_TRACE)));
            this.setLayout(new BorderLayout(0, 10));
            this.add((Component)this.scrollPane, "Center");
            this.add((Component)this.createButtonsPanel(), "Last");
        }

        private AutoFilterTableHeader createAutoFilterTableHeader() {
            AutoFilterTableHeader header = new AutoFilterTableHeader((JTable)((Object)this.tracesItem));
            header.setAutoFilterEnabled(true);
            header.setUseNativeHeaderRenderer(true);
            return header;
        }

        private void traceSelected(ListSelectionEvent e) {
            boolean somethingSelected = !((ListSelectionModel)e.getSource()).isSelectionEmpty();
            this.getButton.setEnabled(somethingSelected || this.chooseDebugFile);
        }

        private void mouseWheelMoved(MouseWheelEvent e) {
            int index = ((TracesTable)((Object)e.getSource())).getSelectedRow();
            if (index != -1) {
                if (e.getWheelRotation() < 0) {
                    if (--index < 0) {
                        index = ((TracesTable)((Object)e.getSource())).getModel().getRowCount() - 1;
                    }
                } else if (++index == ((TracesTable)((Object)e.getSource())).getModel().getRowCount()) {
                    index = 0;
                }
                this.setSelectedIndex(index);
            }
        }

        private MouseAdapter createDoubleClickMouseListener() {
            return new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        new GetTraceAction().actionPerformed(new ActionEvent(e.getSource(), 1001, AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.BUTTON_GET_TRACE)));
                    }
                }
            };
        }

        private MouseAdapter createPopupListener() {
            ModulePopupMenu tracesPopup = new ModulePopupMenu((E2EBuilderModule)AsynchronousTracePanel.this.traceViewer);
            tracesPopup.add(new JMenuItem(new GetTraceAction()));
            return new MouseAdapter((JPopupMenu)tracesPopup){
                final /* synthetic */ JPopupMenu val$tracesPopup;
                {
                    this.val$tracesPopup = jPopupMenu;
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                private void maybeShowPopup(MouseEvent e) {
                    int index;
                    if ((e.isPopupTrigger() || e.getButton() == 3) && (index = ((TracesTable)((Object)e.getSource())).rowAtPoint(e.getPoint())) != -1) {
                        TracePanel.this.setSelectedIndex(index);
                        this.val$tracesPopup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            };
        }

        private JPanel createButtonsPanel() {
            JPanel panel = new JPanel();
            JButton listButton = new JButton(new ListTracesAction());
            listButton.setToolTipText(AsynchronousTracePanel.this.getTranslation("button.list.traces.tooltip"));
            listButton.setEnabled(!this.chooseDebugFile);
            panel.add(listButton);
            this.getButton = new JButton(new GetTraceAction());
            this.getButton.setToolTipText(AsynchronousTracePanel.this.getTranslation("button.get.trace.tooltip"));
            this.getButton.setEnabled(this.chooseDebugFile);
            panel.add(this.getButton);
            return panel;
        }

        private class GetTraceAction
        extends AbstractAction {
            public GetTraceAction() {
                super(AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.BUTTON_GET_TRACE));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Identifier identifier;
                if (AsynchronousTracePanel.this.root != null && (identifier = AsynchronousTracePanel.this.tracePanel.chooseDebugFile ? Identifier.createDummyIdentifier((AbstractAsyncTestcaseFolder)AsynchronousTracePanel.this.root) : AsynchronousTracePanel.this.tracePanel.getIdentifier()) != null) {
                    AbstractAsyncTestcaseFolder testcaseFolder = identifier.getParent();
                    AbstractAsynchronousTestcase testcase = (AbstractAsynchronousTestcase)testcaseFolder.getTestcase(identifier);
                    if (testcaseFolder instanceof AsynchronousTestcaseFolder) {
                        if (testcase == null) {
                            testcase = (AbstractAsynchronousTestcase)testcaseFolder.createTestcase(identifier);
                            this.fireTransactionEvent(testcase);
                        } else {
                            EventController.fire((EventObject)new RefreshAsynchronousTreeEvent((Object)this, (TestcaseObject)testcase));
                        }
                    } else if (testcaseFolder instanceof PersistentStateTestcaseFolder) {
                        if (testcase == null) {
                            testcase = (AbstractAsynchronousTestcase)testcaseFolder.createTestcase(identifier);
                            this.fireTransactionEvent(testcase);
                        } else if (identifier.equals((Object)testcase.getIdentifier())) {
                            EventController.fire((EventObject)new RefreshAsynchronousTreeEvent((Object)this, (TestcaseObject)testcase));
                        } else {
                            try {
                                testcaseFolder.delete((TestcaseObject)testcase);
                            }
                            catch (FilesNotDeletedException ex) {
                                for (File file : ex.getFiles()) {
                                    String msg = String.format("Could not delete %s '%s'", file.isDirectory() ? "directory" : "file", file.getPath());
                                    AsynchronousTracePanel.this.traceViewer.showError(msg);
                                }
                            }
                            testcase = (AbstractAsynchronousTestcase)testcaseFolder.createTestcase(identifier);
                            this.fireTransactionEvent(testcase);
                        }
                    } else {
                        throw new IllegalStateException(String.format("Unknown type of test case folder (%s).", testcaseFolder.getClass()));
                    }
                }
            }

            private void fireTransactionEvent(AbstractAsynchronousTestcase testcase) {
                AsyncTraceTransactionFactory.fireTransaction((Object)this, AsyncTraceAction.GET_TRACE, (E2EBuilderModule)AsynchronousTracePanel.this.traceViewer, testcase);
            }
        }

        private class ListTracesAction
        extends AbstractAction {
            public ListTracesAction() {
                super(AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.BUTTON_LIST_TRACES));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AsynchronousTracePanel.this.root != null) {
                    AsyncTraceTransactionFactory.fireTransaction((Object)this, AsyncTraceAction.GET_IDENTIFIERS, (E2EBuilderModule)AsynchronousTracePanel.this.traceViewer, AsynchronousTracePanel.this.root);
                }
            }
        }
    }

    private class ConfigurationPanel
    extends JPanel
    implements EventExecuter {
        private final String CLASSIFIER;
        private final String OPERATION;
        private JLabel classifierLabel;
        private JTextField classifierItem;
        private JComboBox<String> traceLevelItem;
        private JSpinner traceMaxSizeItem;
        private InspectionListDialog inspectionListDialog;
        private Collection<String> inspectionIds;
        private JLabel statusItem;
        private Status status;

        public ConfigurationPanel() {
            this.CLASSIFIER = AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.LABEL_CLASSIFIER) + ":";
            this.OPERATION = AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.LABEL_OPERATION) + ":";
            this.createGui();
            EventController.register((EventExecuter)this, RefreshConfigurationEvent.class);
        }

        public TraceSettings.TraceLevel getTraceLevel() {
            return TraceSettings.TraceLevel.valueOf((int)this.traceLevelItem.getSelectedIndex());
        }

        private void setTraceLevel(TraceSettings.TraceLevel traceLevel) {
            this.traceLevelItem.setSelectedIndex(traceLevel.getMode());
        }

        public int getTraceMaxSize() {
            return (Integer)this.traceMaxSizeItem.getValue();
        }

        private void setTraceMaxSize(int maxSize) {
            this.traceMaxSizeItem.setValue(maxSize);
        }

        public Collection<String> getInspectionIds() {
            return this.getInspectionListDialog().getInspectionIds();
        }

        private void setInspectionIds(Collection<String> inspectionIds) {
            this.inspectionIds = inspectionIds;
            if (AsynchronousTracePanel.this.root != null) {
                AsynchronousTracePanel.this.root.setProposedConfiguration(new AbstractAsyncTestcaseFolder.Configuration(this.getTraceLevel(), this.getTraceMaxSize(), inspectionIds));
                AsynchronousTracePanel.this.root.saveProperties();
            }
        }

        private void updateStatus(boolean settingsChanged) {
            if (settingsChanged) {
                AsynchronousTracePanel.this.root.saveProperties();
            }
            this.statusItem.setText(AsynchronousTracePanel.this.getTranslation(settingsChanged && this.status == Status.activated ? "status." + (Object)((Object)this.status) + ".settings.changed" : "status." + (Object)((Object)this.status)));
        }

        public void refresh() {
            TraceSettings.TraceLevel traceLevel = DEFAULT_TRACE_LEVEL;
            int traceMaxSize = DEFAULT_TRACE_MAX_SIZE;
            Collection<String> inspectionIds = Collections.emptyList();
            this.status = Status.unknown;
            String classifier = null;
            if (AsynchronousTracePanel.this.root != null) {
                classifier = AsynchronousTracePanel.this.root.getName();
                this.classifierLabel.setText(this.getClassifierLabelText());
                if (AsynchronousTracePanel.this.root.getProposedTraceLevel() != TraceSettings.TraceLevel.None) {
                    traceLevel = AsynchronousTracePanel.this.root.getProposedTraceLevel();
                }
                if (AsynchronousTracePanel.this.root.getProposedTraceMaxSize() != -1) {
                    AsynchronousTracePanel.this.root.getProposedTraceMaxSize();
                }
                if (!AsynchronousTracePanel.this.root.getProposedInspectionIds().isEmpty()) {
                    inspectionIds = AsynchronousTracePanel.this.root.getProposedInspectionIds();
                }
                if (AsynchronousTracePanel.this.root.hasConfiguration()) {
                    if (AsynchronousTracePanel.this.root.getConfiguration().isEmpty()) {
                        this.status = Status.deactivated;
                    } else {
                        traceLevel = AsynchronousTracePanel.this.root.getTraceLevel();
                        traceMaxSize = AsynchronousTracePanel.this.root.getTraceMaxSize();
                        inspectionIds = AsynchronousTracePanel.this.root.getInspectionIds();
                        this.status = Status.activated;
                    }
                }
            }
            this.classifierItem.setText(classifier);
            this.setTraceLevel(traceLevel);
            this.setTraceMaxSize(traceMaxSize);
            this.setInspectionIds(inspectionIds);
            this.updateStatus(false);
        }

        private void createGui() {
            this.setBorder(BorderFactory.createTitledBorder(AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.TITLE_CONFIGURATION)));
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.createConfigurationPanel());
            this.add(this.createButtonsPanel());
        }

        private JPanel createConfigurationPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints labelConstraints = new GridBagConstraints();
            labelConstraints.gridx = 0;
            labelConstraints.fill = 0;
            labelConstraints.anchor = 21;
            labelConstraints.insets = new Insets(0, 5, 10, 5);
            GridBagConstraints valueConstraints = new GridBagConstraints();
            valueConstraints.gridx = 1;
            valueConstraints.weightx = 1.0;
            valueConstraints.fill = 2;
            valueConstraints.insets = new Insets(0, 5, 10, 5);
            this.classifierLabel = new JLabel(this.CLASSIFIER);
            this.classifierItem = new JTextField();
            this.classifierItem.setEditable(false);
            panel.add((Component)this.classifierLabel, labelConstraints);
            panel.add((Component)this.classifierItem, valueConstraints);
            valueConstraints.gridy = 1;
            labelConstraints.gridy = 1;
            JLabel label = new JLabel(AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.LABEL_TRACE_LEVEL) + ":");
            EnumSet<TraceSettings.TraceLevel> levels = EnumSet.allOf(TraceSettings.TraceLevel.class);
            levels.remove(TraceSettings.TraceLevel.None);
            String[] levelStrings = new String[levels.size()];
            for (TraceSettings.TraceLevel level : levels) {
                levelStrings[level.getMode()] = AsynchronousTracePanel.this.getTranslation("level." + level.toString().toLowerCase());
            }
            this.traceLevelItem = new JComboBox<String>(levelStrings);
            panel.add((Component)label, labelConstraints);
            this.traceLevelItem.addItemListener(e -> {
                if (AsynchronousTracePanel.this.root != null && e.getStateChange() == 1) {
                    AsynchronousTracePanel.this.root.setProposedConfiguration(new AbstractAsyncTestcaseFolder.Configuration(this.getTraceLevel(), AsynchronousTracePanel.this.root.getProposedTraceMaxSize(), AsynchronousTracePanel.this.root.getProposedInspectionIds()));
                    this.updateStatus(true);
                }
            });
            this.traceLevelItem.addMouseWheelListener(e -> {
                int index = this.traceLevelItem.getSelectedIndex();
                if (e.getWheelRotation() < 0) {
                    if (--index < 0) {
                        index = TraceSettings.TraceLevel.values().length - 2;
                    }
                } else if (++index == TraceSettings.TraceLevel.values().length - 1) {
                    index = 0;
                }
                this.traceLevelItem.setSelectedIndex(index);
            });
            panel.add(this.traceLevelItem, valueConstraints);
            valueConstraints.gridy = 2;
            labelConstraints.gridy = 2;
            label = new JLabel(AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.LABEL_MAX_SIZE) + ":");
            SpinnerNumberModel spinnerModel = new SpinnerNumberModel(10, 1, 1000, 1);
            this.traceMaxSizeItem = new JSpinner(spinnerModel);
            this.traceMaxSizeItem.addChangeListener(e -> {
                AsynchronousTracePanel.this.root.setProposedConfiguration(new AbstractAsyncTestcaseFolder.Configuration(AsynchronousTracePanel.this.root.getProposedTraceLevel(), spinnerModel.getNumber().intValue(), AsynchronousTracePanel.this.root.getProposedInspectionIds()));
                this.updateStatus(true);
            });
            this.traceMaxSizeItem.addMouseWheelListener(e -> {
                Object value = e.getWheelRotation() < 0 ? spinnerModel.getNextValue() : spinnerModel.getPreviousValue();
                if (value != null) {
                    spinnerModel.setValue(value);
                }
            });
            panel.add((Component)label, labelConstraints);
            panel.add((Component)this.traceMaxSizeItem, valueConstraints);
            valueConstraints.gridy = 3;
            labelConstraints.gridy = 3;
            JButton inspectionListItem = new JButton(AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.BUTTON_INSPECTION_LIST));
            inspectionListItem.setToolTipText(AsynchronousTracePanel.this.getTranslation("button.inspection.list.tooltip"));
            inspectionListItem.addActionListener(e -> {
                InspectionListDialog dialog = this.getInspectionListDialog();
                dialog.setInspectionList(new File(AsynchronousTracePanel.this.root.getHome().getParentFile(), "inspection.list"), this.inspectionIds);
                if (dialog.showDialog() == 1) {
                    this.setInspectionIds(dialog.getInspectionIds());
                    this.updateStatus(true);
                }
            });
            panel.add((Component)inspectionListItem, labelConstraints);
            label = new JLabel("Status:");
            valueConstraints.gridy = 4;
            labelConstraints.gridy = 4;
            panel.add((Component)label, labelConstraints);
            this.statusItem = new JLabel("Unknown");
            panel.add((Component)this.statusItem, valueConstraints);
            return panel;
        }

        private JPanel createButtonsPanel() {
            JPanel panel = new JPanel();
            JButton button = new JButton(new GetConfigurationAction());
            button.setToolTipText(AsynchronousTracePanel.this.getTranslation("button.get.configuration.tooltip"));
            panel.add(button);
            button = new JButton(new SetConfigurationAction());
            button.setToolTipText(AsynchronousTracePanel.this.getTranslation("button.set.configuration.tooltip"));
            panel.add(button);
            button = new JButton(new DeleteConfigurationAction());
            button.setToolTipText(AsynchronousTracePanel.this.getTranslation("button.delete.configuration.tooltip"));
            panel.add(button);
            return panel;
        }

        private String getClassifierLabelText() {
            return AsynchronousTracePanel.this.root instanceof PersistentStateTestcaseFolder ? this.CLASSIFIER : this.OPERATION;
        }

        public void execute(EventObject event) throws EventExecutionVetoException {
            AbstractAsyncTestcaseFolder testcaseFolder = (AbstractAsyncTestcaseFolder)((TestcaseEvent)event).getTestcaseObject();
            TraceSettings.TraceLevel traceLevel = DEFAULT_TRACE_LEVEL;
            int traceMaxSize = DEFAULT_TRACE_MAX_SIZE;
            Collection<String> inspectionIds = Collections.emptyList();
            this.status = Status.unknown;
            if (testcaseFolder != null) {
                if (AsynchronousTracePanel.this.root == null) {
                    AsynchronousTracePanel.this.setRoot(testcaseFolder);
                }
                if (AsynchronousTracePanel.this.root.getProposedTraceLevel() != TraceSettings.TraceLevel.None) {
                    traceLevel = AsynchronousTracePanel.this.root.getProposedTraceLevel();
                }
                if (AsynchronousTracePanel.this.root.getProposedTraceMaxSize() != -1) {
                    AsynchronousTracePanel.this.root.getProposedTraceMaxSize();
                }
                if (!AsynchronousTracePanel.this.root.getProposedInspectionIds().isEmpty()) {
                    inspectionIds = AsynchronousTracePanel.this.root.getProposedInspectionIds();
                }
                if (testcaseFolder.hasConfiguration()) {
                    if (testcaseFolder.getConfiguration().isEmpty()) {
                        this.status = Status.deactivated;
                    } else {
                        traceLevel = testcaseFolder.getTraceLevel();
                        traceMaxSize = testcaseFolder.getTraceMaxSize();
                        inspectionIds = testcaseFolder.getInspectionIds();
                        this.status = Status.activated;
                    }
                }
            }
            this.setTraceLevel(traceLevel);
            this.setTraceMaxSize(traceMaxSize);
            this.setInspectionIds(inspectionIds);
            this.updateStatus(false);
        }

        private InspectionListDialog getInspectionListDialog() {
            if (this.inspectionListDialog == null) {
                this.inspectionListDialog = new InspectionListDialog();
            }
            return this.inspectionListDialog;
        }

        private class DeleteConfigurationAction
        extends AbstractAction {
            public DeleteConfigurationAction() {
                super(AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.BUTTON_DELETE_CONFIGURATION));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AsynchronousTracePanel.this.root != null) {
                    AsyncTraceTransactionFactory.fireTransaction((Object)this, AsyncTraceAction.DELETE_CONFIGURATION, (E2EBuilderModule)AsynchronousTracePanel.this.traceViewer, AsynchronousTracePanel.this.root);
                }
            }
        }

        private class SetConfigurationAction
        extends AbstractAction {
            public SetConfigurationAction() {
                super(AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.BUTTON_SET_CONFIGURATION));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AsynchronousTracePanel.this.root != null) {
                    AbstractAsyncTestcaseFolder.Configuration configuration = new AbstractAsyncTestcaseFolder.Configuration(AsynchronousTracePanel.this.configPanel.getTraceLevel(), AsynchronousTracePanel.this.configPanel.getTraceMaxSize(), AsynchronousTracePanel.this.configPanel.getInspectionIds());
                    AsyncTraceTransactionFactory.fireTransaction(this, AsyncTraceAction.SET_CONFIGURATION, (E2EBuilderModule)AsynchronousTracePanel.this.traceViewer, AsynchronousTracePanel.this.root, configuration);
                }
            }
        }

        private class GetConfigurationAction
        extends AbstractAction {
            public GetConfigurationAction() {
                super(AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.BUTTON_GET_CONFIGURATION));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AsynchronousTracePanel.this.root != null) {
                    AsynchronousTracePanel.this.root.setConfiguration(null);
                    ConfigurationPanel.this.statusItem.setText("Unknown");
                    AsyncTraceTransactionFactory.fireTransaction((Object)this, AsyncTraceAction.GET_CONFIGURATION, (E2EBuilderModule)AsynchronousTracePanel.this.traceViewer, AsynchronousTracePanel.this.root);
                }
            }
        }
    }

    private class LocationPanel
    extends JPanel
    implements EventExecuter {
        private static final String TRACE_SERVLET_PATH = "/admin/trace/";
        private JRadioButton systemLocationButton;
        private JRadioButton customLocationButton;
        private JRadioButton bridgeLocationButton;
        private JTextField systemLocationItem;
        private JTextField customLocationItem;
        private JCheckBox useOAuth2Item;
        private JTextField oAuth2UsernameItem;
        private JPasswordField oAuth2PasswordItem;
        private JComboBox<String> bridgeProtocolItem;
        private JTextField bridgeHostItem;
        private JTextField bridgePortItem;
        private JTextField bridgeUserItem;
        private JPasswordField bridgePasswordItem;
        private JTextField bridgePathPrefixItem;
        private JTextField bridgeServiceItem;
        private final LocationListener systemLocationListener = new LocationListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (AsynchronousTracePanel.this.root != null && e.getStateChange() == 1) {
                    AsynchronousTracePanel.this.root.setSelectedLocationType(AbstractAsyncTestcaseFolder.LocationType.SYSTEM);
                    if (this.isActive()) {
                        AsynchronousTracePanel.this.root.saveProperties();
                    }
                    AsynchronousTracePanel.this.configPanel.refresh();
                    AsynchronousTracePanel.this.tracePanel.refresh();
                }
            }
        };
        private final LocationListener customLocationListener = new LocationListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                LocationPanel.this.customLocationItem.setEditable(selected);
                LocationPanel.this.customLocationItem.setOpaque(selected);
                LocationPanel.this.useOAuth2Item.setEnabled(selected);
                LocationPanel.this.oAuth2UsernameItem.setEditable(selected);
                LocationPanel.this.oAuth2UsernameItem.setOpaque(selected);
                LocationPanel.this.oAuth2PasswordItem.setEditable(selected);
                LocationPanel.this.oAuth2PasswordItem.setOpaque(selected);
                if (selected) {
                    String location;
                    AsynchronousTracePanel.this.root.setSelectedLocationType(AbstractAsyncTestcaseFolder.LocationType.CUSTOM);
                    if (this.isActive() && (location = LocationPanel.this.customLocationItem.getText().trim()).isEmpty()) {
                        LocationPanel.this.customLocationItem.setText(LocationPanel.this.systemLocationItem.getText());
                        AsynchronousTracePanel.this.root.setCustomLocation(LocationPanel.this.systemLocationItem.getText());
                        AsynchronousTracePanel.this.root.saveProperties();
                    }
                    AsynchronousTracePanel.this.configPanel.refresh();
                    AsynchronousTracePanel.this.tracePanel.refresh();
                }
            }
        };
        private final LocationListener bridgeLocationListener = new LocationListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                LocationPanel.this.bridgeProtocolItem.setEnabled(selected);
                LocationPanel.this.bridgeProtocolItem.setOpaque(selected);
                LocationPanel.this.bridgeHostItem.setEditable(selected);
                LocationPanel.this.bridgeHostItem.setOpaque(selected);
                LocationPanel.this.bridgePortItem.setEditable(selected);
                LocationPanel.this.bridgePortItem.setOpaque(selected);
                LocationPanel.this.bridgeUserItem.setEditable(selected);
                LocationPanel.this.bridgeUserItem.setOpaque(selected);
                LocationPanel.this.bridgePasswordItem.setEditable(selected);
                LocationPanel.this.bridgePasswordItem.setOpaque(selected);
                LocationPanel.this.bridgePathPrefixItem.setEditable(selected);
                LocationPanel.this.bridgePathPrefixItem.setOpaque(selected);
                LocationPanel.this.bridgeServiceItem.setEditable(selected);
                LocationPanel.this.bridgeServiceItem.setOpaque(selected);
                if (selected) {
                    AsynchronousTracePanel.this.root.setSelectedLocationType(AbstractAsyncTestcaseFolder.LocationType.BRIDGE);
                    if (this.isActive()) {
                        String serviceName;
                        String port;
                        boolean changed = false;
                        String host = LocationPanel.this.bridgeHostItem.getText().trim();
                        if (host.isEmpty()) {
                            host = "localhost";
                            LocationPanel.this.bridgeHostItem.setText(host);
                            changed = true;
                        }
                        if ((port = LocationPanel.this.bridgePortItem.getText().trim()).isEmpty()) {
                            port = "8080";
                            LocationPanel.this.bridgePortItem.setText(port);
                            changed = true;
                        }
                        if ((serviceName = LocationPanel.this.bridgeServiceItem.getText().trim()).isEmpty()) {
                            serviceName = AsynchronousTracePanel.this.root.getServiceName();
                            LocationPanel.this.bridgeServiceItem.setText(serviceName);
                            changed = true;
                        }
                        if (changed) {
                            AsynchronousTracePanel.this.root.setBridgeLocation(LocationPanel.this.getBridgeUri((String)LocationPanel.this.bridgeProtocolItem.getSelectedItem(), host, port, LocationPanel.this.bridgePathPrefixItem.getText().trim(), serviceName));
                        }
                        AsynchronousTracePanel.this.root.saveProperties();
                        AsynchronousTracePanel.this.configPanel.refresh();
                        AsynchronousTracePanel.this.tracePanel.refresh();
                    }
                }
            }
        };

        public LocationPanel() {
            this.createGui();
        }

        public void refresh() {
            this.refreshSystemLocation();
            this.refreshCustomLocation();
            this.refreshBridgeLocation();
            this.refreshButtonStates();
        }

        private void refreshSystemLocation() {
            this.systemLocationItem.setText(AsynchronousTracePanel.this.root == null ? null : AsynchronousTracePanel.this.root.getSystemRestLocation());
        }

        private void refreshCustomLocation() {
            this.customLocationItem.setText(AsynchronousTracePanel.this.root == null ? null : AsynchronousTracePanel.this.root.getCustomLocation());
            this.useOAuth2Item.setSelected(AsynchronousTracePanel.this.root != null && AsynchronousTracePanel.this.root.isUseOAuth2());
            this.oAuth2UsernameItem.setText(AsynchronousTracePanel.this.root == null ? null : AsynchronousTracePanel.this.root.getOAuth2Username());
            this.oAuth2PasswordItem.setText(AsynchronousTracePanel.this.root == null ? null : AsynchronousTracePanel.this.root.getOAuth2Password());
        }

        private void refreshBridgeLocation() {
            String serviceName;
            String location = AsynchronousTracePanel.this.root == null ? null : AsynchronousTracePanel.this.root.getBridgeLocation();
            String protocol = null;
            String host = null;
            String port = null;
            String pathPrefix = null;
            String string = serviceName = AsynchronousTracePanel.this.root == null ? null : AsynchronousTracePanel.this.root.getServiceName();
            if (location != null) {
                try {
                    URI uri = new URI(location);
                    protocol = uri.getScheme();
                    host = uri.getHost();
                    port = String.valueOf(uri.getPort() == -1 ? "" : Integer.valueOf(uri.getPort()));
                    pathPrefix = this.getPathPrefix(uri);
                    AsynchronousTracePanel.this.root.maybeFixBridgeLocation();
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            this.bridgeProtocolItem.setSelectedItem(protocol);
            this.bridgeHostItem.setText(host);
            this.bridgePortItem.setText(port);
            this.bridgeUserItem.setText(AsynchronousTracePanel.this.root == null ? null : AsynchronousTracePanel.this.root.getBridgeUser());
            this.bridgePasswordItem.setText(AsynchronousTracePanel.this.root == null ? null : AsynchronousTracePanel.this.root.getBridgePassword());
            this.bridgePathPrefixItem.setText(pathPrefix);
            this.bridgeServiceItem.setText(serviceName);
        }

        private String getPathPrefix(URI uri) {
            String path = uri.getPath();
            String pathPrefix = path.substring(0, path.indexOf(TRACE_SERVLET_PATH));
            return pathPrefix;
        }

        private void refreshButtonStates() {
            AbstractAsyncTestcaseFolder.LocationType selectedLocationType = AsynchronousTracePanel.this.root == null ? AbstractAsyncTestcaseFolder.LocationType.SYSTEM : AsynchronousTracePanel.this.root.getSelectedLocationType();
            this.systemLocationListener.setActive(false);
            this.customLocationListener.setActive(false);
            this.bridgeLocationListener.setActive(false);
            this.systemLocationButton.setSelected(selectedLocationType.equals((Object)AbstractAsyncTestcaseFolder.LocationType.SYSTEM));
            this.customLocationButton.setSelected(selectedLocationType.equals((Object)AbstractAsyncTestcaseFolder.LocationType.CUSTOM));
            this.bridgeLocationButton.setSelected(selectedLocationType.equals((Object)AbstractAsyncTestcaseFolder.LocationType.BRIDGE));
            this.systemLocationListener.setActive(true);
            this.customLocationListener.setActive(true);
            this.bridgeLocationListener.setActive(true);
        }

        public void execute(EventObject event) throws EventExecutionVetoException {
        }

        private void createGui() {
            this.setBorder(BorderFactory.createTitledBorder(AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.TITLE_LOCATION)));
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.createLocationPanel());
            this.add(this.createButtonsPanel());
        }

        private JPanel createLocationPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            ButtonGroup group = new ButtonGroup();
            GridBagConstraints buttonConstraints = this.buttonConstraints();
            GridBagConstraints itemConstraints = this.itemConstraints();
            this.createSystemLocationButton(panel, buttonConstraints, group);
            this.createSystemLocationItem(panel, itemConstraints);
            this.createCustomLocationButton(panel, buttonConstraints, group);
            this.createCustomLocationItem(panel, itemConstraints);
            this.createBridgeLocationButton(panel, buttonConstraints, group);
            itemConstraints.insets = new Insets(-4, 0, 5, 5);
            this.createBridgeLocationItems(panel, itemConstraints);
            return panel;
        }

        private GridBagConstraints buttonConstraints() {
            GridBagConstraints buttonConstraints = new GridBagConstraints();
            buttonConstraints.gridx = 0;
            buttonConstraints.fill = 0;
            buttonConstraints.anchor = 23;
            buttonConstraints.insets = new Insets(0, 0, 5, 5);
            return buttonConstraints;
        }

        private GridBagConstraints itemConstraints() {
            GridBagConstraints valueConstraints = new GridBagConstraints();
            valueConstraints.gridx = 1;
            valueConstraints.weightx = 1.0;
            valueConstraints.fill = 2;
            valueConstraints.insets = new Insets(0, 5, 5, 5);
            return valueConstraints;
        }

        private void createSystemLocationButton(JPanel panel, GridBagConstraints buttonConstraints, ButtonGroup group) {
            this.systemLocationButton = new JRadioButton(AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.BUTTON_SYSTEM_LOCATION) + ":");
            this.systemLocationButton.setSelected(true);
            this.systemLocationButton.addItemListener(this.systemLocationListener);
            group.add(this.systemLocationButton);
            panel.add((Component)this.systemLocationButton, buttonConstraints);
        }

        private void createSystemLocationItem(JPanel panel, GridBagConstraints valueConstraints) {
            this.systemLocationItem = new JTextField();
            this.systemLocationItem.setEditable(false);
            this.systemLocationItem.setOpaque(false);
            panel.add((Component)this.systemLocationItem, valueConstraints);
        }

        private void createCustomLocationButton(JPanel panel, GridBagConstraints buttonConstraints, ButtonGroup group) {
            this.customLocationButton = new JRadioButton(AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.BUTTON_CUSTOM_LOCATION) + ":");
            this.customLocationButton.addItemListener(this.customLocationListener);
            group.add(this.customLocationButton);
            panel.add((Component)this.customLocationButton, buttonConstraints);
        }

        private void createCustomLocationItem(JPanel panel, GridBagConstraints valueConstraints) {
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 1;
            c.weightx = 1.0;
            c.fill = 2;
            JPanel customLocationPanel = new JPanel(new GridBagLayout());
            this.customLocationItem = new JTextField();
            this.customLocationItem.setEditable(false);
            this.customLocationItem.setOpaque(false);
            this.customLocationItem.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    String customLocation;
                    if (LocationPanel.this.customLocationButton.isSelected() && !(customLocation = LocationPanel.this.customLocationItem.getText().trim()).equals(AsynchronousTracePanel.this.root.getCustomLocation())) {
                        AsynchronousTracePanel.this.root.setCustomLocation(customLocation);
                        AsynchronousTracePanel.this.root.saveProperties();
                    }
                }
            });
            customLocationPanel.add((Component)this.customLocationItem, c);
            JPanel oAuth2Panel = new JPanel(new FlowLayout(3, 0, 0));
            this.useOAuth2Item = new JCheckBox(AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.LABEL_USE_OAUTH2));
            this.useOAuth2Item.setEnabled(false);
            this.useOAuth2Item.addItemListener(e -> {
                boolean useOAuth2;
                boolean bl = useOAuth2 = e.getStateChange() == 1;
                if (AsynchronousTracePanel.this.root != null && useOAuth2 != AsynchronousTracePanel.this.root.isUseOAuth2()) {
                    AsynchronousTracePanel.this.root.setUseOAuth2(useOAuth2);
                    AsynchronousTracePanel.this.root.saveProperties();
                }
            });
            oAuth2Panel.add(this.useOAuth2Item);
            this.oAuth2UsernameItem = this.createItem(oAuth2Panel, AsynchronousTracePanel.LABEL_OAUTH2_USER, new JTextField(15), (FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    String username = LocationPanel.this.oAuth2UsernameItem.getText().trim();
                    if (!username.equals(AsynchronousTracePanel.this.root.getOAuth2Username())) {
                        AsynchronousTracePanel.this.root.setOAuth2Username(username);
                        AsynchronousTracePanel.this.root.saveProperties();
                    }
                }
            });
            this.oAuth2PasswordItem = this.createItem(oAuth2Panel, AsynchronousTracePanel.LABEL_OAUTH2_PASSWORD, new JPasswordField(10), (FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    String password = LocationPanel.this.oAuth2PasswordItem.getText().trim();
                    if (!password.equals(AsynchronousTracePanel.this.root.getOAuth2Password())) {
                        AsynchronousTracePanel.this.root.setOAuth2Password(password);
                        AsynchronousTracePanel.this.root.saveProperties();
                    }
                }
            });
            customLocationPanel.add((Component)oAuth2Panel, c);
            panel.add((Component)customLocationPanel, valueConstraints);
        }

        private void createBridgeLocationButton(JPanel panel, GridBagConstraints buttonConstraints, ButtonGroup group) {
            this.bridgeLocationButton = new JRadioButton(AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.BUTTON_BRIDGE_LOCATION) + ":");
            this.bridgeLocationButton.addItemListener(this.bridgeLocationListener);
            group.add(this.bridgeLocationButton);
            panel.add((Component)this.bridgeLocationButton, buttonConstraints);
        }

        private void createBridgeLocationItems(JPanel panel, GridBagConstraints valueConstraints) {
            JPanel firstLine = new JPanel(new FlowLayout(3, 0, 0));
            this.createBridgeProtocolItem(firstLine);
            this.createBridgeHostItem(firstLine);
            this.createBridgePortItem(firstLine);
            this.createBridgePathPrefixItem(firstLine);
            this.createBridgeServiceItem(firstLine);
            JPanel secondLine = new JPanel(new FlowLayout(3, 0, 0));
            this.createBridgeUserItem(secondLine);
            this.createBridgePasswordItem(secondLine);
            JPanel bridgePanel = new JPanel();
            bridgePanel.setLayout(new BoxLayout(bridgePanel, 1));
            bridgePanel.add(firstLine);
            bridgePanel.add(secondLine);
            panel.add((Component)bridgePanel, valueConstraints);
        }

        private void createBridgeProtocolItem(JPanel bridgePanel) {
            this.bridgeProtocolItem = this.createBridgeItem(bridgePanel, AsynchronousTracePanel.LABEL_BRIDGE_PROTOCOL, new JComboBox<String>(new String[]{"https", "http"}));
        }

        private void createBridgeHostItem(JPanel bridgePanel) {
            this.bridgeHostItem = this.createBridgeItem(bridgePanel, AsynchronousTracePanel.LABEL_BRIDGE_HOST, new JTextField(15));
        }

        private void createBridgePortItem(JPanel bridgePanel) {
            this.bridgePortItem = this.createBridgeItem(bridgePanel, AsynchronousTracePanel.LABEL_BRIDGE_PORT, new JTextField(5));
        }

        private void createBridgePathPrefixItem(JPanel bridgePanel) {
            this.bridgePathPrefixItem = this.createBridgeItem(bridgePanel, AsynchronousTracePanel.LABEL_BRIDGE_PATH_PREFIX, new JTextField(15));
        }

        private void createBridgeServiceItem(JPanel bridgePanel) {
            this.bridgeServiceItem = this.createBridgeItem(bridgePanel, AsynchronousTracePanel.LABEL_BRIDGE_SERVICE, new JTextField(15));
        }

        private void createBridgeUserItem(JPanel bridgePanel) {
            this.bridgeUserItem = this.createItem(bridgePanel, AsynchronousTracePanel.LABEL_BRIDGE_USER, new JTextField(10), (FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    String bridgeUser = LocationPanel.this.bridgeUserItem.getText().trim();
                    if (!bridgeUser.equals(AsynchronousTracePanel.this.root.getBridgeUser())) {
                        AsynchronousTracePanel.this.root.setBridgeUser(bridgeUser.isEmpty() ? null : bridgeUser);
                        AsynchronousTracePanel.this.root.saveProperties();
                    }
                }
            });
        }

        private void createBridgePasswordItem(JPanel bridgePanel) {
            this.bridgePasswordItem = this.createItem(bridgePanel, AsynchronousTracePanel.LABEL_BRIDGE_PASSWORD, new JPasswordField(10), (FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    String bridgePassword = LocationPanel.this.bridgePasswordItem.getText().trim();
                    if (!bridgePassword.equals(AsynchronousTracePanel.this.root.getBridgePassword())) {
                        AsynchronousTracePanel.this.root.setBridgePassword(bridgePassword.isEmpty() ? null : bridgePassword);
                    }
                }
            });
        }

        private <T extends JTextComponent> T createBridgeItem(JPanel bridgePanel, String labelId, T item) {
            return this.createItem(bridgePanel, labelId, item, (FocusListener)new BridgeLocationFocusAdapter());
        }

        private <E> JComboBox<E> createBridgeItem(JPanel bridgePanel, String labelId, JComboBox<E> item) {
            return this.createItem(bridgePanel, labelId, item, (FocusListener)new BridgeLocationFocusAdapter());
        }

        private <T extends JTextComponent> T createItem(JPanel bridgePanel, String labelId, T item, FocusListener focusListener) {
            this.createItem(bridgePanel, labelId, item, focusListener);
            item.setEditable(false);
            return item;
        }

        private <T extends JComponent> T createItem(JPanel bridgePanel, String labelId, T item, FocusListener focusListener) {
            item.setOpaque(false);
            item.addFocusListener(focusListener);
            JPanel itemPanel = new JPanel();
            itemPanel.add(new JLabel(AsynchronousTracePanel.this.getTranslation(labelId) + ":"));
            itemPanel.add(item);
            bridgePanel.add(itemPanel);
            return item;
        }

        private <E> JComboBox<E> createItem(JPanel bridgePanel, String labelId, JComboBox<E> item, FocusListener focusListener) {
            this.createItem(bridgePanel, labelId, (JComponent)item, focusListener);
            item.setEnabled(false);
            return item;
        }

        private JPanel createButtonsPanel() {
            JPanel panel = new JPanel();
            JButton button = new JButton(new DeleteAllTracesAction());
            button.setToolTipText(AsynchronousTracePanel.this.getTranslation("button.clear.all.tooltip"));
            panel.add(button);
            return panel;
        }

        private String getBridgeUri(String protocol, String host, String port, String pathPrefix, String serviceName) {
            StringBuilder pathBuilder = new StringBuilder();
            if (!pathPrefix.isEmpty() && !pathPrefix.startsWith("/")) {
                pathBuilder.append("/");
            }
            pathBuilder.append(pathPrefix).append(TRACE_SERVLET_PATH).append(serviceName);
            return protocol + "://" + host + ":" + port + pathBuilder;
        }

        private class BridgeLocationFocusAdapter
        extends FocusAdapter {
            private BridgeLocationFocusAdapter() {
            }

            @Override
            public void focusLost(FocusEvent e) {
                String bridgeLocation;
                if (LocationPanel.this.bridgeLocationButton.isSelected() && !(bridgeLocation = LocationPanel.this.getBridgeUri((String)LocationPanel.this.bridgeProtocolItem.getSelectedItem(), LocationPanel.this.bridgeHostItem.getText().trim(), LocationPanel.this.bridgePortItem.getText().trim(), LocationPanel.this.bridgePathPrefixItem.getText().trim(), LocationPanel.this.bridgeServiceItem.getText().trim())).equals(AsynchronousTracePanel.this.root.getBridgeLocation())) {
                    AsynchronousTracePanel.this.root.setBridgeLocation(bridgeLocation);
                    AsynchronousTracePanel.this.root.saveProperties();
                }
            }
        }

        private abstract class LocationListener
        implements ItemListener {
            private boolean active = true;

            private LocationListener() {
            }

            public boolean isActive() {
                return this.active;
            }

            public void setActive(boolean active) {
                this.active = active;
            }
        }

        private class DeleteAllTracesAction
        extends AbstractAction {
            private DeleteAllTracesAction() {
                super(AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.BUTTON_DELETE_ALL_TRACES));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String question;
                String subtitle;
                String title;
                if (AsynchronousTracePanel.this.root != null && E2EBuilderQuestionDialog.doYesNoQuestion((String)(title = AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.QUESTION_CLEAR_ALL_TITLE)), (String)(subtitle = AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.QUESTION_CLEAR_ALL_SUBTITLE)), (String)(question = AsynchronousTracePanel.this.getTranslation(AsynchronousTracePanel.QUESTION_CLEAR_ALL_QUESTION)))) {
                    AsyncTraceTransactionFactory.fireTransaction((Object)this, AsyncTraceAction.DELETE_ALL_TRACES, (E2EBuilderModule)AsynchronousTracePanel.this.traceViewer, AsynchronousTracePanel.this.root);
                }
            }
        }
    }
}

