/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.filechooser;

import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.swing.ModalDialog;
import ch.e2e.swing.filechooser.DirectoryField;
import ch.e2e.swing.filechooser.DirectoryList;
import ch.e2e.swing.model.Directory;
import ch.e2e.swing.model.FileListModelExtension;
import ch.e2e.swing.util.DirectoryFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.border.EmptyBorder;

public class DirectoryListChooser
extends ModalDialog {
    private DirectoryList directoryList;
    private DirectoryField dirField;

    public DirectoryListChooser(JDialog owner, String title) {
        this(owner, title, null, null, null);
    }

    public DirectoryListChooser(JDialog owner, String title, String internalTitle) {
        this(owner, title, internalTitle, null, null);
    }

    public DirectoryListChooser(JDialog owner, String title, String internalTitle, String subtitle) {
        this(owner, title, internalTitle, subtitle, null);
    }

    public DirectoryListChooser(JDialog owner, String title, String internalTitle, String subtitle, Icon titleLogo) {
        super((Dialog)owner, title, internalTitle, subtitle, titleLogo, 3);
        this.init();
    }

    public DirectoryListChooser(JFrame owner, String title) {
        this(owner, title, null, null, null);
    }

    public DirectoryListChooser(JFrame owner, String title, String internalTitle) {
        this(owner, title, internalTitle, null, null);
    }

    public DirectoryListChooser(JFrame owner, String title, String internalTitle, String subtitle) {
        this(owner, title, internalTitle, subtitle, null);
    }

    public DirectoryListChooser(JFrame owner, String title, String internalTitle, String subtitle, Icon titleLogo) {
        super((Frame)owner, title, internalTitle, subtitle, titleLogo, 3);
        this.init();
    }

    public File selectDirectory(File startDir, File preselection) {
        Directory.getRoot().reset();
        this.directoryList.setParentDirectory(startDir);
        this.dirField.setRoot(startDir);
        this.directoryList.setSelectedDirectory(preselection);
        File result = null;
        if (this.showDialog() == 1) {
            result = this.dirField.getSelectedDirectory().getDir();
        }
        Directory.getRoot().reset();
        return result;
    }

    public void setModelExtension(FileListModelExtension modelExtension) {
        this.directoryList.setModelExtension(modelExtension);
    }

    public void setDirectoryFilter(DirectoryFilter directoryFilter) {
        this.directoryList.setDirectoryFilter(directoryFilter);
    }

    private void init() {
        this.createGui();
        this.addEventHandler();
        this.setOkButtonEnabled(false);
    }

    private void createGui() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.directoryList = new DirectoryList();
        this.add((Component)this.directoryList, "Center");
        this.dirField = new DirectoryField();
        this.directoryList.addDirectorySelectedListener(this.dirField);
        this.add((Component)this.dirField, "South");
    }

    private void addEventHandler() {
        this.dirField.addInputFieldListener(new InputFieldListener(){

            @Override
            public void inputFieldChanged(InputFieldEvent e) {
                boolean enabled = DirectoryListChooser.this.dirField.getText().length() > 0;
                DirectoryListChooser.this.setOkButtonEnabled(enabled);
            }
        });
    }
}

