/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.EmptyBorder;

public class SmallBevelBorder
extends EmptyBorder {
    public static final int LOWERED = 1;
    public static final int RAISED = 2;
    private int type = 1;
    private Color brightBorderColor;
    private Color darkBorderColor;
    private boolean borderOpaque = true;
    private Insets margin = new Insets(0, 0, 0, 0);

    public SmallBevelBorder() {
        super(new Insets(1, 1, 1, 1));
        this.brightBorderColor = Color.white;
        this.darkBorderColor = Color.darkGray;
    }

    public SmallBevelBorder(Insets margin) {
        super(new Insets(1 + margin.top, 1 + margin.left, 1 + margin.bottom, 1 + margin.right));
        this.brightBorderColor = Color.white;
        this.darkBorderColor = Color.darkGray;
    }

    public SmallBevelBorder(int type) {
        super(new Insets(1, 1, 1, 1));
        this.type = type;
        this.brightBorderColor = Color.white;
        this.darkBorderColor = Color.darkGray;
    }

    public SmallBevelBorder(int type, Insets margin) {
        super(new Insets(1 + margin.top, 1 + margin.left, 1 + margin.bottom, 1 + margin.right));
        this.type = type;
        this.brightBorderColor = Color.white;
        this.darkBorderColor = Color.darkGray;
    }

    public void setBrightBorderColor(Color brightBorderColor) {
        this.brightBorderColor = brightBorderColor;
    }

    public void setDarkBorderColor(Color darkBorderColor) {
        this.darkBorderColor = darkBorderColor;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int x, int y, int width, int height) {
        if (this.borderOpaque) {
            Color col = graphics.getColor();
            if (this.type == 1) {
                graphics.setColor(this.darkBorderColor);
            } else {
                graphics.setColor(this.brightBorderColor);
            }
            graphics.drawLine(x, y, x + width - 2, y);
            graphics.drawLine(x, y, x, y + height - 1);
            if (this.type == 1) {
                graphics.setColor(this.brightBorderColor);
            } else {
                graphics.setColor(this.darkBorderColor);
            }
            graphics.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
            graphics.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            graphics.setColor(col);
        }
    }

    public void setBorderOpaque(boolean borderOpaque) {
        this.borderOpaque = borderOpaque;
    }

    @Override
    public boolean isBorderOpaque() {
        return this.borderOpaque;
    }

    public void setMargin(Insets margin) {
        this.top = margin.top + 1;
        this.left = margin.left + 1;
        this.bottom = margin.bottom + 1;
        this.right = margin.right + 1;
    }
}

