/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.swing.DialogIcons;
import ch.e2e.swing.ModalDialog;
import ch.e2e.swing.MultiLineLabel;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.border.EmptyBorder;

public class MessageBox
extends ModalDialog {
    private MultiLineLabel messageLabel;
    private boolean hasOwner;

    public MessageBox() {
        super(new JFrame(), "", "", "", 1);
        this.hasOwner = false;
        this.createGui();
    }

    public MessageBox(JDialog owner) {
        super(owner, "", "", "", 1);
        this.hasOwner = true;
        this.createGui();
    }

    public MessageBox(JFrame owner) {
        super(owner, "", "", "", 1);
        this.hasOwner = true;
        this.createGui();
    }

    public void error(String internalTitle, String subtitle, String message) {
        this.showMessageDialog(translator.getTranslation("error", "error"), internalTitle, subtitle, message, DialogIcons.errorBigIcon);
    }

    public void warning(String internalTitle, String subtitle, String message) {
        this.showMessageDialog(translator.getTranslation("warning", "warning"), internalTitle, subtitle, message, DialogIcons.warningBigIcon);
    }

    public void info(String internalTitle, String subtitle, String message) {
        this.showMessageDialog(translator.getTranslation("info", "info"), internalTitle, subtitle, message, DialogIcons.infoBigIcon);
    }

    private void showMessageDialog(String title, String internalTitle, String subtitle, String message, Icon icon) {
        this.setTitleLogo(icon);
        this.setTitle(title);
        this.setInternalTitle(internalTitle);
        this.setSubtitle(subtitle);
        this.messageLabel.setText(message);
        this.messageLabel.setHorizontalAlignment(2);
        this.showDialog(this.hasOwner);
    }

    public void setMessageForeground(Color foreground) {
        this.messageLabel.setForeground(foreground);
    }

    public void setMessageFont(Font font) {
        this.messageLabel.setFont(font);
    }

    public void setMessageLineHeight(int lineHeight) {
        this.messageLabel.setLineHeight(lineHeight);
    }

    @Override
    public void setLocale(Locale locale) {
        translator.setLocale(locale);
        this.setOkButtonText(translator.getTranslation("ok"));
    }

    private void createGui() {
        this.setLayout(new FlowLayout(1));
        this.setBorder(new EmptyBorder(15, 10, 15, 10));
        this.messageLabel = new MultiLineLabel("", "\n", 300);
        this.add(this.messageLabel);
    }
}

