/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.swing.InputIntegerField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IntegerSpinnerEditor
implements ChangeListener {
    private InputIntegerField textField;
    private SpinnerNumberModel spinnerModel;
    private boolean internalChange = false;

    public IntegerSpinnerEditor(SpinnerNumberModel spinnerModel) {
        this.spinnerModel = spinnerModel;
        Number min = (Number)((Object)spinnerModel.getMinimum());
        Number max = (Number)((Object)spinnerModel.getMaximum());
        this.textField = new InputIntegerField(min.intValue(), max.intValue());
        this.textField.addInputFieldListener(new InputFieldListener(){

            @Override
            public void inputFieldChanged(InputFieldEvent e) {
                IntegerSpinnerEditor.this.internalChange = true;
                Object value = IntegerSpinnerEditor.this.textField.getValue();
                if (value != null) {
                    IntegerSpinnerEditor.this.spinnerModel.setValue(value);
                }
                IntegerSpinnerEditor.this.internalChange = false;
            }
        });
    }

    public InputIntegerField getTextField() {
        return this.textField;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.internalChange) {
            JSpinner spinner = (JSpinner)e.getSource();
            this.getTextField().setValue(spinner.getValue());
        }
    }

    public Object getContent() {
        return this.textField.getContent();
    }

    public void setContent(Object content) {
        this.textField.setContent(content);
    }

    public void setEditable(boolean editable) {
        this.textField.setEditable(editable);
    }

    public void removeInputFieldListener(InputFieldListener listener) {
        this.textField.removeInputFieldListener(listener);
    }

    public void addInputFieldListener(InputFieldListener listener) {
        this.textField.addInputFieldListener(listener);
    }

    public void setMinimum(int minimum) {
        this.spinnerModel.setMinimum(new Integer(minimum));
        this.textField.setMinimum(minimum);
    }

    public void setMaximum(int maximum) {
        this.spinnerModel.setMaximum(new Integer(maximum));
        this.textField.setMaximum(maximum);
    }
}

