/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldEventMulticaster;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.gui.event.ValueChangedEvent;
import ch.e2e.gui.event.ValueChangedEventMulticaster;
import ch.e2e.gui.event.ValueChangedListener;
import ch.e2e.swing.InputValueField;
import ch.e2e.swing.document.NumberFieldDocument;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class InputNumberField
extends JTextField
implements InputValueField,
DocumentListener {
    protected double increment;
    protected double minimum;
    protected double maximum;
    private InputFieldListener inputFieldlistener;
    private ValueChangedListener valueChangedlistener;
    private Double value;
    private Double emptyValue;
    private boolean fireEvents = true;
    private Double lastCorrectValue;
    private boolean beepOnError = true;

    public InputNumberField(NumberFieldDocument doc, double min, double max, double increment) {
        super(doc.getMaxDigits() + 4);
        this.setHorizontalAlignment(4);
        this.minimum = min;
        this.maximum = max;
        this.increment = increment;
        doc.addDocumentListener(this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (InputNumberField.this.value == null || !InputNumberField.this.isInRange(InputNumberField.this.value)) {
                    InputNumberField.this.setContent(InputNumberField.this.lastCorrectValue);
                    InputNumberField.this.fireEvents();
                }
            }
        });
        this.setDocument(doc);
    }

    @Override
    public boolean isMaximumReached() {
        return this.getActualValue(this.minimum) >= this.maximum;
    }

    @Override
    public boolean isMinimumReached() {
        return this.getActualValue(this.maximum) <= this.minimum;
    }

    @Override
    public void clear() {
        this.setText("");
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fireEvents();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.value = this.getNumberFieldDocument().getActualValue();
        if (this.isInRange(this.value)) {
            this.lastCorrectValue = this.value;
        }
        this.fireEvents();
    }

    private void fireEvents() {
        if (this.fireEvents) {
            this.fireEvents = false;
            this.fireInputField();
            this.fireValueChanged();
            this.fireEvents = true;
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.value = this.getNumberFieldDocument().getActualValue();
        if (this.isInRange(this.value)) {
            this.lastCorrectValue = this.value;
        }
        this.fireEvents();
    }

    @Override
    public void setContent(Object value) {
        this.fireEvents = false;
        if (this.value == null || !this.value.equals(value)) {
            this.value = (Double)value;
            if (value == null || value.equals(this.emptyValue)) {
                this.setText("");
            } else {
                this.getNumberFieldDocument().format(this.value);
            }
            if (this.value != null && this.isInRange(this.value)) {
                this.lastCorrectValue = this.value;
            }
            this.fireEvents = true;
            this.fireEvents();
        }
        this.fireEvents = true;
    }

    @Override
    public void up() {
        double actualValue = this.getActualValue(this.minimum);
        if (this.isInRange(actualValue += this.increment)) {
            this.setContent(new Double(actualValue));
        } else {
            System.out.println("actualValue is not in range");
        }
    }

    @Override
    public void down() {
        double actualValue = this.getActualValue(this.minimum);
        if (this.isInRange(actualValue -= this.increment)) {
            this.setContent(new Double(actualValue));
        } else {
            System.out.println("actualValue is not in range");
        }
    }

    public void setMaximumFractionDigits(int fractionDigits) {
        this.getNumberFieldDocument().setMaximumFractionDigits(fractionDigits);
    }

    public int getMaximumFractionDigits() {
        return this.getNumberFieldDocument().getMaximumFractionDigits();
    }

    public void setMinimumFractionDigits(int fractionDigits) {
        this.getNumberFieldDocument().setMinimumFractionDigits(fractionDigits);
    }

    public int getMinimumFractionDigits() {
        return this.getNumberFieldDocument().getMinimumFractionDigits();
    }

    public void setFractionDigits(int fractionDigits) {
        this.getNumberFieldDocument().setFractionDigits(fractionDigits);
    }

    public int getFractionDigits() {
        return this.getNumberFieldDocument().getFractionDigits();
    }

    public char getDecimalSeparator() {
        return this.getNumberFieldDocument().getDecimalSeparator();
    }

    public void setGroupingUsed(boolean groupingUsed) {
        this.getNumberFieldDocument().setGroupingUsed(groupingUsed);
    }

    public boolean isGroupingUsed() {
        return this.getNumberFieldDocument().isGroupingUsed();
    }

    public void setGroupingSeparator(char groupingSeparator) {
        this.getNumberFieldDocument().setGroupingSeparator(groupingSeparator);
    }

    public void setGroupingSize(int groupingSize) {
        this.getNumberFieldDocument().setGroupingSize(groupingSize);
    }

    @Override
    public void addInputFieldListener(InputFieldListener listener) {
        this.inputFieldlistener = InputFieldEventMulticaster.addListener(this.inputFieldlistener, listener);
    }

    @Override
    public void removeInputFieldListener(InputFieldListener listener) {
        this.inputFieldlistener = InputFieldEventMulticaster.removeListener(this.inputFieldlistener, listener);
    }

    public void fireInputField() {
        if (this.inputFieldlistener != null) {
            this.inputFieldlistener.inputFieldChanged(new InputFieldEvent(this));
        }
    }

    public void setEmptyValue(double emptyValue) {
        this.emptyValue = emptyValue;
    }

    protected boolean isInRange(double value) {
        if (value < this.minimum || value > this.maximum) {
            if (this.beepOnError) {
                Toolkit.getDefaultToolkit().beep();
            }
            return false;
        }
        return true;
    }

    protected NumberFieldDocument getNumberFieldDocument() {
        return (NumberFieldDocument)this.getDocument();
    }

    private double getActualValue(double defaultValue) {
        try {
            Double actualValue = this.getNumberFieldDocument().getActualValue();
            if (actualValue.isNaN()) {
                actualValue = this.emptyValue;
            }
            return actualValue;
        }
        catch (NumberFormatException nfEx) {
            return defaultValue;
        }
    }

    @Override
    public Object getContent() {
        return this.value == null ? null : (this.value.equals(this.emptyValue) ? null : this.value);
    }

    @Override
    public void addValueChangedListener(ValueChangedListener listener) {
        this.valueChangedlistener = ValueChangedEventMulticaster.addListener(this.valueChangedlistener, listener);
    }

    @Override
    public void removeValueChangedListener(ValueChangedListener listener) {
        this.valueChangedlistener = ValueChangedEventMulticaster.removeListener(this.valueChangedlistener, listener);
    }

    public boolean isBeepOnError() {
        return this.beepOnError;
    }

    public void setBeepOnError(boolean beepOnError) {
        ((NumberFieldDocument)this.getDocument()).setBeepOnError(beepOnError);
        this.beepOnError = beepOnError;
    }

    @Override
    public void fireValueChanged() {
        ValueChangedEvent event = new ValueChangedEvent(this, this.value);
        if (this.valueChangedlistener != null) {
            this.valueChangedlistener.valueChanged(event);
        }
    }

    public void setMinimum(double minimum) {
        this.minimum = minimum;
        this.getNumberFieldDocument().setMinimum(minimum);
        if (this.value != null && !this.value.isNaN() && minimum > this.value) {
            this.setContent(new Double(minimum));
        }
        this.setColumns(this.getNumberFieldDocument().getMaxDigits() + 4);
    }

    public void setMaximum(double maximum) {
        this.maximum = maximum;
        this.getNumberFieldDocument().setMaximum(maximum);
        if (this.value != null && !this.value.isNaN() && maximum < this.value) {
            this.setContent(new Double(maximum));
        }
        this.setColumns(this.getNumberFieldDocument().getMaxDigits() + 4);
    }
}

