/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.swing.WindowTitle;
import ch.e2e.swing.border.RoundBevelBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ContainerListener;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class DockableFrame
extends JPanel {
    private JPanel contentPane;
    private WindowTitle windowTitle;
    private JPanel centerPanel;

    public DockableFrame(String title, Icon icon, boolean showButtons) {
        super(new BorderLayout());
        this.createGui(title, icon, showButtons);
    }

    @Override
    public void setLayout(LayoutManager layout) {
        if (this.centerPanel == null) {
            super.setLayout(layout);
        } else {
            this.centerPanel.setLayout(layout);
        }
    }

    @Override
    public Component add(Component comp) {
        return this.centerPanel == null ? super.add(comp) : this.centerPanel.add(comp);
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (this.centerPanel == null) {
            super.add(comp, constraints);
        } else {
            this.centerPanel.add(comp, constraints);
        }
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        if (this.centerPanel == null) {
            super.add(comp, constraints, index);
        } else {
            this.centerPanel.add(comp, constraints, index);
        }
    }

    @Override
    public Component add(Component comp, int index) {
        return this.centerPanel == null ? super.add(comp, index) : this.centerPanel.add(comp, index);
    }

    @Override
    public Component add(String name, Component comp) {
        return this.centerPanel == null ? super.add(name, comp) : this.centerPanel.add(name, comp);
    }

    @Override
    public synchronized void addContainerListener(ContainerListener l) {
        this.centerPanel.addContainerListener(l);
    }

    public void setTitle(String title) {
        this.windowTitle.setTitle(title);
    }

    public void setMinimizeButtonVisible(boolean visible) {
        this.windowTitle.setMinimizeButtonVisible(visible);
    }

    public void setCloseButtonVisible(boolean visible) {
        this.windowTitle.setCloseButtonVisible(visible);
    }

    public void setTitleBackground(Color background) {
        this.windowTitle.setActiveBackground(background);
        this.windowTitle.setInactiveBackground(background);
    }

    public void setTitleForeground(Color foreground) {
        this.windowTitle.setActiveForeground(foreground);
        this.windowTitle.setInactiveForeground(foreground);
    }

    private void createGui(String title, Icon icon, boolean showButtons) {
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setBorder(new CompoundBorder(new RoundBevelBorder(0), new EmptyBorder(1, 1, 1, 1)));
        this.add((Component)this.contentPane, "Center");
        JPanel northPanel = new JPanel(new BorderLayout());
        this.windowTitle = new WindowTitle(title, icon, true, showButtons);
        northPanel.add((Component)this.windowTitle, "North");
        this.contentPane.add((Component)northPanel, "North");
        this.centerPanel = new JPanel(new BorderLayout());
        this.contentPane.add((Component)this.centerPanel, "Center");
        super.add((Component)this.contentPane, "Center");
    }
}

