/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.print;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.View;

public class TextPanePrintView
extends BoxView {
    protected int firstOnPage = 0;
    protected int lastOnPage = 0;
    protected int pageIndex = 0;

    public TextPanePrintView(Element elem, View root, int width, int height) {
        super(elem, 1);
        this.setParent(root);
        this.setSize(width, height);
        this.layout(width, height);
    }

    public boolean paintPage(Graphics graphics, int pageHeight, int pageIndex) {
        if (pageIndex > this.pageIndex) {
            this.firstOnPage = this.lastOnPage + 1;
            if (this.firstOnPage >= this.getViewCount()) {
                return false;
            }
            this.pageIndex = pageIndex;
        }
        int yMin = this.getOffset(1, this.firstOnPage);
        int yMax = yMin + pageHeight;
        Rectangle rc = new Rectangle();
        for (int i = this.firstOnPage; i < this.getViewCount(); ++i) {
            rc.x = this.getOffset(0, i);
            rc.y = this.getOffset(1, i);
            rc.width = this.getSpan(0, i);
            rc.height = this.getSpan(1, i);
            if (rc.y + rc.height > yMax) break;
            this.lastOnPage = i;
            rc.y -= yMin;
            View view = this.getView(i);
            Component c = this.viewContainsComponentView(view);
            if (c == null) {
                this.paintChild(graphics, rc, i);
                continue;
            }
            this.paintChild(graphics, rc, i);
            Rectangle bounds = c.getBounds();
            System.out.println("c.bounds = " + c.getBounds());
            c.doLayout();
            System.out.println("c.preferredSize = " + c.getPreferredSize());
            graphics.translate(rc.x, rc.y);
            c.setBounds(rc.x, rc.y, bounds.width, bounds.height);
            c.paint(graphics);
            graphics.translate(-rc.x, -rc.y);
        }
        return true;
    }

    private Component viewContainsComponentView(View view) {
        Component result = null;
        int childCount = view.getViewCount();
        for (int j = 0; j < childCount && result == null; ++j) {
            View child = view.getView(j);
            result = child instanceof ComponentView ? ((ComponentView)child).getComponent() : this.viewContainsComponentView(child);
        }
        return result;
    }

    private void paintChildWithComponentView(View view, Graphics graphics, Rectangle rc) {
        int childCount = view.getViewCount();
        for (int j = 0; j < childCount; ++j) {
            View child = view.getView(j);
            if (child instanceof ComponentView) {
                ComponentView cv = (ComponentView)child;
                Component c = cv.getComponent();
                c.setBounds(rc.x, rc.y, rc.width, rc.height);
                c.paint(graphics);
                continue;
            }
            view.paint(graphics, rc);
            this.paintChildWithComponentView(child, graphics, rc);
        }
    }
}

