/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.print;

import ch.e2e.print.PrintTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;

public class ComponentPrinter {
    public static Printable getPrintable(Component component, MediaPrintableArea printableArea, OrientationRequested orientation) {
        return new PrintableImage(component, printableArea, orientation);
    }

    private static class PrintableImage
    implements Printable {
        private Component component;
        private Color background;
        private Point[] points;

        private PrintableImage(Component component, MediaPrintableArea printableArea, OrientationRequested orientation) {
            int pageHeight;
            int pageWidth;
            this.component = component;
            this.background = component.getBackground();
            Dimension size = component.getBounds().getSize();
            if (orientation.equals(OrientationRequested.PORTRAIT)) {
                pageWidth = (int)PrintTools.milimeter2Dots(printableArea.getWidth(1000));
                pageHeight = (int)PrintTools.milimeter2Dots(printableArea.getHeight(1000));
            } else {
                pageHeight = (int)PrintTools.milimeter2Dots(printableArea.getWidth(1000));
                pageWidth = (int)PrintTools.milimeter2Dots(printableArea.getHeight(1000));
            }
            int columns = size.width / pageWidth;
            int rows = size.height / pageHeight;
            int pageCount = (rows += size.height % pageHeight > 0 ? 1 : 0) * (columns += size.width % pageWidth > 0 ? 1 : 0);
            this.points = new Point[pageCount];
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < columns; ++j) {
                    int index = i * columns + j;
                    int x = j * pageWidth;
                    int y = i * pageHeight;
                    this.points[index] = new Point(x, y);
                }
            }
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            int result;
            if (pageIndex == this.points.length) {
                result = 1;
            } else {
                int translateX = (int)pageFormat.getImageableX();
                int translateY = (int)pageFormat.getImageableY();
                graphics.setClip(translateX, translateY, (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
                graphics.translate(translateX - this.points[pageIndex].x, translateY - this.points[pageIndex].y);
                this.component.setBackground(Color.white);
                this.component.paint(graphics);
                this.component.setBackground(this.background);
                result = 0;
            }
            return result;
        }
    }
}

