/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute.test;

import ch.e2e.builder.base.io.UniqueIdService;
import ch.e2e.builder.base.io.WrongIDFileVersionException;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.SynchronousTestcaseTemplate;
import ch.e2e.builder.traceviewer.execute.test.LogfileCompare;
import ch.e2e.builder.traceviewer.execute.test.TestcaseDifference;
import ch.e2e.builder.traceviewer.testcase.SynchronousTestcase;
import ch.e2e.io.FileUtilities;
import ch.e2e.test.E2ETest;
import ch.e2e.test.PropertiesHelper;
import ch.e2e.test.TestDocumentPreprocessor;
import ch.e2e.test.TestResult;
import ch.e2e.test.TypeFactory;
import ch.e2e.test.Utilities;
import ch.e2e.test.XMLCompare;
import ch.e2e.test.options.BooleanOption;
import ch.e2e.test.options.FileOption;
import ch.e2e.test.options.Option;
import ch.e2e.test.options.OptionChangeEvent;
import ch.e2e.test.options.OptionChangeListener;
import ch.e2e.transformer.TransformerLoadException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import junit.framework.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestcaseCompare
extends XMLCompare {
    public static final String KEY = "TestcaseCompare";
    private Element testcaseElement;
    private ArrayList<String> ignoreFileExtensions = new ArrayList();

    public TestcaseCompare() {
        this.setName("Compare request and response");
        try {
            this.setType(TypeFactory.getInstance().getType(KEY));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init(Element options) {
        super.init(options);
        NodeList testcases = options.getElementsByTagName("testcase");
        if (testcases != null && testcases.getLength() == 1) {
            this.testcaseElement = (Element)testcases.item(0);
        }
        this.addIgnores(options);
    }

    public void setGlobalTestOptions(Element options) {
        super.setGlobalTestOptions(options);
        this.addIgnores(options);
    }

    public void doTest(E2ETest test) throws IOException, ParserConfigurationException, SAXException, TransformerException, TransformerLoadException {
        Boolean equal;
        File testFolder = this.getTestFolder(test.getRunProperties());
        File referenceFolder = (File)this.getOptionValue("xml.compare.reference.file", test.getRunProperties());
        E2ETest.assertFalse((String)"Could not find the testfolder definition.", (testFolder == null ? 1 : 0) != 0);
        E2ETest.assertFalse((String)"Could not find the referencefolder definition.", (referenceFolder == null ? 1 : 0) != 0);
        TestcaseDifference diff = new TestcaseDifference(testFolder, referenceFolder);
        this.compareFiles(referenceFolder, testFolder, diff);
        this.compareLogfiles(referenceFolder, testFolder, diff, test.getRunProperties());
        Boolean bl = equal = ((BooleanOption)this.getOptions().get("xml.compare.type")).getValue() == null ? (Boolean)((BooleanOption)this.getOptions().get("xml.compare.type")).getDefaultValue() : (Boolean)((BooleanOption)this.getOptions().get("xml.compare.type")).getValue();
        if (equal.booleanValue()) {
            E2ETest.assertTrue((String)diff.toString(), (boolean)diff.isIdentical());
        } else {
            E2ETest.assertFalse((String)diff.toString(), (boolean)diff.isIdentical());
        }
    }

    public TestResult getTestResult(boolean includeHiddenData, Map<String, String> properties) {
        File responseTest;
        File requestTest;
        File responseReference;
        File requestReference;
        StringBuilder referenceData = new StringBuilder();
        StringBuilder testData = new StringBuilder();
        File testFolder = this.getTestFolder(properties);
        TestDocumentPreprocessor preprocessor = (TestDocumentPreprocessor)this.getOptionValue("xml.compare.preprocessor", properties);
        if (preprocessor == null || !preprocessor.isEnabled()) {
            File referenceFolder = (File)((FileOption)this.getOptions().get("xml.compare.reference.file")).getValue();
            requestReference = new File(referenceFolder, "request.log");
            responseReference = new File(referenceFolder, "response.log");
            requestTest = new File(testFolder, "request.log");
            responseTest = new File(testFolder, "response.log");
        } else {
            preprocessor.setLogFolder(testFolder);
            requestReference = preprocessor.getPreprocessedFile("request.log.reference");
            responseReference = preprocessor.getPreprocessedFile("response.log.reference");
            requestTest = preprocessor.getPreprocessedFile("request.log.test");
            responseTest = preprocessor.getPreprocessedFile("response.log.test");
        }
        TestResult requestResult = new TestResult("request.log:\n", "request.log:\n");
        new LogfileCompare(requestTest, requestReference, null).appendResultDocuments(requestResult, includeHiddenData, this.getIgnoredElements(), this.getIgnoredAttributes());
        referenceData.append(requestResult.getReferenceData()).append("\n\n");
        testData.append(requestResult.getTestData()).append("\n\n");
        TestResult responseResult = new TestResult("response.log:\n", "response.log:\n");
        new LogfileCompare(responseTest, responseReference, null).appendResultDocuments(responseResult, includeHiddenData, this.getIgnoredElements(), this.getIgnoredAttributes());
        referenceData.append(responseResult.getReferenceData()).append("\n\n");
        testData.append(responseResult.getTestData()).append("\n\n");
        return new TestResult(referenceData.toString(), testData.toString());
    }

    public void moveReferenceData(File oldReferenceFolder, File newReferenceFolder, Map<String, String> runProperties) {
        File oldReferenceFolderValue = (File)this.getOptionValue("xml.compare.reference.file", runProperties);
        if (oldReferenceFolderValue != null) {
            File[] referenceFiles = FileUtilities.getAllFiles((File)oldReferenceFolderValue, (boolean)false);
            this.moveReferenceData(oldReferenceFolder, newReferenceFolder, referenceFiles);
            String path = FileUtilities.getRelativePath((File)oldReferenceFolderValue, (File)oldReferenceFolder);
            File newReferenceFolderValue = new File(newReferenceFolder, path);
            ((Option)this.getOptions().get("xml.compare.reference.file")).setValueWithoutNotification((Object)newReferenceFolderValue);
            Utilities.deleteEmptyParents((File)oldReferenceFolderValue);
        }
    }

    private void moveReferenceData(File oldReferenceFolder, File newReferenceFolder, File[] referenceFiles) {
        for (File file : referenceFiles) {
            String path = FileUtilities.getRelativePath((File)file, (File)oldReferenceFolder);
            File newReferenceFile = new File(newReferenceFolder, path);
            if (newReferenceFile.exists()) {
                newReferenceFile.delete();
            } else {
                newReferenceFile.getParentFile().mkdirs();
            }
            if (file.renameTo(newReferenceFile)) continue;
            System.out.println("Could not move " + file + " to " + newReferenceFile);
        }
    }

    public void test2Reference(Map<String, String> properties) throws IOException {
        File[] newReferenceFiles;
        File referenceFolder = (File)((FileOption)this.getOptions().get("xml.compare.reference.file")).getValue();
        if (referenceFolder.exists()) {
            FileUtilities.deleteAllFiles((File)referenceFolder);
        } else {
            referenceFolder.mkdirs();
        }
        File traceFolder = this.getTestFolder(properties);
        for (File file : newReferenceFiles = FileUtilities.getAllFiles((File)traceFolder, (boolean)false)) {
            FileUtilities.copyFile((File)new File(traceFolder, file.getName()), (File)new File(referenceFolder, file.getName()));
        }
    }

    public void toXml(Element parent) {
        Element result = this.optionsToXml(parent.getOwnerDocument(), "testcaseCompare");
        parent.appendChild(result);
    }

    public Element optionsToXml(boolean includeType, Document ownerDocument) {
        Element result = this.optionsToXml(ownerDocument, "options");
        if (includeType) {
            result.setAttribute("type", this.getType().getName());
        }
        return result;
    }

    private Element optionsToXml(Document parent, String name) {
        BooleanOption compareType;
        Boolean value;
        Element result = parent.createElement(name);
        if (this.getName() != null && this.getName().length() > 0) {
            result.setAttribute("name", this.getName());
        }
        Boolean bl = value = (compareType = (BooleanOption)this.getOptions().get("xml.compare.type")).getValue() == null ? (Boolean)compareType.getDefaultValue() : (Boolean)compareType.getValue();
        if (value.booleanValue()) {
            result.setAttribute("compareType", "equal");
        } else {
            result.setAttribute("compareType", "notequal");
        }
        ((Option)this.getOptions().get("xml.compare.reference.file")).toXml(result);
        ((Option)this.getOptions().get("xml.compare.test.file")).toXml(result);
        this.advancedOptionsToXml(result);
        return result;
    }

    public String toString() {
        return "<TestcaseCompare>" + (this.getName() == null ? "" : this.getName());
    }

    public void removeReferenceData(Map<String, String> properties) {
        File referenceFolder = (File)this.getOptionValue("xml.compare.reference.file", properties);
        if (referenceFolder != null && referenceFolder.exists()) {
            FileUtilities.silentDeleteDirectory((File)referenceFolder);
        }
        Utilities.deleteEmptyParents((File)referenceFolder);
    }

    protected Object createFileValue(Element fileElement) {
        File file = null;
        if (fileElement.hasAttribute("file")) {
            file = new File(fileElement.getAttribute("file"));
        } else if (fileElement.hasAttribute("dir")) {
            file = new File(fileElement.getAttribute("dir"));
        }
        return file;
    }

    protected void createOptions() {
        super.createOptions();
        Option testOption = (Option)this.getOptions().get("xml.compare.test.file");
        FileOption test = new FileOption("Test folder", "xml.compare.test.file", testOption.getIndex());
        test.setDirectory(true);
        this.getOptions().put("xml.compare.test.file", test);
        Option referenceOption = (Option)this.getOptions().get("xml.compare.reference.file");
        FileOption reference = new FileOption("Reference folder", "xml.compare.reference.file", referenceOption.getIndex());
        reference.setDirectory(true);
        reference.addOptionChangeListener((OptionChangeListener)new OptionChangeListener<File>(){

            public void optionChanged(OptionChangeEvent<File> event) {
                File oldReferenceFolder = (File)event.getOldValue();
                File newReferenceFolder = (File)event.getNewValue();
                TestcaseCompare.this.moveReferenceData(oldReferenceFolder, newReferenceFolder, FileUtilities.getAllFiles((File)oldReferenceFolder, (boolean)false));
                Utilities.deleteEmptyParents((File)oldReferenceFolder);
            }
        });
        this.getOptions().put("xml.compare.reference.file", reference);
    }

    private void compareLogfiles(File referenceDir, File testFolder, TestcaseDifference diff, Map<String, String> runProperties) throws IOException, ParserConfigurationException, SAXException, TransformerException, TransformerLoadException {
        File testRequestLog = new File(testFolder, "request.log");
        Assert.assertTrue((String)("The request log file " + testRequestLog.getAbsolutePath() + " does not exist."), (boolean)testRequestLog.exists());
        File testResponseLog = new File(testFolder, "response.log");
        Assert.assertTrue((String)("The response log file " + testResponseLog.getAbsolutePath() + " does not exist."), (boolean)testResponseLog.exists());
        if (testRequestLog.exists() && testResponseLog.exists()) {
            File requestControl = new File(referenceDir, "request.log");
            Assert.assertTrue((String)("The request control file " + requestControl.getAbsolutePath() + " does not exist."), (boolean)requestControl.exists());
            TestDocumentPreprocessor preprocessor = (TestDocumentPreprocessor)this.getOptionValue("xml.compare.preprocessor", runProperties);
            if (preprocessor != null) {
                preprocessor.setLogFolder(testFolder);
            }
            LogfileCompare requestCompare = new LogfileCompare(testRequestLog, requestControl, preprocessor);
            requestCompare.setNamespaceAware(this.isNamespaceAware());
            requestCompare.setSchemaValidation(this.isSchemaValidation());
            requestCompare.setValidate(this.isValidate());
            requestCompare.compare(diff, this.getIgnoredAttributes(), this.getIgnoredElements());
            File responseControl = new File(referenceDir, "response.log");
            Assert.assertTrue((String)("The request control file " + responseControl.getAbsolutePath() + " does not exist."), (boolean)responseControl.exists());
            LogfileCompare responseCompare = new LogfileCompare(testResponseLog, responseControl, preprocessor);
            responseCompare.setNamespaceAware(this.isNamespaceAware());
            responseCompare.setSchemaValidation(this.isSchemaValidation());
            responseCompare.setValidate(this.isValidate());
            responseCompare.compare(diff, this.getIgnoredAttributes(), this.getIgnoredElements());
        }
    }

    private void compareFiles(File referenceFolder, File testFolder, TestcaseDifference diff) {
        File testSystemInfo;
        File testResponseLog;
        File testResponse;
        File testRequestLog;
        File testRequest;
        File referenceSystemInfo;
        File referenceResponseLog;
        File referenceResponse;
        File referenceRequestLog;
        File referenceRequest = new File(referenceFolder, "request");
        if (!referenceRequest.exists()) {
            diff.addMissingEntry(referenceRequest.getAbsolutePath());
        }
        if (!(referenceRequestLog = new File(referenceFolder, "request.log")).exists()) {
            diff.addMissingEntry(referenceRequestLog.getAbsolutePath());
        }
        if (!(referenceResponse = new File(referenceFolder, "response")).exists()) {
            diff.addMissingEntry(referenceResponse.getAbsolutePath());
        }
        if (!(referenceResponseLog = new File(referenceFolder, "response.log")).exists()) {
            diff.addMissingEntry(referenceResponseLog.getAbsolutePath());
        }
        if (!(referenceSystemInfo = new File(referenceFolder, "system.info")).exists()) {
            diff.addMissingEntry(referenceSystemInfo.getAbsolutePath());
        }
        if (!(testRequest = new File(testFolder, "request")).exists()) {
            diff.addMissingEntry(testRequest.getAbsolutePath());
        }
        if (!(testRequestLog = new File(testFolder, "request.log")).exists()) {
            diff.addMissingEntry(testRequestLog.getAbsolutePath());
        }
        if (!(testResponse = new File(testFolder, "response")).exists()) {
            diff.addMissingEntry(testResponse.getAbsolutePath());
        }
        if (!(testResponseLog = new File(testFolder, "response.log")).exists()) {
            diff.addMissingEntry(testResponseLog.getAbsolutePath());
        }
        if (!(testSystemInfo = new File(testFolder, "system.info")).exists()) {
            diff.addMissingEntry(testSystemInfo.getAbsolutePath());
        }
    }

    private AbstractSynchronousTestcase readTestcase(Element element) {
        File outputFolder;
        Assert.assertTrue((String)"The attribute 'name' must be defined int the testcase element.", (boolean)element.hasAttribute("name"));
        Assert.assertTrue((String)"The attribute 'operation' must be defined int the testcase element.", (boolean)element.hasAttribute("operation"));
        Assert.assertTrue((String)"The attribute 'home' must be defined int the testcase element.", (boolean)element.hasAttribute("home"));
        String home = element.getAttribute("home");
        File testcaseHome = new File(home);
        Assert.assertTrue((String)("Testcase home '" + testcaseHome.getAbsolutePath() + "' does not exist."), (boolean)testcaseHome.exists());
        String operation = element.getAttribute("operation");
        File operationHome = new File(testcaseHome, operation);
        if (!operationHome.exists()) {
            File idFile = new File(testcaseHome, ".synchronous.id");
            Assert.assertTrue((String)("Testcase ID file '" + idFile.getAbsolutePath() + "' does not exists"), (boolean)idFile.exists());
            try {
                HashMap ids = UniqueIdService.loadUniqueIds((File)idFile);
                String id = (String)ids.get(operation);
                Assert.assertFalse((String)("ID for operation '" + operation + "' does not exists"), (id == null ? 1 : 0) != 0);
                operationHome = new File(testcaseHome, id);
                Assert.assertTrue((String)("Operation home '" + operationHome.getAbsolutePath() + "' does not exists"), (boolean)operationHome.exists());
            }
            catch (WrongIDFileVersionException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        File templateFile = new File(operationHome, "template.xml");
        Assert.assertTrue((String)("Template file for operation '" + operation + "' does not exists"), (boolean)templateFile.exists());
        SynchronousTestcaseTemplate template = new SynchronousTestcaseTemplate(templateFile);
        SynchronousTestcase testcase = new SynchronousTestcase(element.getAttribute("name"), template, operationHome);
        if (element.hasAttribute("output") && (outputFolder = new File(element.getAttribute("output"))).exists()) {
            testcase.setTraceFolder(outputFolder);
        }
        return testcase;
    }

    private void addIgnores(Element options) {
        NodeList children = options.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equalsIgnoreCase("ignore")) continue;
            NamedNodeMap attributes = child.getAttributes();
            int attrLength = attributes.getLength();
            for (int j = 0; j < attrLength; ++j) {
                Attr attribute = (Attr)attributes.item(j);
                if (!attribute.getName().equalsIgnoreCase("fileExtension")) continue;
                this.ignoreFileExtensions.add(PropertiesHelper.getAttribute((Element)((Element)child), (String)"fileExtension", (Map)this.getOwner().getProperties()));
            }
        }
    }

    private File getTestFolder(Map<String, String> properties) {
        File testFolder;
        if (this.testcaseElement == null) {
            testFolder = (File)this.getOptionValue("xml.compare.test.file", properties);
        } else {
            AbstractSynchronousTestcase testcase = this.readTestcase(this.testcaseElement);
            Assert.assertFalse((String)"Could not create the testcase.", (testcase == null ? 1 : 0) != 0);
            testFolder = testcase.getTraceFolder();
        }
        return testFolder;
    }
}

