/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase;

import ch.e2e.builder.trace.testcase.TestcaseTemplate;
import ch.e2e.builder.trace.testcase.request.RequestTemplate;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SynchronousTestcaseTemplate
extends TestcaseTemplate {
    private static final String LOCATION_EXPRESSION = "System/location/text()";
    private static final String CONTROL_EXPRESSION = "System/control/text()";
    private static final String DOCUMENT_STYLE_EXPRESSION = "System/documentStyle/text()";
    private static final String SOAP_ACTION_EXPRESSION = "System/soapAction/text()";
    private static final String NAMESPACES_EXPRESSION = "System/namespaces";
    private String porttype;
    private String soapAction;
    private boolean rpcEncoding;
    private RequestTemplate requestTemplate;

    public SynchronousTestcaseTemplate(File templateFile) {
        super(templateFile);
    }

    public SynchronousTestcaseTemplate(Element testcaseTemplate) {
        super(testcaseTemplate);
    }

    public String getPorttype() {
        return this.porttype;
    }

    public boolean isRPCEncoding() {
        return this.rpcEncoding;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public RequestTemplate getRequestTemplate() {
        return this.requestTemplate;
    }

    public String getSoapNamespaceUri() {
        return this.getRequestTemplate().getNamespacesManager().getSoapNamespaceUri();
    }

    public String getSoapEnvelopeNamespaceUri() {
        return this.getRequestTemplate().getNamespacesManager().getSoapEnvelopeNamespaceUri();
    }

    public String getSoapEncodingNamespaceUri() {
        return this.getRequestTemplate().getNamespacesManager().getSoapEncodingNamespaceUri();
    }

    @Override
    protected void initialize(Element testcaseTemplate) {
        this.service = this.getAttribute(testcaseTemplate, "service");
        this.porttype = this.getAttribute(testcaseTemplate, "porttype");
        this.operation = this.getAttribute(testcaseTemplate, "operation");
        this.fullQualifiedName = this.service + '.' + this.porttype + '.' + this.operation;
        XPath xPath = DomUtilities.newXPath();
        try {
            Node locationNode = (Node)xPath.evaluate(LOCATION_EXPRESSION, testcaseTemplate, XPathConstants.NODE);
            if (locationNode != null) {
                this.location = locationNode.getNodeValue();
            }
        }
        catch (XPathExpressionException locationNode) {
            // empty catch block
        }
        try {
            Node controlUrlNode = (Node)xPath.evaluate(CONTROL_EXPRESSION, testcaseTemplate, XPathConstants.NODE);
            if (controlUrlNode != null) {
                this.controlUrl = controlUrlNode.getNodeValue();
            }
        }
        catch (XPathExpressionException controlUrlNode) {
            // empty catch block
        }
        try {
            Node documentStyleNode = (Node)xPath.evaluate(DOCUMENT_STYLE_EXPRESSION, testcaseTemplate, XPathConstants.NODE);
            if (documentStyleNode != null) {
                String documentStyle = documentStyleNode.getNodeValue();
                this.rpcEncoding = documentStyle.equals("rpc");
            }
        }
        catch (XPathExpressionException documentStyleNode) {
            // empty catch block
        }
        try {
            Node soapActionNode = (Node)xPath.evaluate(SOAP_ACTION_EXPRESSION, testcaseTemplate, XPathConstants.NODE);
            this.soapAction = soapActionNode == null ? "" : soapActionNode.getNodeValue();
        }
        catch (XPathExpressionException soapActionNode) {
            // empty catch block
        }
        try {
            Element requestElement = (Element)xPath.evaluate("Request", testcaseTemplate, XPathConstants.NODE);
            File home = this.getTemplateFile() == null ? null : this.getTemplateFile().getParentFile();
            this.requestTemplate = new RequestTemplate(home, requestElement, (Element)xPath.evaluate(NAMESPACES_EXPRESSION, testcaseTemplate, XPathConstants.NODE), this.rpcEncoding);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
    }
}

