/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.execute;

import ch.e2e.builder.trace.request.RequestException;
import ch.e2e.builder.trace.request.ResponseException;
import ch.e2e.builder.trace.testcase.LogFile;
import ch.e2e.dom.DomUtilities;
import ch.e2e.logging.LogManager;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RequestExecuter
extends ch.e2e.builder.trace.request.RequestExecuter {
    private final LogFile requestLog;
    private final LogFile responseLog;

    public RequestExecuter(LogFile requestLog, LogFile responseLog) {
        this.requestLog = requestLog;
        this.responseLog = responseLog;
    }

    public RequestExecuter(LogFile requestLog, LogFile responseLog, String ... acceptableResponseContentTypes) {
        super(acceptableResponseContentTypes);
        this.requestLog = requestLog;
        this.responseLog = responseLog;
    }

    @Override
    protected Document doRequest(Document request, HttpClient client, URL url) throws RequestException {
        this.responseLog.getLogFile().delete();
        try {
            Document result = super.doRequest(request, client, url);
            this.writeResponseLog(result);
            Document document = result;
            return document;
        }
        catch (ResponseException e) {
            LogManager.getLogger((String)"ch.e2e.builder.trace.execute").severe("Parsing of server response failed.");
            e.getResponseFile().renameTo(this.responseLog.getLogFile());
            throw e;
        }
        finally {
            this.writeRequestLog(request);
        }
    }

    private void writeRequestLog(Document request) {
        try (PrintWriter writer = this.requestLog.getWriter();){
            writer.println("POST " + this.getMethod().getPath() + " " + this.getMethod().getEffectiveVersion());
            for (Header header : this.getMethod().getRequestHeaders()) {
                writer.println(header.getName() + ": " + header.getValue());
            }
            writer.println("Content-Type: " + this.getMethod().getParams().getContentCharset());
            writer.println();
            DomUtilities.serialize((Writer)writer, (Node)request, (boolean)true, (boolean)false);
        }
        catch (Exception e) {
            LogManager.getLogger((String)"ch.e2e.builder.trace.execute").warning(String.format("writing of request log file failed (%s).", e.getMessage()));
        }
    }

    private void writeResponseLog(Document response) {
        try (PrintWriter out = this.responseLog.getWriter();){
            for (Header header : this.getMethod().getResponseHeaders()) {
                out.println(header.getName() + ": " + header.getValue());
            }
            out.println();
            String indentStr = System.getProperty("ch.e2e.builder.traceviewer.response.log.indent");
            DomUtilities.serialize((Writer)out, (Node)response, (indentStr == null || Boolean.parseBoolean(indentStr) ? 1 : 0) != 0, (boolean)false);
            out.flush();
        }
        catch (Exception e) {
            LogManager.getLogger((String)"ch.e2e.builder.trace.execute").warning(String.format("writing of request log file failed (%s).", e.getMessage()));
        }
    }
}

