/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.angular.base.tasks.typescript;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.model.libraries.JsonIdlImportSource;
import ch.e2e.builder.compiler.build.tasks.source.IDLSource;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.build.utils.JaxbUtils;
import ch.e2e.builder.compiler.document.json.idl.Idl;
import ch.e2e.builder.compiler.document.json.library.LibraryDescriptor;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.dom.DomUtilities;
import com.scheer.pas.compiler.angular.base.tasks.typescript.documents.TypescriptImport;
import com.scheer.pas.compiler.angular.base.tasks.typescript.documents.TypescriptImports;
import com.scheer.pas.compiler.angular.core.constants.Extensions;
import java.io.File;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

public class LibraryTypescriptImportsTask
extends CacheAbleTask
implements XSLTTransformSource {
    private final String libraryName = this.getDestinationFileNameWithoutExtension();
    private LibraryDescriptor libraryDescriptor;

    public static Boolean select(String id) {
        return id.endsWith(Extensions._library_ts_imports_xml);
    }

    public LibraryTypescriptImportsTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._library_ts_imports_xml;
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        Set<String> sourceSet = super.getBeforeSourceSet();
        sourceSet.add(Files.libs_LIBRARY__library_descriptor_xml(this.libraryName));
        return sourceSet;
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> sourceSet = super.getSourceSet();
        LibraryDescriptor descriptor = this.getDescriptor();
        if (descriptor.getContent().getAngular() != null) {
            switch (descriptor.getContent().getImplementation()) {
                case json: {
                    sourceSet.add(Files.libs_LIBRARY__LIBRARY_library_idl_json(this.libraryName));
                    break;
                }
                case lrep: {
                    sourceSet.add(Files.libs_LIBRARY__LIBRARY_library_lrep_idl_xml(this.libraryName));
                }
            }
        }
        return sourceSet;
    }

    private LibraryDescriptor getDescriptor() {
        if (this.libraryDescriptor == null) {
            JsonDocumentSource descriptorSource = (JsonDocumentSource)this.getSourceManager().getSource(Files.libs_LIBRARY__library_descriptor_xml(this.libraryName));
            this.libraryDescriptor = descriptorSource.getJsonDocument(LibraryDescriptor.class);
        }
        return this.libraryDescriptor;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            TypescriptImports typescriptImports = new TypescriptImports();
            LibraryDescriptor descriptor = this.getDescriptor();
            typescriptImports.setName(descriptor.getName());
            if (descriptor.getContent().getAngular().getPackage() != null) {
                switch (descriptor.getContent().getImplementation()) {
                    case lrep: {
                        IDLSource lrepIdlSource = (IDLSource)this.getSourceManager().getSource(Files.libs_LIBRARY__LIBRARY_library_lrep_idl_xml(this.libraryName));
                        for (Map.Entry<String, UmlElement> classEntry : lrepIdlSource.getIDLImportSource().getElementMaps().allClasses.entrySet()) {
                            UmlElement idlClass = classEntry.getValue();
                            TypescriptImport typescriptImport = new TypescriptImport();
                            typescriptImport.setName(idlClass.getName());
                            typescriptImport.setFrom(descriptor.getContent().getAngular().getPackage().getName());
                            if (idlClass.getStereotypes() != null) {
                                idlClass.getStereotypes().stream().filter(xumlAppliedStereotype -> xumlAppliedStereotype.getName().equals("TypescriptClass")).forEach(xumlAppliedStereotype -> {
                                    typescriptImport.setName(idlClass.getPropertyValueQuietly("importName").toString());
                                    typescriptImport.setFrom(idlClass.getPropertyValueQuietly("importFrom").toString());
                                });
                            }
                            typescriptImports.getMap().put(classEntry.getKey(), typescriptImport);
                        }
                        break;
                    }
                    case json: {
                        IDLSource idlSource = (IDLSource)this.getSourceManager().getSource(Files.libs_LIBRARY__LIBRARY_library_idl_json(this.libraryName));
                        JsonIdlImportSource idlImportSource = (JsonIdlImportSource)idlSource.getIDLImportSource();
                        Idl idl = idlImportSource.getOriginalIdl();
                        idl.getPackages().forEach(idlPackage -> idlPackage.getClasses().forEach(idlClass -> {
                            TypescriptImport typescriptImport = new TypescriptImport();
                            typescriptImport.setName(idlClass.getName());
                            typescriptImport.setFrom(descriptor.getContent().getAngular().getPackage().getName());
                            if (idlClass.getAppliedStereotypes() != null) {
                                idlClass.getAppliedStereotypes().stream().filter(xumlAppliedStereotype -> xumlAppliedStereotype.getStereotype().equals("TypescriptClass")).forEach(xumlAppliedStereotype -> {
                                    typescriptImport.setName(xumlAppliedStereotype.getSimpleTagValue("importName", typescriptImport.getName()));
                                    typescriptImport.setFrom(xumlAppliedStereotype.getSimpleTagValue("importFrom", typescriptImport.getFrom()));
                                });
                            }
                            typescriptImports.getMap().put(idlClass.getId(), typescriptImport);
                        }));
                    }
                }
            }
            DOMResult result = new DOMResult();
            JaxbUtils.marshalXml((Object)typescriptImports, result);
            DomUtilities.serialize((File)this.getDestinationFile(), (Node)result.getNode(), (boolean)true);
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    @Override
    public Source getXSLTTransformSource() {
        try {
            return new StreamSource(this.getDestinationFile());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

