/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.xml2yaml;

import ch.e2e.builder.compiler.swagger.elements.Descriptor;
import ch.e2e.builder.compiler.swagger.elements.ExternalDocumentation;
import ch.e2e.builder.compiler.swagger.elements.HeaderObject;
import ch.e2e.builder.compiler.swagger.elements.Info;
import ch.e2e.builder.compiler.swagger.elements.OperationObject;
import ch.e2e.builder.compiler.swagger.elements.ParameterObject;
import ch.e2e.builder.compiler.swagger.elements.ParameterTypeDefinition;
import ch.e2e.builder.compiler.swagger.elements.PathItem;
import ch.e2e.builder.compiler.swagger.elements.Required;
import ch.e2e.builder.compiler.swagger.elements.ResponseObject;
import ch.e2e.builder.compiler.swagger.elements.SchemaObject;
import ch.e2e.builder.compiler.swagger.elements.SecurityScheme;
import ch.e2e.builder.compiler.swagger.elements.TagDefinition;
import ch.e2e.builder.compiler.swagger.elements.TypeDefinition;
import ch.e2e.builder.compiler.swagger.helpers.SwaggerRepresenter;
import ch.e2e.builder.compiler.xml2yaml.Pair;
import ch.e2e.builder.compiler.xml2yaml.ServiceDescriptor;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.representer.Representer;

public class Xml2Yaml {
    private static String INTERNAL_TYPE_ANY = "Base_Types.Any";
    private static String INTERNAL_TYPE_ARRAY = "Base_Types.Array";
    private static String INTERNAL_TYPE_BLOB = "Base_Types.Blob";
    private static String INTERNAL_TYPE_BOOL = "Base_Types.Boolean";
    private static String INTERNAL_TYPE_DATETIME = "Base_Types.DateTime";
    private static String INTERNAL_TYPE_FLOAT = "Base_Types.Float";
    private static String INTERNAL_TYPE_INTEGER = "Base_Types.Integer";
    private static String INTERNAL_TYPE_STRING = "Base_Types.String";
    private static String INTERNAL_TYPE_UNKNOWN = "UNKNOWN";
    private static String EMPTY_DATA_ITEM = "EMPTY_DATA_ITEM";
    private static String URN_PREFIX = "urn:";
    private static String ARRAY_TYPE = "arrayType";
    private static String ARRAY_TYPE_ID = "arrayTypeID";
    private static String DATA_ITEM_ID = "id";
    private static String TYPE = "type";
    private static String TYPE_ID = "typeID";
    private Node port;
    private StringBuilder sb = new StringBuilder();
    private int indent = 0;
    private boolean isPortGenerated = false;
    private String arrayTypeAttribute = ARRAY_TYPE;
    private String typeAttribute = TYPE;
    private String dataItemIdAttribute = DATA_ITEM_ID;

    private static String getNodeName(Node node) {
        Node name = node.getAttributes().getNamedItem("name");
        if (name != null) {
            return name.getNodeValue();
        }
        return node.getNodeName();
    }

    public static List<ServiceDescriptor> processXML(Node servicesNode) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        NodeList ports = (NodeList)DomUtilities.evaluate((Node)servicesNode, (String)"descendant::port", (NamespaceContext)null, (QName)XPathConstants.NODESET);
        ArrayList<ServiceDescriptor> portList = new ArrayList<ServiceDescriptor>();
        for (int i = 0; i < ports.getLength(); ++i) {
            Node portNode = ports.item(i);
            portList.add(new ServiceDescriptor(Xml2Yaml.getNodeName(portNode.getParentNode()) + '_' + Xml2Yaml.getNodeName(portNode), Xml2Yaml.parsePort(portNode)));
        }
        return portList;
    }

    public static List<ServiceDescriptor> processXML(Document document) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        return Xml2Yaml.processXML(document.getDocumentElement());
    }

    public static List<ServiceDescriptor> processXML(File xmlFile) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document document = dBuilder.parse(xmlFile);
        return Xml2Yaml.processXML(document);
    }

    private static String parsePort(Node port) throws XPathExpressionException {
        return new Xml2Yaml(port).asString();
    }

    public Xml2Yaml(Node port) {
        this.port = port;
    }

    private String text(Node node) {
        return node == null ? "" : node.getTextContent();
    }

    private String typeName(String text) {
        String name = (text.startsWith(URN_PREFIX) ? text.substring(URN_PREFIX.length()) : text).replace(':', '.');
        if (name.equals(INTERNAL_TYPE_INTEGER)) {
            return "integer";
        }
        if (name.equals(INTERNAL_TYPE_FLOAT)) {
            return "number";
        }
        if (name.equals(INTERNAL_TYPE_BOOL)) {
            return "boolean";
        }
        if (name.equals(INTERNAL_TYPE_STRING)) {
            return "string";
        }
        if (name.equals(INTERNAL_TYPE_BLOB)) {
            return "blob";
        }
        if (name.equals(INTERNAL_TYPE_DATETIME)) {
            return "datetime";
        }
        if (name.equals(INTERNAL_TYPE_ARRAY)) {
            return "array";
        }
        return name;
    }

    private String getTypeName(Element element, String attributeName) {
        return this.typeName(element.getAttribute(attributeName));
    }

    private boolean isArray(String typeName) {
        return "array".equals(typeName);
    }

    private boolean isAny(String typeName) {
        return INTERNAL_TYPE_ANY.equals(typeName);
    }

    private boolean isSimple(String typeName) {
        return "integer".equals(typeName) | "number".equals(typeName) | "boolean".equals(typeName) | "blob".equals(typeName) | "datetime".equals(typeName) | "string".equals(typeName);
    }

    private boolean isRecord(String typeName) {
        return !this.isArray(typeName) && !this.isSimple(typeName) && !this.isAny(typeName);
    }

    private String translateTypeName(String typeName) {
        return "float".equals(typeName) ? "number" : typeName;
    }

    private void setSimpleType(TypeDefinition typeDefinition, String typeName, Element element) {
        this.setSimpleType(typeDefinition, typeName, element, false);
    }

    private void setSimpleType(TypeDefinition typeDefinition, String typeName, Element element, boolean isResponse) {
        typeDefinition.setType(typeName);
        if (typeName.equals("integer")) {
            if (element.hasAttribute("maxValue")) {
                typeDefinition.setMaximum(Double.valueOf(element.getAttribute("maxValue")).intValue());
            }
            if (element.hasAttribute("minValue")) {
                typeDefinition.setMinimum(Double.valueOf(element.getAttribute("minValue")).intValue());
            }
            try {
                Iterator it = DomUtilities.elementIterator((NodeList)this.getNodes(element, "./Enum"));
                while (it.hasNext()) {
                    typeDefinition.addEnumerator(Integer.valueOf(((Element)it.next()).getTextContent()));
                }
            }
            catch (XPathExpressionException it) {}
        } else if (typeName.equals("number")) {
            if (element.hasAttribute("maxValue")) {
                typeDefinition.setMaximum(Double.valueOf(element.getAttribute("maxValue")));
            }
            if (element.hasAttribute("minValue")) {
                typeDefinition.setMinimum(Double.valueOf(element.getAttribute("minValue")));
            }
        } else if (typeName.equals("string")) {
            if (element.hasAttribute("maxLength")) {
                typeDefinition.setMaxLength(Integer.valueOf(element.getAttribute("maxLength")));
            }
            if (element.hasAttribute("minLength")) {
                typeDefinition.setMinLength(Integer.valueOf(element.getAttribute("minLength")));
            }
            if (element.hasAttribute("length")) {
                Integer length = Integer.valueOf(element.getAttribute("length"));
                typeDefinition.setMinLength(length);
                typeDefinition.setMaxLength(length);
            }
            if (element.hasAttribute("pattern")) {
                typeDefinition.setPattern(element.getAttribute("pattern"));
            }
            try {
                Iterator it = DomUtilities.elementIterator((NodeList)this.getNodes(element, "./Enum"));
                while (it.hasNext()) {
                    typeDefinition.addEnumerator(((Element)it.next()).getTextContent());
                }
            }
            catch (XPathExpressionException it) {}
        } else if (typeName.equals(INTERNAL_TYPE_BLOB) || typeName.equals("blob")) {
            typeDefinition.setType("string");
            String in = element.getAttribute("in");
            if ("body".equals(in) || isResponse) {
                typeDefinition.setFormat("binary");
            } else {
                typeDefinition.setFormat("byte");
            }
        } else if (typeName.equals(INTERNAL_TYPE_DATETIME) || typeName.equals("datetime")) {
            typeDefinition.setType("string");
            typeDefinition.setFormat("date-time");
        }
    }

    public String asString() throws XPathExpressionException {
        NamedNodeMap attributes = this.port.getAttributes();
        Node isGeneratedItem = attributes.getNamedItem("isGenerated");
        boolean bl = this.isPortGenerated = isGeneratedItem != null && Boolean.valueOf(isGeneratedItem.getNodeValue()) != false;
        if (this.isPortGenerated) {
            this.arrayTypeAttribute = ARRAY_TYPE_ID;
            this.dataItemIdAttribute = TYPE_ID;
            this.typeAttribute = TYPE_ID;
        }
        Node description = (Node)DomUtilities.evaluate((Node)this.port, (String)"./description[1]", (NamespaceContext)null, (QName)XPathConstants.NODE);
        Info descriptorInfo = new Info(attributes.getNamedItem("name").getNodeValue(), this.text(description));
        Node apiVersion = attributes.getNamedItem("apiVersion");
        if (apiVersion != null) {
            descriptorInfo.setVersion(apiVersion.getNodeValue());
        }
        Descriptor descriptor = new Descriptor(descriptorInfo);
        descriptor.setSwagger("2.0");
        descriptor.setBasePath(this.text(attributes.getNamedItem("basePath")));
        this.setHost(descriptor);
        List<String> schemes = this.makeStringList(this.getNodes(this.port, "./scheme"));
        if (schemes.size() > 0) {
            descriptor.setSchemes(schemes);
        }
        descriptor.setConsumes(this.makeStringList(this.getNodes(this.port, "./accepts")));
        descriptor.setProduces(this.makeStringList(this.getNodes(this.port, "./produces")));
        this.setSecurity(descriptor);
        this.setTags(descriptor);
        this.setTypeDefinitions(descriptor);
        this.setPaths(descriptor);
        return this.dumpYaml(descriptor);
    }

    private String dumpYaml(Descriptor descriptor) {
        DumperOptions options = new DumperOptions();
        options.setAllowReadOnlyProperties(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml((Representer)new SwaggerRepresenter(), options);
        return yaml.dump((Object)descriptor);
    }

    private NodeList getNodes(Node parent, String xpath) throws XPathExpressionException {
        return (NodeList)DomUtilities.evaluate((Node)parent, (String)xpath, (NamespaceContext)null, (QName)XPathConstants.NODESET);
    }

    private List<String> makeStringList(NodeList nodes) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            list.add(this.text(nodes.item(i)));
        }
        return list;
    }

    private void setHost(Descriptor descriptor) throws XPathExpressionException {
        Node hostNode = (Node)DomUtilities.evaluate((Node)this.port, (String)"./host[1]", (NamespaceContext)null, (QName)XPathConstants.NODE);
        if (hostNode != null) {
            descriptor.setHost(this.text(hostNode));
        }
    }

    private void setSecurity(Descriptor descriptor) throws XPathExpressionException {
        NodeList securityNodes = this.getNodes(this.port, "./security/auth");
        if (securityNodes.getLength() > 0) {
            descriptor.setSecurityDefinitions(this.createSecurityDefinitions(securityNodes));
            descriptor.setSecurity(this.createSecurityRequirements(securityNodes));
        }
    }

    private List<Map<String, List<String>>> createSecurityRequirements(NodeList nodes) {
        ArrayList<Map<String, List<String>>> requirements = new ArrayList<Map<String, List<String>>>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            LinkedHashMap requirement = new LinkedHashMap();
            requirement.put(Xml2Yaml.getNodeName(nodes.item(i)), new ArrayList());
            requirements.add(requirement);
        }
        return requirements;
    }

    private Map<String, SecurityScheme> createSecurityDefinitions(NodeList nodes) {
        LinkedHashMap<String, SecurityScheme> definitions = new LinkedHashMap<String, SecurityScheme>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            String name = Xml2Yaml.getNodeName(element);
            SecurityScheme scheme = new SecurityScheme(element.getAttribute("type"));
            scheme.setDescription(element.getAttribute("description"));
            if ("apiKey".equals(scheme.getType())) {
                scheme.setName(name);
                scheme.setIn(element.getAttribute("in"));
            }
            definitions.put(name, scheme);
        }
        return definitions;
    }

    private void setTags(Descriptor descriptor) throws XPathExpressionException {
        NodeList tagNodes = this.getNodes(this.port, "./tags/tag");
        if (tagNodes.getLength() > 0) {
            descriptor.setTags(this.createTagDefinitions(tagNodes));
        }
    }

    private List<TagDefinition> createTagDefinitions(NodeList nodes) {
        ArrayList<TagDefinition> definitions = new ArrayList<TagDefinition>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            TagDefinition tagDefinition = new TagDefinition(Xml2Yaml.getNodeName(element));
            tagDefinition.setDescription(element.getAttribute("description"));
            String externalDocsURL = element.getAttribute("extrenalDocumentationURL");
            if (externalDocsURL != null && !externalDocsURL.isEmpty()) {
                ExternalDocumentation externalDocs = new ExternalDocumentation(externalDocsURL);
                externalDocs.setDescription(element.getAttribute("externalDocumentationDescription"));
                tagDefinition.setExternalDocs(externalDocs);
            }
            definitions.add(tagDefinition);
        }
        return definitions;
    }

    private void setPaths(Descriptor descriptor) throws XPathExpressionException {
        LinkedHashMap<String, PathItem> paths = new LinkedHashMap<String, PathItem>();
        Iterator pathElements = DomUtilities.elementIterator((NodeList)this.getNodes(this.port, "./path"));
        while (pathElements.hasNext()) {
            Element element = (Element)pathElements.next();
            paths.put(element.getAttribute("path"), this.createPath(element));
        }
        descriptor.setPaths(paths);
    }

    private PathItem createPath(Element element) throws XPathExpressionException {
        PathItem path = new PathItem();
        Iterator children = DomUtilities.elementIterator((NodeList)element.getChildNodes());
        while (children.hasNext()) {
            Element operationElement = (Element)children.next();
            OperationObject operation = this.createOperation(operationElement);
            String method = operationElement.getNodeName();
            if ("get".equals(method)) {
                path.setGet(operation);
                continue;
            }
            if ("put".equals(method)) {
                path.setPut(operation);
                continue;
            }
            if ("post".equals(method)) {
                path.setPost(operation);
                continue;
            }
            if ("delete".equals(method)) {
                path.setDelete(operation);
                continue;
            }
            if ("options".equals(method)) {
                path.setOptions(operation);
                continue;
            }
            if ("head".equals(method)) {
                path.setHead(operation);
                continue;
            }
            if (!"patch".equals(method)) continue;
            path.setPatch(operation);
        }
        return path;
    }

    private OperationObject createOperation(Element operationElement) throws XPathExpressionException {
        OperationObject operation = new OperationObject();
        Iterator children = DomUtilities.elementIterator((NodeList)operationElement.getChildNodes());
        while (children.hasNext()) {
            List<String> tags;
            Element element = (Element)children.next();
            String elementName = element.getNodeName();
            if ("summary".equals(elementName)) {
                operation.setSummary(element.getTextContent());
                continue;
            }
            if ("description".equals(elementName)) {
                operation.setDescription(element.getTextContent());
                continue;
            }
            if ("responses".equals(elementName)) {
                TreeMap<String, ResponseObject> responses = new TreeMap<String, ResponseObject>();
                Iterator responseElements = DomUtilities.elementIterator((NodeList)element.getChildNodes());
                TreeSet<String> produces = new TreeSet<String>();
                boolean hasUnspecified = false;
                while (responseElements.hasNext()) {
                    Element responseElement = (Element)responseElements.next();
                    String responseCode = responseElement.getAttribute("code");
                    responses.put(responseCode, this.createResponse(responseElement));
                    if (!responseCode.startsWith("2")) continue;
                    String contentType = responseElement.getAttribute("contentType");
                    List<String> contentTypes = this.makeStringList(this.getNodes(responseElement, "contentType/@value"));
                    if (!"".equals(contentType)) {
                        produces.add(contentType);
                        continue;
                    }
                    produces.addAll(contentTypes);
                    hasUnspecified = contentTypes.isEmpty();
                }
                operation.setResponses(responses);
                if (produces.isEmpty()) continue;
                if (hasUnspecified) {
                    produces.add("application/json");
                    produces.add("text/xml");
                }
                operation.setProduces(new ArrayList<String>(produces));
                continue;
            }
            if ("parameters".equals(elementName)) {
                ArrayList<ParameterObject> parameters = new ArrayList<ParameterObject>();
                Iterator parameterElements = DomUtilities.elementIterator((NodeList)element.getChildNodes());
                while (parameterElements.hasNext()) {
                    parameters.add(this.createParameter((Element)parameterElements.next()));
                }
                if (parameters.isEmpty()) continue;
                operation.setParameters(parameters);
                continue;
            }
            if (!"tags".equals(elementName) || (tags = this.makeStringList(this.getNodes(element, "tag/@name"))).size() <= 0) continue;
            operation.setTags(tags);
        }
        NodeList acceptNodes = this.getNodes(operationElement, "./accepts");
        if (acceptNodes.getLength() > 0) {
            operation.setConsumes(this.makeStringList(acceptNodes));
        }
        return operation;
    }

    private ResponseObject createResponse(Element responseElement) {
        ResponseObject response = new ResponseObject();
        response.setDescription("");
        NodeList children = responseElement.getChildNodes();
        if (children.getLength() > 0) {
            Iterator childrenIterator = DomUtilities.elementIterator((NodeList)children);
            while (childrenIterator.hasNext()) {
                Element child = (Element)childrenIterator.next();
                if ("description".equals(child.getNodeName())) {
                    response.setDescription(child.getTextContent());
                    continue;
                }
                if (!"header".equals(child.getNodeName())) continue;
                Pair<String, HeaderObject> responseHeader = this.createResponseHeader(child);
                response.addHeader(responseHeader.getFirst(), responseHeader.getSecond());
            }
        }
        String name = responseElement.getAttribute("name");
        String type = this.getTypeName(responseElement, this.typeAttribute);
        if (!(name.isEmpty() && type.isEmpty() || EMPTY_DATA_ITEM.equals(type))) {
            SchemaObject schema = new SchemaObject();
            if (this.isArray(type)) {
                this.setArrayItems(this.getTypeName(responseElement, this.arrayTypeAttribute), schema, responseElement);
                if (!name.isEmpty()) {
                    schema.setTitle(name);
                }
            } else if (!type.isEmpty()) {
                this.setNonArrayTypeReference(type, schema, responseElement, true);
            }
            response.setSchema(schema);
        }
        return response;
    }

    private void setNonArrayTypeReference(String type, TypeDefinition typeDefinition, Element element) {
        this.setNonArrayTypeReference(type, typeDefinition, element, false);
    }

    private void setNonArrayTypeReference(String type, TypeDefinition typeDefinition, Element element, boolean isResponse) {
        if (this.isRecord(type)) {
            typeDefinition.set$ref("#/definitions/" + type);
        } else {
            this.setSimpleType(typeDefinition, type, element, isResponse);
        }
    }

    private void setNonArrayTypeReference(String type, ParameterTypeDefinition typeDefinition, Element parameterElement) {
        if (this.isRecord(type)) {
            SchemaObject schema = new SchemaObject();
            this.setNonArrayTypeReference(type, schema, parameterElement);
            typeDefinition.setSchema(schema);
        } else {
            this.setSimpleType(typeDefinition, type, parameterElement);
        }
    }

    private void setArrayItems(String type, TypeDefinition typeDefinition, Element element) {
        typeDefinition.setType("array");
        TypeDefinition items = new TypeDefinition();
        this.setNonArrayTypeReference(type, items, element);
        typeDefinition.setItems(items);
    }

    private Pair<String, HeaderObject> createResponseHeader(Element headerElement) {
        String type;
        HeaderObject header = new HeaderObject();
        NodeList descriptionNodes = headerElement.getElementsByTagName("description");
        if (descriptionNodes.getLength() > 0) {
            header.setDescription(this.text(descriptionNodes.item(0)));
        }
        if (this.isArray(type = this.getTypeName(headerElement, this.typeAttribute))) {
            header.setType("array");
            header.setCollectionFormat("csv");
            TypeDefinition items = new TypeDefinition();
            this.setSimpleType(items, this.getTypeName(headerElement, this.arrayTypeAttribute), headerElement);
            header.setItems(items);
        } else {
            this.setNonArrayTypeReference(type, header, headerElement);
        }
        return new Pair<String, HeaderObject>(headerElement.getAttribute("name"), header);
    }

    private ParameterObject createParameter(Element parameterElement) {
        ParameterObject param = new ParameterObject();
        param.setName(parameterElement.getAttribute("name"));
        String in = parameterElement.getAttribute("in");
        param.setIn(in);
        param.setRequired(new Required(parameterElement.getAttribute("required").equals("true")));
        Iterator children = DomUtilities.elementIterator((NodeList)parameterElement.getChildNodes());
        while (children.hasNext()) {
            Element element = (Element)children.next();
            String nodeName = element.getNodeName();
            if (nodeName.equals("defaultValue")) {
                param.setDefault(this.text(element));
                continue;
            }
            if (!nodeName.equals("description")) continue;
            param.setDescription(this.text(element));
        }
        String type = this.getTypeName(parameterElement, this.typeAttribute);
        if (!this.isArray(type)) {
            this.setNonArrayTypeReference(type, param, parameterElement);
            return param;
        }
        String arrayType = this.getTypeName(parameterElement, this.arrayTypeAttribute);
        if ("header".equals(in) || "query".equals(in)) {
            if ("header".equals(in)) {
                param.setCollectionFormat("csv");
            } else {
                param.setCollectionFormat("multi");
            }
            this.setArrayItems(arrayType, param, parameterElement);
        } else {
            SchemaObject schema = new SchemaObject();
            schema.setTitle(param.getName());
            this.setArrayItems(arrayType, schema, parameterElement);
            param.setSchema(schema);
        }
        return param;
    }

    private void setTypeDefinitions(Descriptor descriptor) throws XPathExpressionException {
        NodeList definitions = this.getNodes(this.port, "./definitions/*");
        if (definitions.getLength() > 0) {
            descriptor.setDefinitions(this.createTypeDefinitions(DomUtilities.elementIterator((NodeList)definitions)));
        }
    }

    private Map<String, TypeDefinition> createTypeDefinitions(Iterator<Element> definitionIterator) {
        LinkedHashMap<String, TypeDefinition> definitions = new LinkedHashMap<String, TypeDefinition>();
        while (definitionIterator.hasNext()) {
            Element element = definitionIterator.next();
            definitions.put(this.getTypeName(element, this.dataItemIdAttribute), this.createTypeDefinition(element));
        }
        return definitions;
    }

    private TypeDefinition createTypeDefinition(Element definitionNode) {
        TypeDefinition typeDefinition = new TypeDefinition();
        if (!this.isAny(this.getTypeName(definitionNode, TYPE_ID))) {
            LinkedHashMap<String, TypeDefinition> properties = new LinkedHashMap<String, TypeDefinition>();
            Iterator children = DomUtilities.elementIterator((NodeList)definitionNode.getChildNodes());
            while (children.hasNext()) {
                Element element = (Element)children.next();
                properties.put(Xml2Yaml.getNodeName(element), this.createProperty(element));
            }
            typeDefinition.setProperties(properties);
            typeDefinition.setType("object");
        }
        return typeDefinition;
    }

    private TypeDefinition createProperty(Element element) {
        TypeDefinition property = new TypeDefinition();
        String itemName = element.getNodeName();
        if (itemName.equals("array")) {
            String typeName = this.getTypeName(element, this.typeAttribute);
            this.setArrayItems(typeName, property, element);
        } else if (itemName.equals("record")) {
            property.set$ref("#/definitions/" + this.getTypeName(element, this.typeAttribute));
        } else {
            this.setSimpleType(property, this.translateTypeName(itemName), element);
        }
        return property;
    }
}

