/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.build.types.Breakpoint;
import ch.e2e.builder.compiler.uml.ActionState;
import ch.e2e.builder.compiler.uml.AmbiguousOperationException;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgeComponent;
import ch.e2e.builder.compiler.uml.BridgeDependency;
import ch.e2e.builder.compiler.uml.BridgeNode;
import ch.e2e.builder.compiler.uml.BridgeNodeInstance;
import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.BridgeRealization;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.BridgeUsage;
import ch.e2e.builder.compiler.uml.ClassifierElement;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.ComponentDiagram;
import ch.e2e.builder.compiler.uml.DeploymentDiagram;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Generalization;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Logging;
import ch.e2e.builder.compiler.uml.Property;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.builder.compiler.uml.UserTemplate;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.SwingUtilities;

public abstract class ElementHelper {
    public static final String ELEMENT_HELPER_KEY = "ch.e2e.builder.compiler.uml.element.helper";
    public static final String BASETYPES_ANY = "Base Types/Any";
    public static final String BASETYPES_ARRAY = "Base Types/Array";
    public static final String BASETYPES_BLOB = "Base Types/Blob";
    public static final String BASETYPES_BOOLEAN = "Base Types/Boolean";
    public static final String BASETYPES_DATETINE = "Base Types/DateTime";
    public static final String BASETYPES_FLOAT = "Base Types/Float";
    public static final String BASETYPES_INTEGER = "Base Types/Integer";
    public static final String BASETYPES_STRING = "Base Types/String";
    public static final String BASETYPES_DEFAULT = "Base Types/String";
    public static final String BASETYPES_PACKAGE = "Base Types";
    public static final String BASE_COMPONENTS_MAP_ENTRY = "Base Components/Add Ons/Java/MapEntry";
    public static final String BASE_COMPONENTS_JMS_BLOB_MESSAGE = "Base Components/Add Ons/JMS/JMSBlobMessage";
    public static final String BASE_COMPONENTS_JMS_STRING_MESSAGE = "Base Components/Add Ons/JMS/JMSStringMessage";
    public static final String BASE_COMPONENTS_REST_NORESPONSEBODY = "Base Components/Add Ons/REST/NoResponseBody";
    public static final String PROPERTY_ALIAS = "alias";
    public static final String PROPERTY_BOOT = "boot";
    public static final String PROPERTY_DEPLOY = "deploy";
    public static final String PROPERTY_JMS_CONNECTION_FACTORY = "jmsConnectionFactory";
    private static List<String> simpleTypeNames = new ArrayList<String>();
    private Map<String, BridgeClass> bridgeClasses;
    private Map<String, BridgeClass> simpleTypes;
    private Map<BridgeStereotype, List<DeploymentElement>> temporarlyArtifacts = new HashMap<BridgeStereotype, List<DeploymentElement>>();
    private Map<BridgeStereotype, List<BridgeNode>> serverMap;
    private Helpers helpers;

    protected ElementHelper(Helpers helpers) {
        this.helpers = helpers;
        this.bridgeClasses = new HashMap<String, BridgeClass>();
        this.simpleTypes = new HashMap<String, BridgeClass>();
        this.serverMap = new HashMap<BridgeStereotype, List<BridgeNode>>();
    }

    protected Helpers getHelpers() {
        return this.helpers;
    }

    public abstract ActionState getActionState(String var1);

    protected abstract boolean doSelectElementInContainmentTree(String var1);

    protected abstract boolean doSelectElement(String var1, boolean var2) throws AmbiguousOperationException;

    public abstract boolean checkBreakpoint(Breakpoint var1);

    protected abstract void doUpdateBreakpointAnnotation(Breakpoint var1);

    protected abstract void doRemoveBreakpointAnnotation(Breakpoint var1);

    protected abstract void doUpdateBreakpointAnnotations(Collection<? extends Breakpoint> var1);

    protected abstract void doRemoveBreakpointAnnotations(Collection<? extends Breakpoint> var1);

    public abstract BridgeClass findType(String var1);

    public abstract BridgeClass findBaseType(String var1, String var2);

    public abstract List<DeploymentElement> getExistingAliases();

    public abstract ArrayList<String> getDeploymentDiagramNames();

    public abstract List<String> getComponentDiagramNames();

    public abstract List<BridgeNodeInstance> findExistingNodeInstances(BridgeStereotype var1);

    public abstract List<UmlElement> findExistingTypes();

    public abstract List<UmlElement> findExistingTypes(BridgeStereotype var1);

    public abstract List<UmlElement> findExistingTypes(BridgeStereotype var1, boolean var2);

    public abstract List<UmlElement> findExistingTypes(BridgeStereotype var1, boolean var2, boolean var3);

    public abstract List<ClassifierElement> getExistingClassifier(BridgeStereotype var1);

    public abstract ArrayList<DeploymentElement> getExistingArtifacts(String var1);

    public abstract List<DeploymentElement> getExistingArtifacts(BridgeStereotype var1);

    public abstract List<DeploymentElement> getExistingArtifacts(BridgeStereotype var1, boolean var2);

    public abstract List<String> getExistingElementNames(BridgeStereotype var1);

    public abstract List<UmlElement> getExistingElements(BridgeStereotype var1);

    public abstract List<UmlElement> getExistingSignals();

    public abstract ArrayList<UmlElement> findE2EComponentTemplates(BridgeStereotype var1, boolean var2);

    public abstract ArrayList<UmlElement> findE2EDeploymentTemplates(BridgeStereotype var1, boolean var2);

    public abstract ArrayList<UserTemplate> findUserTemplates(BridgeStereotype var1);

    public abstract Object getSystemValue(Property var1);

    public abstract ComponentDiagram findDefiningComponentDiagram(DeploymentElement var1);

    public abstract ArrayList<ComponentDiagram> getUnloadedComponentDiagrams(ComponentDiagram var1);

    public abstract ArrayList<ComponentDiagram> getUnloadedLibraryDiagrams(ComponentDiagram var1);

    public abstract ArrayList<DeploymentDiagram> getUnloadedDeploymentDiagrams(DeploymentDiagram var1);

    public abstract DeploymentDiagram createDeploymentDiagram(Object var1);

    public abstract void setDefiningLibraryDiagram(DeploymentDiagram var1);

    public abstract ArrayList<UmlElement> findAllElements(BridgePackage var1);

    public abstract ArrayList<UmlElement> findAllElements(Class ... var1);

    public abstract DeploymentElement findDeploymentElement(String var1);

    protected abstract BridgeClass createBridgeClass(String var1, Object var2, BridgeStereotype var3);

    public abstract void createArtifactReference(DeploymentElement var1) throws Exception;

    public abstract void createClassReference(ClassifierElement var1) throws Exception;

    public abstract void createComponentReference(BridgeComponent var1) throws Exception;

    public abstract void createDependency(BridgeDependency var1) throws Exception;

    public abstract void createRealizationReference(BridgeRealization var1) throws Exception;

    public abstract void createUsageReference(BridgeUsage var1) throws Exception;

    public abstract void createGeneralizationReference(Generalization var1) throws Exception;

    public abstract void checkReferences(UmlElement var1) throws Exception;

    public abstract void createSession(String var1);

    public abstract void closeSession();

    public abstract void cancelSession();

    public abstract boolean isSessionCreated();

    public boolean selectElement(String xmiId, boolean annotate) throws AmbiguousOperationException {
        boolean found = false;
        if (SwingUtilities.isEventDispatchThread()) {
            found = this.doSelectElement(xmiId, annotate);
        } else {
            ElementSelector elementSelector = new ElementSelector(this, xmiId, annotate);
            SwingUtilities.invokeLater(elementSelector);
            try {
                found = (Boolean)elementSelector.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return found;
    }

    public boolean selectElementInContainmentTree(String xmiId) {
        boolean found = false;
        if (SwingUtilities.isEventDispatchThread()) {
            found = this.doSelectElementInContainmentTree(xmiId);
        } else {
            InTreeElementSelector elementSelector = new InTreeElementSelector(this, xmiId);
            SwingUtilities.invokeLater(elementSelector);
            try {
                found = (Boolean)elementSelector.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return found;
    }

    public void updateBreakpointAnnotation(Breakpoint breakpoint) {
        if (breakpoint != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.doUpdateBreakpointAnnotation(breakpoint);
            } else {
                SwingUtilities.invokeLater(new BreakpointAnnotator(this, breakpoint, false));
            }
        }
    }

    public void removeBreakpointAnnotation(Breakpoint breakpoint) {
        if (breakpoint != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.doRemoveBreakpointAnnotation(breakpoint);
            } else {
                SwingUtilities.invokeLater(new BreakpointAnnotator(this, breakpoint, true));
            }
        }
    }

    public void updateBreakpointAnnotations(List<? extends Breakpoint> breakpoints) {
        if (breakpoints != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.doUpdateBreakpointAnnotations(breakpoints);
            } else {
                SwingUtilities.invokeLater(new BreakpointAnnotator(this, breakpoints, false));
            }
        }
    }

    public void removeBreakpointAnnotations(List<? extends Breakpoint> breakpoints) {
        if (breakpoints != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.doRemoveBreakpointAnnotations(breakpoints);
            } else {
                SwingUtilities.invokeLater(new BreakpointAnnotator(this, breakpoints, true));
            }
        }
    }

    public <T> T createValue(String value, Class<T> clazz) {
        T element = null;
        try {
            Constructor<T> constructor = clazz.getConstructor(String.class);
            element = constructor.newInstance(value);
        }
        catch (Exception e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(this.getClass().getName(), "createValue", e);
        }
        return element;
    }

    public void reset() {
        this.bridgeClasses.clear();
        this.temporarlyArtifacts.clear();
        this.serverMap.clear();
        this.simpleTypes.clear();
    }

    public BridgeClass getBridgeClass(String xmiId, Object reference, BridgeStereotype stereotype) {
        BridgeClass result = this.bridgeClasses.get(xmiId);
        if (result == null) {
            result = this.createBridgeClass(xmiId, reference, stereotype);
            this.registerBridgeClass(result);
        }
        return result;
    }

    public BridgeClass getBridgeClass(String xmiId) {
        return this.bridgeClasses.get(xmiId);
    }

    public void addArtifactTemporarly(DeploymentElement artifact) {
        List<DeploymentElement> artifacts = this.temporarlyArtifacts.get(artifact.getStereotype());
        if (artifacts == null) {
            artifacts = new ArrayList<DeploymentElement>();
            this.temporarlyArtifacts.put(artifact.getStereotype(), artifacts);
        }
        artifacts.add(artifact);
        if (artifact.getStereotype().isArchive()) {
            for (UmlElement child : artifact.getAllChildren()) {
                this.addArtifactTemporarly((DeploymentElement)child);
            }
        }
    }

    public List<DeploymentElement> getTemporarlyArtifacts(BridgeStereotype stereotype) {
        List<DeploymentElement> artifacts = this.temporarlyArtifacts.get(stereotype);
        if (artifacts == null) {
            artifacts = new ArrayList<DeploymentElement>();
            this.temporarlyArtifacts.put(stereotype, artifacts);
        }
        return artifacts;
    }

    public BridgeNode findServer(String name) {
        BridgeNode result = null;
        if (this.serverMap.size() < 3) {
            this.createServerLists();
        }
        Iterator<List<BridgeNode>> nodeLists = this.serverMap.values().iterator();
        while (nodeLists.hasNext() && result == null) {
            List<BridgeNode> nodes = nodeLists.next();
            int length = nodes.size();
            for (int i = 0; i < length && result == null; ++i) {
                if (!nodes.get(i).getName().equals(name)) continue;
                result = nodes.get(i);
            }
        }
        return result;
    }

    public List<BridgeNode> findExistingNodes(BridgeStereotype stereotype) {
        List<BridgeNode> elements = this.serverMap.get(stereotype);
        if (elements == null) {
            elements = this.createNodeList(stereotype);
            this.serverMap.put(stereotype, elements);
        }
        return elements;
    }

    public boolean isSimpleType(BridgeClass clazz) {
        return this.simpleTypes.containsKey(clazz.getXmiID());
    }

    protected List<BridgeNode> createNodeList(BridgeStereotype stereotype) {
        ArrayList<BridgeNode> elements = new ArrayList<BridgeNode>();
        if (stereotype.getName().equals("E2EBridgeServer")) {
            this.createBridgeServerList(elements);
        } else if (stereotype.getName().equals("BackendServer")) {
            this.createBackendServerList(elements);
        } else if (stereotype.getName().equals("E2EProxyServer")) {
            // empty if block
        }
        return elements;
    }

    protected void createBridgeServerList(List<? super BridgeNode> serverList) {
        BridgeStereotype nodeType = this.getHelpers().getStereotypeFactory().getStereotype("E2EBridgeServer");
        BridgeNode node = new BridgeNode("Windows", new Comment("", this.getHelpers()), nodeType, this.getHelpers());
        serverList.add(node);
        node = new BridgeNode("Linux", new Comment("", this.getHelpers()), nodeType, this.getHelpers());
        serverList.add(node);
        node = new BridgeNode("AIX", new Comment("", this.getHelpers()), nodeType, this.getHelpers());
        serverList.add(node);
    }

    protected void createBackendServerList(List<? super BridgeNode> serverList) {
        BridgeStereotype nodeType = this.getHelpers().getStereotypeFactory().getStereotype("BackendServer");
        BridgeNode node = new BridgeNode("BackendServer", new Comment("", this.getHelpers()), nodeType, this.getHelpers());
        serverList.add(node);
    }

    private void createServerLists() {
        BridgeStereotype proxyType;
        BridgeStereotype backendType;
        BridgeStereotype bridgeType = this.getHelpers().getStereotypeFactory().getStereotype("E2EBridgeServer");
        if (this.serverMap.get(bridgeType) == null) {
            this.findExistingNodes(bridgeType);
        }
        if (this.serverMap.get(backendType = this.getHelpers().getStereotypeFactory().getStereotype("BackendServer")) == null) {
            this.findExistingNodes(backendType);
        }
        if (this.serverMap.get(proxyType = this.getHelpers().getStereotypeFactory().getStereotype("E2EProxyServer")) == null) {
            this.findExistingNodes(proxyType);
        }
    }

    protected void registerBridgeClass(BridgeClass bridgeClass) {
        if (!this.bridgeClasses.containsKey(bridgeClass.getXmiID())) {
            this.bridgeClasses.put(bridgeClass.getXmiID(), bridgeClass);
            if (bridgeClass.getOwningPackage() != null && bridgeClass.getOwningPackage().getName().equals(BASETYPES_PACKAGE) && simpleTypeNames.contains(bridgeClass.getName()) && !this.simpleTypes.containsKey(bridgeClass.getXmiID())) {
                this.simpleTypes.put(bridgeClass.getXmiID(), bridgeClass);
            }
        }
    }

    static {
        simpleTypeNames.add("Boolean");
        simpleTypeNames.add("DateTime");
        simpleTypeNames.add("Float");
        simpleTypeNames.add("Integer");
        simpleTypeNames.add("String");
    }

    private static class BreakpointAnnotator
    extends FutureTask<Void> {
        public BreakpointAnnotator(final ElementHelper helper, final Collection<? extends Breakpoint> breakpoints, final boolean remove) {
            super(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (remove) {
                        helper.doRemoveBreakpointAnnotations(breakpoints);
                    } else {
                        helper.doUpdateBreakpointAnnotations(breakpoints);
                    }
                    return null;
                }
            });
        }

        public BreakpointAnnotator(final ElementHelper helper, final Breakpoint breakpoint, final boolean remove) {
            super(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (remove) {
                        helper.doRemoveBreakpointAnnotation(breakpoint);
                    } else {
                        helper.doUpdateBreakpointAnnotation(breakpoint);
                    }
                    return null;
                }
            });
        }
    }

    private static class InTreeElementSelector
    extends FutureTask<Boolean> {
        public InTreeElementSelector(final ElementHelper helper, final String xmiId) {
            super(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return helper.doSelectElementInContainmentTree(xmiId);
                }
            });
        }
    }

    private static class ElementSelector
    extends FutureTask<Boolean> {
        public ElementSelector(final ElementHelper helper, final String xmiId, final boolean annotate) {
            super(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return helper.doSelectElement(xmiId, annotate);
                }
            });
        }
    }
}

