/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.build.types.Breakpoint;
import ch.e2e.builder.compiler.models.EBMClass;
import ch.e2e.builder.compiler.models.EBMElement;
import ch.e2e.builder.compiler.models.EBMElementInterface;
import ch.e2e.builder.compiler.models.EBMEnumeration;
import ch.e2e.builder.compiler.models.EBMPackage;
import ch.e2e.builder.compiler.models.EBMSignal;
import ch.e2e.builder.compiler.uml.ActionState;
import ch.e2e.builder.compiler.uml.AmbiguousOperationException;
import ch.e2e.builder.compiler.uml.BridgeAttribute;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgeComponent;
import ch.e2e.builder.compiler.uml.BridgeDependency;
import ch.e2e.builder.compiler.uml.BridgeEnumeration;
import ch.e2e.builder.compiler.uml.BridgeNodeInstance;
import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.BridgeRealization;
import ch.e2e.builder.compiler.uml.BridgeSignal;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.BridgeUsage;
import ch.e2e.builder.compiler.uml.ClassifierElement;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.ComponentDiagram;
import ch.e2e.builder.compiler.uml.ComponentTemplate;
import ch.e2e.builder.compiler.uml.DefaultPackagesFactory;
import ch.e2e.builder.compiler.uml.DeploymentDiagram;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.ElementHelper;
import ch.e2e.builder.compiler.uml.Generalization;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.builder.compiler.uml.Property;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.builder.compiler.uml.UserTemplate;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultElementHelper
extends ElementHelper {
    public static final String BASE_COMPONENTS_REST_NORESPONSEBODY_XMIID = "_Base_Components__Add_Ons__REST__NoResponseBody";
    public static final String BASE_COMPONENTS_REST_PACKAGE = "Base Components/Add Ons/REST";
    private Map<BridgeStereotype, ArrayList<UmlElement>> templatesMap = new HashMap<BridgeStereotype, ArrayList<UmlElement>>();
    static String BASETYPES_XMIID_PREFIX = "http://www.e2e.ch/bridge/types/";
    private Module bridgeBase;

    public DefaultElementHelper(Helpers helpers) {
        super(helpers);
    }

    @Override
    protected boolean doSelectElementInContainmentTree(String xmiId) {
        return false;
    }

    @Override
    protected boolean doSelectElement(String xmiId, boolean annotate) throws AmbiguousOperationException {
        return false;
    }

    @Override
    public boolean checkBreakpoint(Breakpoint breakpoint) {
        return false;
    }

    @Override
    public ArrayList<UmlElement> findAllElements(Class ... referenceTypes) {
        return new ArrayList<UmlElement>();
    }

    @Override
    protected void doUpdateBreakpointAnnotation(Breakpoint breakpoint) {
    }

    @Override
    protected void doRemoveBreakpointAnnotation(Breakpoint breakpoint) {
    }

    @Override
    protected void doUpdateBreakpointAnnotations(Collection<? extends Breakpoint> breakpoints) {
    }

    @Override
    protected void doRemoveBreakpointAnnotations(Collection<? extends Breakpoint> breakpoints) {
    }

    @Override
    public ActionState getActionState(String xmiId) {
        return null;
    }

    @Override
    public void reset() {
        this.templatesMap.clear();
        super.reset();
    }

    private FindInfo getFindInfo(String name) {
        String packageName;
        String typeInfo;
        FindInfo findInfo = new FindInfo();
        int index = name.indexOf(58);
        if (index == -1) {
            typeInfo = "";
            findInfo.name = name;
        } else {
            typeInfo = name.substring(0, index);
            findInfo.name = name.substring(index + 1);
        }
        findInfo.type = typeInfo.equals("uml-signal") ? EBMSignal.class : EBMClass.class;
        index = findInfo.name.lastIndexOf(47);
        if (index == -1) {
            packageName = "";
        } else {
            packageName = findInfo.name.substring(0, index);
            findInfo.name = findInfo.name.substring(index + 1);
        }
        findInfo.bridgePackage = this.getHelpers().getPackagesFactory().getPackage(packageName);
        return findInfo;
    }

    @Override
    public BridgeClass findType(String name) {
        return this.findTypeByID(name, null);
    }

    public BridgeClass findTypeByID(String name, String xmiID) {
        BridgeClass bridgeClass = null;
        FindInfo findInfo = this.getFindInfo(name);
        if (findInfo.bridgePackage.getReference() != null) {
            EBMElement ebmBaseType = ((EBMPackage)findInfo.bridgePackage.getReference()).findById(findInfo.type, xmiID);
            if (ebmBaseType == null) {
                ebmBaseType = ((EBMPackage)findInfo.bridgePackage.getReference()).find(findInfo.type, findInfo.name);
            }
            if (ebmBaseType != null) {
                bridgeClass = this.getBridgeClass(ebmBaseType.getXmiId(), ebmBaseType, null);
            }
        }
        if (bridgeClass == null) {
            for (UmlElement umlElement : findInfo.bridgePackage.getAllChildren()) {
                if (!umlElement.getName().equals(name) || !(umlElement instanceof BridgeClass)) continue;
                return (BridgeClass)umlElement;
            }
        }
        return bridgeClass;
    }

    @Override
    public BridgeClass findBaseType(String name, String xmiID) {
        if (name.equals("Base Types/String")) {
            return this.createBaseComponentBridgeClass("Base Types/String", BASETYPES_XMIID_PREFIX + "String", null, "Base Types");
        }
        if (name.equals("Base Types/Integer")) {
            return this.createBaseComponentBridgeClass("Base Types/Integer", BASETYPES_XMIID_PREFIX + "Integer", null, "Base Types");
        }
        if (name.equals("Base Types/Any")) {
            return this.createBaseComponentBridgeClass("Base Types/Any", BASETYPES_XMIID_PREFIX + "Any", null, "Base Types");
        }
        if (name.equals("Base Types/Array")) {
            return this.createBaseComponentBridgeClass("Base Types/Array", BASETYPES_XMIID_PREFIX + "Array", null, "Base Types");
        }
        if (name.equals("Base Types/Blob")) {
            return this.createBaseComponentBridgeClass("Base Types/Blob", BASETYPES_XMIID_PREFIX + "Blob", null, "Base Types");
        }
        if (name.equals("Base Types/Boolean")) {
            return this.createBaseComponentBridgeClass("Base Types/Boolean", BASETYPES_XMIID_PREFIX + "Boolean", null, "Base Types");
        }
        if (name.equals("Base Types/DateTime")) {
            return this.createBaseComponentBridgeClass("Base Types/DateTime", BASETYPES_XMIID_PREFIX + "DateTime", null, "Base Types");
        }
        if (name.equals("Base Types/Float")) {
            return this.createBaseComponentBridgeClass("Base Types/Float", BASETYPES_XMIID_PREFIX + "Float", null, "Base Types");
        }
        return this.findTypeByID(name, xmiID);
    }

    private Module getBridgeBaseModule() {
        if (this.bridgeBase == null) {
            this.bridgeBase = this.getHelpers().getModuleFactory().getModule(new File("/<install.root>/modelLibraries/E2E Bridge Base.xml"), "E2E Bridge Base.xml");
            this.bridgeBase.addMountPointId("e2e_bridge_base_types");
            this.bridgeBase.addMountPointId("e2e_bridge_base_components");
            this.bridgeBase.addMountPointId("e2e_bridge_base_customizations");
            this.getHelpers().getPackagesFactory().getPackage("E2E Customizations").setXmiID("e2e_bridge_base_customizations");
            this.getHelpers().getPackagesFactory().getPackage("Base Components").setXmiID("e2e_bridge_base_components");
            this.getHelpers().getPackagesFactory().getPackage("Base Types").setXmiID("e2e_bridge_base_types");
        }
        return this.bridgeBase;
    }

    private BridgeClass getDummyComponentClass() {
        BridgeClass bridgeClass = this.createBridgeClass("Base Components/Dummy", null, null);
        bridgeClass.setOwningPackage(this.getHelpers().getPackagesFactory().getPackage("Base Components"));
        bridgeClass.setModule(this.getBridgeBaseModule());
        return bridgeClass;
    }

    protected BridgeClass createBaseComponentBridgeClass(String qualifiedName, String xmiId, BridgeStereotype stereotype, String packageName) {
        BridgeClass bridgeClass = this.createBridgeClass(qualifiedName, null, stereotype);
        bridgeClass.setOwningPackage(this.getHelpers().getPackagesFactory().getPackage(packageName));
        bridgeClass.setXmiID(xmiId);
        BridgeAttribute attribute = new BridgeAttribute("dummy", new Comment("", this.getHelpers()), null, this.getHelpers());
        attribute.setTypeClass(this.getDummyComponentClass());
        bridgeClass.addAttribute(attribute);
        bridgeClass.setModule(this.getBridgeBaseModule());
        return bridgeClass;
    }

    @Override
    public List<DeploymentElement> getExistingAliases() {
        return new ArrayList<DeploymentElement>();
    }

    @Override
    public List<String> getComponentDiagramNames() {
        return new ArrayList<String>();
    }

    @Override
    public ArrayList<String> getDeploymentDiagramNames() {
        return new ArrayList<String>();
    }

    @Override
    public List<ClassifierElement> getExistingClassifier(BridgeStereotype stereotype) {
        return new ArrayList<ClassifierElement>();
    }

    @Override
    public List<BridgeNodeInstance> findExistingNodeInstances(BridgeStereotype stereotype) {
        return new ArrayList<BridgeNodeInstance>();
    }

    @Override
    public List<UmlElement> findExistingTypes(BridgeStereotype bridgeStereotype) {
        return this.findExistingTypes(bridgeStereotype, true);
    }

    @Override
    public List<UmlElement> findExistingTypes(BridgeStereotype bridgeStereotype, boolean checkManifestation) {
        return this.findExistingTypes(bridgeStereotype, true, false);
    }

    @Override
    public List<UmlElement> findExistingTypes(BridgeStereotype bridgeStereotype, boolean checkManifestation, boolean excludeFinalSpecialization) {
        return null;
    }

    @Override
    public List<String> getExistingElementNames(BridgeStereotype stereotype) {
        return new ArrayList<String>();
    }

    @Override
    public List<UmlElement> getExistingElements(BridgeStereotype bridgeStereotype) {
        return new ArrayList<UmlElement>();
    }

    @Override
    public List<UmlElement> getExistingSignals() {
        return new ArrayList<UmlElement>();
    }

    @Override
    public ArrayList<DeploymentElement> getExistingArtifacts(String deploymentTypeKey) {
        return this.getExistingArtifacts(this.getHelpers().getStereotypeFactory().getStereotype(deploymentTypeKey));
    }

    public ArrayList<DeploymentElement> getExistingArtifacts(BridgeStereotype deploymentType) {
        return new ArrayList<DeploymentElement>();
    }

    public ArrayList<DeploymentElement> getExistingArtifacts(BridgeStereotype deploymentType, boolean hideInOldWizard) {
        return new ArrayList<DeploymentElement>();
    }

    @Override
    public ArrayList<UserTemplate> findUserTemplates(BridgeStereotype stereotype) {
        return new ArrayList<UserTemplate>();
    }

    @Override
    public ArrayList<UmlElement> findE2EDeploymentTemplates(BridgeStereotype stereotype, boolean checkManifestation) {
        ArrayList<UmlElement> templates = this.templatesMap.get(stereotype);
        if (templates == null) {
            BridgeStereotype templateType = this.getHelpers().getStereotypeFactory().getStereotype("E2EArtifactTemplate");
            templates = this.createTemplates(stereotype);
            ArrayList<UmlElement> templatesToRemove = new ArrayList<UmlElement>();
            for (UmlElement template : templates) {
                if (template.hasStereotype(templateType)) continue;
                templatesToRemove.add(template);
            }
            templates.removeAll(templatesToRemove);
            this.templatesMap.put(stereotype, templates);
        }
        return templates;
    }

    @Override
    public ArrayList<UmlElement> findE2EComponentTemplates(BridgeStereotype stereotype, boolean checkManifestation) {
        ArrayList<UmlElement> templates = this.templatesMap.get(stereotype);
        if (templates == null) {
            templates = this.createTemplates(stereotype);
            this.templatesMap.put(stereotype, templates);
        }
        return templates;
    }

    @Override
    public Object getSystemValue(Property property) {
        return null;
    }

    @Override
    public List<UmlElement> findExistingTypes() {
        return new ArrayList<UmlElement>();
    }

    public BridgeNodeInstance createBridgeNodeInstance(Object instanceSpecification) {
        return null;
    }

    @Override
    public void setDefiningLibraryDiagram(DeploymentDiagram deploymentDiagram) {
    }

    @Override
    public ArrayList<ComponentDiagram> getUnloadedLibraryDiagrams(ComponentDiagram existingDiagram) {
        return new ArrayList<ComponentDiagram>();
    }

    @Override
    public ArrayList<ComponentDiagram> getUnloadedComponentDiagrams(ComponentDiagram diagram) {
        return new ArrayList<ComponentDiagram>();
    }

    @Override
    public DeploymentDiagram createDeploymentDiagram(Object diagramObject) {
        return null;
    }

    @Override
    public ArrayList<DeploymentDiagram> getUnloadedDeploymentDiagrams(DeploymentDiagram diagram) {
        return new ArrayList<DeploymentDiagram>();
    }

    @Override
    public ComponentDiagram findDefiningComponentDiagram(DeploymentElement configuration) {
        return null;
    }

    @Override
    public ArrayList<UmlElement> findAllElements(BridgePackage owningPackage) {
        return new ArrayList<UmlElement>();
    }

    @Override
    public DeploymentElement findDeploymentElement(String classifierId) {
        return null;
    }

    @Override
    public void createArtifactReference(DeploymentElement deploymentElement) throws Exception {
    }

    @Override
    public void createClassReference(ClassifierElement umlElement) throws Exception {
    }

    @Override
    public void createComponentReference(BridgeComponent umlElement) throws Exception {
    }

    @Override
    public void createDependency(BridgeDependency bridgeDependency) throws Exception {
    }

    @Override
    public void createRealizationReference(BridgeRealization umlElement) throws Exception {
    }

    @Override
    public void checkReferences(UmlElement element) throws Exception {
    }

    private void setupEnumerationLiterals(EBMEnumeration ebmEnumeration, BridgeEnumeration enumeration) {
        for (EBMElement literal : ebmEnumeration.getOwnedLiterals()) {
            enumeration.addLiteral(literal.getName());
        }
    }

    protected BridgeStereotype getClassifierType(BridgeStereotype deploymentType) {
        BridgeStereotype classifierType = deploymentType.getClassifierType();
        if (classifierType == null) {
            classifierType = this.getHelpers().getStereotypeFactory().findClassifierType(deploymentType);
        }
        return classifierType;
    }

    @Override
    protected BridgeClass createBridgeClass(String id, Object reference, BridgeStereotype stereotype) {
        BridgeClass clazz;
        if (reference == null) {
            clazz = new BridgeClass(id.replaceAll("/", "::"), new Comment("", this.getHelpers()), stereotype, this.getHelpers());
        } else {
            EBMElement element = (EBMElement)reference;
            if (element instanceof EBMSignal) {
                clazz = new BridgeSignal(element.getName(), null, stereotype, this.getHelpers());
            } else if (element instanceof EBMEnumeration) {
                clazz = new BridgeEnumeration(element.getName(), null, stereotype, this.getHelpers());
                this.setupEnumerationLiterals((EBMEnumeration)element, (BridgeEnumeration)clazz);
            } else {
                clazz = new BridgeClass(element.getName(), null, stereotype, this.getHelpers());
            }
            clazz.setReference(element);
            clazz.setXmiID(element.getXmiId());
            ((DefaultPackagesFactory)this.getHelpers().getPackagesFactory()).setElementPackageFromPackageable(clazz, (EBMElementInterface)element);
            clazz.setModule(this.getBridgeBaseModule());
            this.registerBridgeClass(clazz);
            if (element instanceof EBMClass) {
                clazz.setBaseclass("Class");
            }
        }
        return clazz;
    }

    @Override
    public void createUsageReference(BridgeUsage usage) throws Exception {
    }

    @Override
    public void createGeneralizationReference(Generalization generalization) throws Exception {
    }

    @Override
    public void createSession(String sessionName) {
    }

    @Override
    public void closeSession() {
    }

    @Override
    public void cancelSession() {
    }

    @Override
    public boolean isSessionCreated() {
        return false;
    }

    private ArrayList<UmlElement> createTemplates(BridgeStereotype stereotype) {
        ArrayList<UmlElement> result = stereotype.getName().equals("E2EComposite") ? this.createConfigurationTemplates(stereotype) : new ArrayList();
        return result;
    }

    private ArrayList<UmlElement> createConfigurationTemplates(BridgeStereotype stereotype) {
        ArrayList<UmlElement> result = new ArrayList<UmlElement>();
        ComponentTemplate configuration = new ComponentTemplate("E2EBridge", new Comment("", this.getHelpers()), stereotype, this.getHelpers());
        result.add(configuration);
        return result;
    }

    public class FindInfo {
        public Class type;
        public String name;
        public BridgePackage bridgePackage;
    }
}

