/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.BridgeInstance;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.ChildRemovedEvent;
import ch.e2e.builder.compiler.uml.ClassifierElement;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.LeftListElement;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BridgeNodeInstance
extends DeploymentElement
implements LeftListElement {
    public BridgeNodeInstance(ClassifierElement classifier, Helpers helpers) {
        super(classifier, helpers);
    }

    public BridgeNodeInstance(String name, Comment description, ClassifierElement classifier, Helpers helpers) {
        super(name, description, classifier, helpers);
    }

    public BridgeNodeInstance(BridgeStereotype stereotype, Helpers helpers) {
        super(stereotype, helpers);
    }

    @Override
    public boolean multipleInstancesAllowed() {
        return false;
    }

    @Override
    public void addChild(UmlElement child) {
        super.addChild(child);
        BridgeInstance instance = (BridgeInstance)child;
        BridgeStereotype classifier = instance.getClassifierArtifact().getStereotype().getClassifierType();
        for (BridgeStereotype nodeType : this.getChildrensMap().keySet()) {
            if (nodeType.equals(this.getHelpers().getStereotypeFactory().getStereotype("UserArtifactTemplate")) || !nodeType.getCustomization().getChildren().contains(classifier) || this.getChildrensMap().get(nodeType).contains(child)) continue;
            this.getChildrensMap().get(nodeType).add(child);
            child.setParent(this);
            this.informChildListener(child);
        }
    }

    @Override
    public void removeChild(UmlElement child) {
        if (child != null) {
            super.removeChild(child);
            ((DeploymentElement)child).setChildListener(null);
            if (this.getChildListener() != null) {
                this.getChildListener().childRemoved(new ChildRemovedEvent(this, (DeploymentElement)child, this));
            }
        }
    }

    @Override
    protected void addClassifierDependency(Document ownerDocument, Element xmiElement, XmiIDFactory xmiIDFactory) {
        Element classifierElement = ownerDocument.createElement("classifier");
        if (this.getClassifier().getModule() == null) {
            classifierElement.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", this.getClassifier().getXmiID());
        } else {
            Module module = this.getClassifier().getModule();
            classifierElement.setAttribute("href", module.getName() + '#' + this.getClassifier().getXmiID());
            classifierElement.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:type", "uml:" + this.getClassifier().getBaseclass());
            Element xmiExtension = ownerDocument.createElementNS("http://schema.omg.org/spec/XMI/2.1", "xmi:Extension");
            classifierElement.appendChild(xmiExtension);
            xmiExtension.setAttribute("extender", module.getExtender() + ' ' + module.getExtenderVersion());
            xmiExtension.setAttribute("extenderID", module.getExtender() + ' ' + module.getExtenderVersion());
            Element referenceExtension = ownerDocument.createElement("referenceExtension");
            referenceExtension.setAttribute("referentPath", this.getClassifier().getQualifiedName());
            referenceExtension.setAttribute("referentType", this.getClassifier().getBaseclass());
            xmiExtension.appendChild(referenceExtension);
        }
        xmiElement.appendChild(classifierElement);
    }

    @Override
    public BridgeStereotype getChildBridgeStereotype(String stereotype) {
        BridgeStereotype result = null;
        int length = this.getStereotypes().size();
        for (int i = 0; i < length && result == null; ++i) {
            BridgeStereotype nodeType = this.getStereotypes().get(i);
            ArrayList<BridgeStereotype> children = nodeType.getCustomization().getChildren();
            int childCount = children.size();
            for (int childIndex = 0; childIndex < childCount && result == null; ++childIndex) {
                BridgeStereotype bridgeStereotype = children.get(childIndex);
                if (bridgeStereotype.getDeploymentType() == null || !bridgeStereotype.getDeploymentType().getName().equals(stereotype)) continue;
                result = bridgeStereotype.getDeploymentType();
            }
        }
        return result;
    }

    public ArrayList<UmlElement> getAllChildClassifer() {
        ArrayList<UmlElement> result = new ArrayList<UmlElement>();
        for (UmlElement child : this.getChildren()) {
            result.add(((BridgeInstance)child).getClassifierArtifact());
        }
        return result;
    }
}

