/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgeEnumerationLiteral;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.util.StringTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BridgeEnumeration
extends BridgeClass {
    public BridgeEnumeration(String name, Comment description, BridgeStereotype stereotype, Helpers helpers) {
        super(name, description, stereotype, helpers);
    }

    public List<BridgeEnumerationLiteral> getLiterals() {
        int length = this.getChildCount();
        ArrayList<BridgeEnumerationLiteral> literals = length == 0 ? Collections.emptyList() : new ArrayList<BridgeEnumerationLiteral>(length);
        for (UmlElement child : this.getAllChildren()) {
            if (!(child instanceof BridgeEnumerationLiteral)) continue;
            literals.add((BridgeEnumerationLiteral)child);
        }
        return literals;
    }

    public void addLiteral(String literal) {
        this.addChild(new BridgeEnumerationLiteral(literal, this.getHelpers()));
    }

    @Override
    public String getSignature() {
        String values = StringTools.join(this.getLiterals(), (String)", ");
        return super.getSignature() + (values.isEmpty() ? "" : " [" + values + "]");
    }

    @Override
    public String getBaseclass() {
        return "Enumeration";
    }
}

