/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.swagger.helpers;

import ch.e2e.builder.compiler.swagger.elements.Descriptor;
import ch.e2e.builder.compiler.swagger.elements.Required;
import ch.e2e.builder.compiler.swagger.elements.Type;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.representer.Representer;

public class SwaggerParser {
    private Descriptor descriptor;

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void parse(File file) throws FileNotFoundException {
        this.parse(new FileInputStream(file));
    }

    public void parse(URL url) throws IOException {
        this.parse(url.openConnection().getInputStream());
    }

    public void parse(InputStream stream) {
        Representer representer = new Representer();
        representer.getPropertyUtils().setSkipMissingProperties(true);
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(), representer);
        this.descriptor = (Descriptor)yaml.loadAs(stream, Descriptor.class);
    }

    public class Constructor
    extends org.yaml.snakeyaml.constructor.Constructor {
        protected Construct getConstructor(Node node) {
            Construct construct = super.getConstructor(node);
            if (node.getType().equals(Type.class)) {
                construct = new Type.TypeConstruct();
            }
            if (node.getType().equals(Required.class)) {
                construct = new Required.RequiredConstruct();
            }
            return construct;
        }
    }
}

