/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.net;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderGroup;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public abstract class HTTPAction {
    public static final String HTTP_CONTENT_TYPE = "Content-Type";
    public static final String HTTP_COOKIE = "Cookie";
    public static final String HTTP_FORM_ENCODED = "application/x-www-form-urlencoded; charset=UTF-8";
    public static final String HTTP_LOCATION = "Location";
    public static final String HTTP_SET_COOKIE = "Set-Cookie";
    public static final String X_BRIDGE = "X-Bridge";
    public static final String RETURN_XML = "return-xml";
    public static final int NO_EXPLICIT_TIMEOUT = -1;

    protected abstract String getRequestUrl();

    protected abstract Map<String, String> getParameters();

    protected abstract Map<String, String> getProperties();

    protected Response doRequest() throws IOException {
        return this.doRequest(-1);
    }

    protected Response doRequest(int timeout) throws IOException {
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(this.getRequestUrl());
        method.setFollowRedirects(this.getRedirect());
        this.setRequestHeaders(method);
        this.setRequestParameters(method, timeout);
        client.executeMethod((HttpMethod)method);
        Response response = new Response((HttpMethod)method);
        method.releaseConnection();
        return response;
    }

    private void setRequestHeaders(PostMethod method) {
        method.setRequestHeader(HTTP_CONTENT_TYPE, this.getContentType());
        this.getProperties().forEach((arg_0, arg_1) -> ((PostMethod)method).setRequestHeader(arg_0, arg_1));
    }

    private void setRequestParameters(PostMethod method, int timeout) {
        Map<String, String> parameters = this.getParameters();
        if (timeout != -1) {
            parameters.put("input_timeout", String.valueOf(timeout * 1000));
        }
        parameters.forEach((arg_0, arg_1) -> ((PostMethod)method).addParameter(arg_0, arg_1));
    }

    protected boolean getRedirect() {
        return false;
    }

    protected String getContentType() {
        return HTTP_FORM_ENCODED;
    }

    static class Response
    extends HeaderGroup {
        private final int statusCode;
        private final String statusText;
        private final String responseBody;

        private Response(HttpMethod method) throws IOException {
            Arrays.stream(method.getResponseHeaders()).forEach(arg_0 -> ((Response)this).addHeader(arg_0));
            this.statusCode = method.getStatusCode();
            this.statusText = method.getStatusText();
            this.responseBody = method.getResponseBodyAsString();
        }

        int getStatusCode() {
            return this.statusCode;
        }

        String getStatusText() {
            return this.statusText;
        }

        String getResponseBodyAsString() {
            return this.responseBody;
        }

        String getCondensedHeaderValue(String name) {
            Header header = super.getCondensedHeader(name);
            return header == null ? null : header.getValue();
        }
    }
}

