/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.error;

import ch.e2e.builder.base.error.AbstractXSLTError;
import ch.e2e.builder.base.error.ErrorHelper;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EALError
extends AbstractXSLTError {
    public static String ERROR_EAL = "error.eal";
    private Integer line;
    private Integer column;

    public EALError(String code, Map<String, String> parameter, String location, Integer line, Integer column) {
        this(code, parameter, location, "", line, column);
    }

    public EALError(String code, Map<String, String> parameter, String location, String originalLocation, Integer line, Integer column) {
        super(code, parameter, location, originalLocation);
        this.line = line;
        this.column = column;
    }

    public EALError(Element errorElement) {
        super(errorElement);
        this.line = ErrorHelper.readLine((Element)errorElement);
        this.column = ErrorHelper.readColumn((Element)errorElement);
    }

    public Integer getLine() {
        return this.line;
    }

    public Integer getColumn() {
        return this.column;
    }

    public int getType() {
        return 1014;
    }

    public String getTypeCode() {
        return ERROR_EAL;
    }

    public Map<String, String> getTypeParameter() {
        Map parameter = super.getTypeParameter();
        parameter.put("line", this.line + "");
        parameter.put("column", this.column + "");
        return parameter;
    }

    public Element toNode(Document parent) {
        Element errorElement = super.toNode(parent);
        ErrorHelper.appendLine((Element)errorElement, (Integer)this.line);
        ErrorHelper.appendColumn((Element)errorElement, (Integer)this.column);
        return errorElement;
    }
}

