/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.error;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.error.BuilderError;
import ch.e2e.builder.base.error.BuilderFatalError;
import ch.e2e.builder.base.error.BuilderWarning;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.error.ConfigurationError;
import ch.e2e.builder.compiler.error.ConfigurationFatalError;
import ch.e2e.builder.compiler.error.ConfigurationWarning;
import java.io.File;
import java.util.ArrayList;

public class ConfigurationErrorHandler
extends AbstractErrorHandler {
    boolean definitionCorrect = true;

    public ConfigurationErrorHandler(CompilableObject configuration, ArrayList<BuilderError> errors) {
        super(new File(new File(configuration.getUmlDocument().getDocumentWorkingFolder(), "errorlog"), configuration.getName() + configuration.getErrorLogExtension()));
        BuilderError error;
        int i;
        int length = errors.size();
        for (i = 0; i < length && this.definitionCorrect; ++i) {
            error = errors.get(i);
            this.definitionCorrect = !(error instanceof ConfigurationError);
        }
        length = this.getErrors().size();
        for (i = 0; i < length && this.definitionCorrect; ++i) {
            error = (BuilderError)this.getErrors().get(i);
            this.definitionCorrect = !(error instanceof ConfigurationError);
        }
        length = this.getFatalErrors().size();
        for (i = 0; i < length && this.definitionCorrect; ++i) {
            error = (BuilderError)this.getFatalErrors().get(i);
            this.definitionCorrect = !(error instanceof ConfigurationError);
        }
    }

    public void addConfigurationError(BuilderError error) {
        if (error instanceof ConfigurationFatalError) {
            this.fatalError((BuilderFatalError)error);
        } else if (error instanceof ConfigurationWarning) {
            this.warning((BuilderWarning)error);
        } else {
            this.error((AbstractBuilderError)error);
        }
    }

    public boolean isDefinitionCorrect() {
        return this.definitionCorrect;
    }

    protected BuilderError addError(AbstractBuilderError error) {
        this.definitionCorrect &= !(error instanceof ConfigurationError);
        return super.addError(error);
    }

    protected BuilderFatalError addFatalError(BuilderFatalError error) {
        this.definitionCorrect &= !(error instanceof ConfigurationError);
        return super.addFatalError(error);
    }
}

