/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.swagger;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.BuilderError;
import ch.e2e.builder.base.error.BuilderWarning;
import ch.e2e.builder.base.error.XSLTErrorHandler;
import ch.e2e.builder.compiler.document.importer.ImportModel;
import ch.e2e.builder.compiler.document.importer.ImportSource;
import ch.e2e.builder.compiler.document.importer.TestDataModel;
import ch.e2e.builder.compiler.document.importer.swagger.SwaggerDataModel;
import ch.e2e.builder.compiler.document.importer.swagger.SwaggerNotSupportedException;
import ch.e2e.builder.compiler.document.importer.swagger.error.SwaggerImport204SchemaWarning;
import ch.e2e.builder.compiler.document.importer.swagger.error.SwaggerImportAdditionalPropertiesWarning;
import ch.e2e.builder.compiler.document.importer.swagger.error.SwaggerImportBaseTypeInBodyWarning;
import ch.e2e.builder.compiler.document.importer.swagger.error.SwaggerImportMultiParamSameNameError;
import ch.e2e.builder.compiler.document.importer.swagger.error.SwaggerImportMultiTypeWarning;
import ch.e2e.builder.compiler.document.importer.swagger.error.SwaggerImportNoConsumesContentTypeSupportedWarning;
import ch.e2e.builder.compiler.document.importer.swagger.error.SwaggerImportNoProducesContentTypeSupportedWarning;
import ch.e2e.builder.compiler.document.importer.swagger.error.SwaggerImportPropertiesAlreadyDefinedWarning;
import ch.e2e.builder.compiler.document.importer.swagger.error.SwaggerImportReferenceNotFoundWarning;
import ch.e2e.builder.compiler.document.importer.swagger.error.SwaggerImportUnknowInWarning;
import ch.e2e.builder.compiler.document.importer.swagger.error.SwaggerImportUnknownTypeWarning;
import ch.e2e.builder.compiler.document.importer.swagger.error.SwaggerImportUnsupportedVersionError;
import ch.e2e.builder.compiler.swagger.elements.Descriptor;
import ch.e2e.builder.compiler.swagger.elements.OperationObject;
import ch.e2e.builder.compiler.swagger.elements.ParameterObject;
import ch.e2e.builder.compiler.swagger.elements.PathItem;
import ch.e2e.builder.compiler.swagger.elements.ResponseObject;
import ch.e2e.builder.compiler.swagger.elements.TagDefinition;
import ch.e2e.builder.compiler.swagger.elements.Type;
import ch.e2e.builder.compiler.swagger.elements.TypeDefinition;
import ch.e2e.builder.compiler.uml.Activity;
import ch.e2e.builder.compiler.uml.ActivityParameter;
import ch.e2e.builder.compiler.uml.ActivityParameterNode;
import ch.e2e.builder.compiler.uml.ArrayAccessException;
import ch.e2e.builder.compiler.uml.BridgeAttribute;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgeOperation;
import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.BridgeParameter;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.BridgeUsage;
import ch.e2e.builder.compiler.uml.CallOperationAction;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.DataModel;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Direction;
import ch.e2e.builder.compiler.uml.Generalization;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.ModelPackage;
import ch.e2e.builder.compiler.uml.Multiplicity;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SwaggerImportSource
extends ImportSource {
    public static final String SWAGGER_VERSION = "2.0";
    public static final String PACKAGE_TYPES = "Types";
    public static final String PACKAGE_CLASSES = "Classes";
    public static final String PACKAGE_TAGS = "Tags";
    public static final String RESPONSE_PARAMETER_NAME = "response";
    public static final String METHOD_GET_NAME = "GET";
    public static final String METHOD_POST_NAME = "POST";
    public static final String METHOD_PUT_NAME = "PUT";
    public static final String METHOD_DELETE_NAME = "DELETE";
    public static final String METHOD_PATCH_NAME = "PATCH";
    public static final String METHOD_HEAD_NAME = "HEAD";
    public static final String METHOD_OPTIONS_NAME = "OPTIONS";
    public static String REF_DEFINITIONS_PREFIX = "#/definitions/";
    public static String REF_PARAMETERS_PREFIX = "#/parameters/";
    public static String SWAGGER_BASE_TYPE_BOOLEAN = "boolean";
    public static String SWAGGER_BASE_TYPE_FLOAT = "float";
    public static String SWAGGER_BASE_TYPE_NUMBER = "number";
    public static String SWAGGER_BASE_TYPE_INTEGER = "integer";
    public static String SWAGGER_BASE_TYPE_STRING = "string";
    public static String SWAGGER_BASE_TYPE_ARRAY = "array";
    public static String SWAGGER_BASE_TYPE_OBJECT = "object";
    public static String SWAGGER_FORMAT_BINARY = "binary";
    public static String SWAGGER_FORMAT_BYTE = "byte";
    public static String SWAGGER_FORMAT_DATETIME = "date-time";
    public static String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    public static String CONTENT_TYPE_APPLICATION_XML = "application/xml";
    public static final List<String> consumesContentTypes = new ArrayList<String>();
    public static final List<String> producesContentTypes = new ArrayList<String>();
    public static final List<String> inPossibilities = new ArrayList<String>();
    private Helpers helpers;
    private Boolean fullOperationNames = true;
    private String name;
    private Descriptor descriptor;
    private SwaggerDataModel importDataModel;
    private BridgePackage importDataModelRoot;
    private TestDataModel testDataModel;
    private File importsFolder;
    private DeploymentElement alias;
    private DeploymentElement testAlias;
    private BridgePackage servicesPackage;
    private BridgePackage testServicesPackage;
    Map<String, BridgeDefinitionClass> definitionBridgeDefinitionClassMap = null;
    Map<String, BridgeDefinitionClass> bridgeDefinitionClassMap = new HashMap<String, BridgeDefinitionClass>();
    private Map<String, BridgeClass> bridgeClasses = new HashMap<String, BridgeClass>();
    private BridgePackage typesPackage;
    Map<String, BridgeClass> tagClasses;

    public Boolean isFullOperationNames() {
        return this.fullOperationNames;
    }

    public void setFullOperationNames(Boolean nameBasedOperationSyntax) {
        this.fullOperationNames = nameBasedOperationSyntax;
    }

    public SwaggerImportSource(String name, Descriptor descriptor, File importsFolder, Helpers helpers) throws SwaggerNotSupportedException, UnsupportedEncodingException {
        this.name = name;
        this.descriptor = descriptor;
        this.importsFolder = importsFolder;
        this.helpers = helpers;
        String version = descriptor.getSwagger();
        if (version == null || !version.equals(SWAGGER_VERSION)) {
            if (descriptor.getOpenapi() != null) {
                version = descriptor.getOpenapi();
            }
            SwaggerImportUnsupportedVersionError error = new SwaggerImportUnsupportedVersionError(version);
            XSLTErrorHandler.getInstance().error((AbstractBuilderError)error);
            throw new SwaggerNotSupportedException((BuilderError)error);
        }
        this.createModels();
    }

    public DataModel getImportDataModel() {
        return this.importDataModel;
    }

    public Document getSourceDocument() {
        for (ModelPackage modelPackage : this.importDataModel.getModel().getPackages()) {
            this.importDataModel.addSharedPackage(modelPackage.getOrigin());
        }
        return this.importDataModel.createDocument();
    }

    public DataModel getTestDataModel() {
        return this.testDataModel;
    }

    public Document getTestSourceDocument() {
        return this.testDataModel.createDocument();
    }

    @Override
    public ImportModel getImportModel() {
        return null;
    }

    @Override
    public String getDevelopmentFilename() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void createModels() throws SwaggerNotSupportedException, UnsupportedEncodingException {
        this.importDataModel = new SwaggerDataModel(this.name, this.importsFolder, this.helpers);
        this.importDataModelRoot = this.helpers.getPackagesFactory().createPackages(this.name, this.importDataModel.getModel().getOrigin(), this.helpers.getStereotypeFactory().getStereotype("Repository"));
        this.testDataModel = new TestDataModel(this.name + ".swaggerTest", this.helpers);
        this.testDataModel.addModule(this.importDataModel.getModule());
        this.helpers.getXmiIDFactory().setGlobalPrefix(this.name);
        this.createServices();
        for (BridgeClass bridgeClass : this.bridgeClasses.values()) {
            this.importDataModel.addElement(bridgeClass);
        }
    }

    private void createServices() throws SwaggerNotSupportedException, UnsupportedEncodingException {
        String title = this.descriptor.getInfo() != null && this.descriptor.getInfo().getTitle() != null ? this.descriptor.getInfo().getTitle() : "";
        String description = this.descriptor.getInfo() != null && this.descriptor.getInfo().getDescription() != null ? this.descriptor.getInfo().getDescription() : "";
        String version = this.descriptor.getInfo() != null && this.descriptor.getInfo().getVersion() != null ? this.descriptor.getInfo().getVersion() : "";
        String basePath = this.descriptor.getBasePath();
        BridgeClass baseInterface = new BridgeClass(title, new Comment(description, this.helpers), this.helpers.getStereotypeFactory().getStereotype("RESTInterface"), this.helpers);
        baseInterface.setOwningPackage(this.getServicesPackage());
        this.importDataModel.addElement(baseInterface);
        BridgePackage classPackage = this.helpers.getPackagesFactory().createPackages(PACKAGE_CLASSES, this.getTestServicesPackage(), this.helpers.getStereotypeFactory().getStereotype("Repository"));
        this.testDataModel.addElement(classPackage);
        BridgeClass errorClass = new BridgeClass("RestError", new Comment("", this.helpers), this.helpers.getStereotypeFactory().getStereotype("RESTError"), this.helpers);
        BridgeAttribute propertyAttribute = new BridgeAttribute("code", new Comment("", this.helpers), null, this.helpers);
        propertyAttribute.setTypeClass(this.helpers.getElementHelper().findBaseType("Base Types/String", null));
        errorClass.addAttribute(propertyAttribute);
        propertyAttribute = new BridgeAttribute("message", new Comment("", this.helpers), null, this.helpers);
        propertyAttribute.setTypeClass(this.helpers.getElementHelper().findBaseType("Base Types/String", null));
        errorClass.addAttribute(propertyAttribute);
        errorClass.setOwningPackage(classPackage);
        this.testDataModel.addElement(errorClass);
        BridgeClass testPortType = new BridgeClass(title, new Comment(description, this.helpers), this.helpers.getStereotypeFactory().getStereotype("E2ERESTPortType"), this.helpers);
        testPortType.setPropertyValueQuietly("apiVersion", version);
        testPortType.setPropertyValueQuietly("errorClass", errorClass);
        if (basePath != null) {
            testPortType.setPropertyValueQuietly("path", basePath);
        }
        testPortType.setOwningPackage(this.getTestServicesPackage());
        this.testDataModel.addElement(testPortType);
        Map<String, PathItem> paths = this.descriptor.getPaths();
        HashMap<String, Resource> resources = new HashMap<String, Resource>();
        if (paths != null) {
            for (Map.Entry<String, PathItem> entry : paths.entrySet()) {
                String[] names = entry.getKey().split("/");
                if (names.length <= 0) continue;
                int current = 0;
                String currentName = names[current];
                while (currentName.isEmpty() && current < names.length) {
                    currentName = names[++current];
                }
                Resource resource = (Resource)resources.get(currentName);
                if (resource == null) {
                    resource = new Resource(currentName, "", "");
                    resource.name = currentName;
                    resources.put(resource.name, resource);
                }
                while (current < names.length - 1) {
                    String nextName = names[++current];
                    while (nextName.isEmpty() && current < names.length) {
                        nextName = names[++current];
                    }
                    Resource next = resource.subResources.get(nextName);
                    if (next == null) {
                        next = new Resource(nextName, resource.fullPath, resource.restPath);
                        next.name = nextName;
                        resource.subResources.put(next.name, next);
                    }
                    resource = next;
                }
                if (entry.getKey().endsWith("/")) {
                    resource.pathItemSlash = entry.getValue();
                    continue;
                }
                resource.pathItem = entry.getValue();
            }
        }
        for (Map.Entry<String, PathItem> entry : resources.entrySet()) {
            ((Resource)((Object)entry.getValue())).createResource(baseInterface, testPortType);
        }
    }

    private DeploymentElement getAlias() {
        if (this.alias == null) {
            BridgePackage aliases = this.helpers.getPackagesFactory().createPackages("Aliases", this.importDataModelRoot, this.helpers.getStereotypeFactory().getStereotype("Repository"));
            String title = this.descriptor.getInfo() != null && this.descriptor.getInfo().getTitle() != null ? this.descriptor.getInfo().getTitle() : null;
            this.alias = new DeploymentElement(title + "AliasTemplate", new Comment("", this.helpers), this.helpers.getStereotypeFactory().getStereotype("RESTAlias"), this.helpers);
            this.alias.setStereotype(this.helpers.getStereotypeFactory().getStereotype("E2EArtifactTemplate"));
            this.alias.setModule(this.importDataModel.getModule());
            this.alias.setOwningPackage(aliases);
            this.alias.setPropertyValueQuietly("basePath", this.descriptor.getBasePath());
            if (this.descriptor.getSchemes() != null && this.descriptor.getSchemes().size() > 0) {
                this.alias.setPropertyValueQuietly("protocol", this.descriptor.getSchemes().get(0));
            }
            if (this.descriptor.getHost() != null) {
                String[] host = this.descriptor.getHost().split(":");
                this.alias.setPropertyValueQuietly("host", host[0]);
                if (host.length > 1) {
                    this.alias.setPropertyValueQuietly("port", host[1]);
                }
            }
            this.importDataModel.addElement(this.alias);
        }
        return this.alias;
    }

    public Collection<DeploymentElement> getAliases() {
        ArrayList<DeploymentElement> aliases = new ArrayList<DeploymentElement>();
        if (this.alias != null) {
            aliases.add(this.alias);
        }
        return aliases;
    }

    private DeploymentElement getTestAlias() {
        if (this.testAlias == null) {
            DeploymentElement alias = this.getAlias();
            BridgePackage testAliases = this.helpers.getPackagesFactory().createPackages("Aliases", this.testDataModel.getModel().getOrigin(), this.helpers.getStereotypeFactory().getStereotype("Repository"));
            BridgeStereotype artifactTemplate = this.helpers.getStereotypeFactory().getStereotype("E2EArtifactTemplate");
            ArrayList<BridgeStereotype> aliasTypes = alias.getStereotypes();
            String name = alias.getName().endsWith("Template") ? alias.getName().substring(0, alias.getName().length() - 8) : alias.getName();
            this.testAlias = new DeploymentElement(name, new Comment(alias.getDescription().getText(), this.helpers), this.helpers);
            for (BridgeStereotype aliasType : aliasTypes) {
                if (aliasType.equals(artifactTemplate)) continue;
                this.testAlias.addStereotype(aliasType);
                this.testAlias.addGeneral(new Generalization(alias, this.testAlias, this.helpers));
            }
            this.testAlias.setModule(this.testDataModel.getModule());
            this.testAlias.setOwningPackage(testAliases);
            this.testDataModel.addElement(this.testAlias);
            this.testDataModel.addPackage(testAliases);
        }
        return this.testAlias;
    }

    private BridgePackage getServicesPackage() {
        if (this.servicesPackage == null) {
            this.servicesPackage = this.helpers.getPackagesFactory().createPackages("Services", this.importDataModelRoot, this.helpers.getStereotypeFactory().getStereotype("Repository"));
            this.importDataModel.addElement(this.servicesPackage);
        }
        return this.servicesPackage;
    }

    private BridgePackage getTestServicesPackage() {
        if (this.testServicesPackage == null) {
            this.testServicesPackage = this.helpers.getPackagesFactory().createPackages("Test Services", this.testDataModel.getModel().getOrigin(), this.helpers.getStereotypeFactory().getStereotype("Repository"));
            this.testDataModel.addElement(this.testServicesPackage);
        }
        return this.testServicesPackage;
    }

    private Map<String, BridgeDefinitionClass> getDefinitionClasses() {
        if (this.definitionBridgeDefinitionClassMap == null) {
            TypeDefinition typeDefinition;
            this.definitionBridgeDefinitionClassMap = new HashMap<String, BridgeDefinitionClass>();
            Map<String, TypeDefinition> definitionMap = this.descriptor.getDefinitions();
            for (String definitionName : definitionMap.keySet()) {
                typeDefinition = definitionMap.get(definitionName);
                this.definitionBridgeDefinitionClassMap.put(definitionName, this.getBridgeDefinitionClass(definitionName, typeDefinition, true));
            }
            for (String className : definitionMap.keySet()) {
                typeDefinition = definitionMap.get(className);
                BridgeDefinitionClass bridgeDefinitionClass = this.definitionBridgeDefinitionClassMap.get(className);
                if (bridgeDefinitionClass == null || bridgeDefinitionClass.isArray.booleanValue()) continue;
                this.completeClass(bridgeDefinitionClass.bridgeClass, typeDefinition);
            }
        }
        return this.definitionBridgeDefinitionClassMap;
    }

    private void completeClass(BridgeClass bridgeClass, TypeDefinition typeDefinition) {
        Object definition;
        if (typeDefinition.getProperties() != null) {
            for (Map.Entry<String, TypeDefinition> property : typeDefinition.getProperties().entrySet()) {
                String propertyName = property.getKey();
                Boolean required = typeDefinition.getRequired().getRequired().indexOf(propertyName) > -1;
                if (bridgeClass.getAttribute(propertyName) != null) {
                    SwaggerImportPropertiesAlreadyDefinedWarning warning = new SwaggerImportPropertiesAlreadyDefinedWarning(bridgeClass.getName(), propertyName);
                    XSLTErrorHandler.getInstance().warning((BuilderWarning)warning);
                    continue;
                }
                TypeDefinition propertyTypeDefinition = property.getValue();
                if (propertyTypeDefinition == null) {
                    propertyTypeDefinition = new TypeDefinition();
                }
                String comment = propertyTypeDefinition.getDescription() != null ? propertyTypeDefinition.getDescription() : "";
                BridgeAttribute propertyAttribute = new BridgeAttribute(propertyName, new Comment(comment, this.helpers), null, this.helpers);
                propertyAttribute.setModule(this.importDataModel.getModule());
                BridgeDefinitionClass propertyClass = this.getBridgeDefinitionClass(bridgeClass.getName() + "_" + propertyName, propertyTypeDefinition);
                if (propertyClass != null) {
                    propertyAttribute.setTypeClass(propertyClass.bridgeClass);
                    if (propertyClass.isArray.booleanValue()) {
                        if (required.booleanValue()) {
                            propertyAttribute.setMultiplicity(Multiplicity.createMultiplicity(1));
                        } else {
                            propertyAttribute.setMultiplicity(Multiplicity.createMultiplicity(4));
                        }
                    } else if (required.booleanValue()) {
                        propertyAttribute.setMultiplicity(Multiplicity.createMultiplicity(0));
                    }
                } else {
                    propertyAttribute.setTypeClass(this.helpers.getElementHelper().findBaseType("Base Types/String", null));
                    SwaggerImportUnknownTypeWarning warning = new SwaggerImportUnknownTypeWarning(bridgeClass.getName(), propertyName);
                    XSLTErrorHandler.getInstance().warning((BuilderWarning)warning);
                    if (propertyTypeDefinition.getType() != null && propertyTypeDefinition.getType().getType() != null && propertyTypeDefinition.getType().getType().toLowerCase().equals(SWAGGER_BASE_TYPE_ARRAY)) {
                        if (required.booleanValue()) {
                            propertyAttribute.setMultiplicity(Multiplicity.createMultiplicity(1));
                        } else {
                            propertyAttribute.setMultiplicity(Multiplicity.createMultiplicity(4));
                        }
                    } else if (required.booleanValue()) {
                        propertyAttribute.setMultiplicity(Multiplicity.createMultiplicity(0));
                    }
                }
                bridgeClass.addAttribute(propertyAttribute);
                this.importDataModel.addElement(propertyAttribute);
            }
        }
        if (typeDefinition.get$ref() != null && (definition = this.getTypeDefinitionFromRef(typeDefinition.get$ref())) != null) {
            this.completeClass(bridgeClass, (TypeDefinition)definition);
        }
        if (typeDefinition.getAllOf() != null) {
            for (TypeDefinition definition2 : typeDefinition.getAllOf()) {
                this.completeClass(bridgeClass, definition2);
            }
        }
        if (typeDefinition.getAdditionalProperties() != null && !typeDefinition.getAdditionalProperties().isIgnored().booleanValue()) {
            SwaggerImportAdditionalPropertiesWarning warning = new SwaggerImportAdditionalPropertiesWarning(bridgeClass.getName());
            XSLTErrorHandler.getInstance().warning((BuilderWarning)warning);
        }
    }

    private BridgeClass getBridgeClass(String className) {
        BridgeClass bridgeClass = this.bridgeClasses.get(className);
        if (bridgeClass == null) {
            bridgeClass = new BridgeClass(className, new Comment("", this.helpers), null, this.helpers);
            bridgeClass.setOwningPackage(this.getTypesPackage());
            bridgeClass.setModule(this.importDataModel.getModule());
            this.bridgeClasses.put(className, bridgeClass);
        }
        return bridgeClass;
    }

    private BridgeDefinitionClass getBridgeDefinitionClass(String className, TypeDefinition typeDefinition) {
        return this.getBridgeDefinitionClass(className, typeDefinition, false);
    }

    private BridgeDefinitionClass getBridgeDefinitionClass(String className, TypeDefinition typeDefinition, Boolean isDefinition) {
        if (this.bridgeDefinitionClassMap.containsKey(className)) {
            return this.bridgeDefinitionClassMap.get(className);
        }
        BridgeDefinitionClass bridgeDefinitionClass = null;
        String $ref = typeDefinition.get$ref();
        String type = null;
        if (typeDefinition.getType() != null) {
            type = typeDefinition.getType().getType();
            if (typeDefinition.getType().isMulti()) {
                SwaggerImportMultiTypeWarning warning = new SwaggerImportMultiTypeWarning(className, type);
                XSLTErrorHandler.getInstance().warning((BuilderWarning)warning);
            }
        }
        String format = typeDefinition.getFormat();
        String description = typeDefinition.getDescription();
        TypeDefinition items = typeDefinition.getItems();
        if ($ref != null) {
            if ($ref.startsWith(REF_DEFINITIONS_PREFIX)) {
                String propertyClassName = $ref.substring(REF_DEFINITIONS_PREFIX.length());
                bridgeDefinitionClass = this.getDefinitionClasses().get(propertyClassName);
                if (bridgeDefinitionClass == null) {
                    bridgeDefinitionClass = new BridgeDefinitionClass(this.getBridgeClass(propertyClassName));
                }
            }
        } else {
            if (type == null && (typeDefinition.getProperties() != null || typeDefinition.getAllOf() != null)) {
                type = SWAGGER_BASE_TYPE_OBJECT;
            }
            if (type != null) {
                if (type.toLowerCase().equals(SWAGGER_BASE_TYPE_OBJECT)) {
                    bridgeDefinitionClass = new BridgeDefinitionClass(this.getBridgeClass(className));
                    if (description != null) {
                        bridgeDefinitionClass.bridgeClass.setDescription(new Comment(description, this.helpers));
                    }
                    if (!isDefinition.booleanValue()) {
                        this.completeClass(bridgeDefinitionClass.bridgeClass, typeDefinition);
                    }
                } else if (type.toLowerCase().equals(SWAGGER_BASE_TYPE_BOOLEAN)) {
                    bridgeDefinitionClass = new BridgeDefinitionClass(this.helpers.getElementHelper().findBaseType("Base Types/Boolean", null));
                } else if (type.toLowerCase().equals(SWAGGER_BASE_TYPE_FLOAT) || type.toLowerCase().equals(SWAGGER_BASE_TYPE_NUMBER)) {
                    bridgeDefinitionClass = new BridgeDefinitionClass(this.helpers.getElementHelper().findBaseType("Base Types/Float", null));
                } else if (type.toLowerCase().equals(SWAGGER_BASE_TYPE_INTEGER)) {
                    bridgeDefinitionClass = new BridgeDefinitionClass(this.helpers.getElementHelper().findBaseType("Base Types/Integer", null));
                } else if (type.toLowerCase().equals(SWAGGER_BASE_TYPE_STRING)) {
                    bridgeDefinitionClass = format != null ? (format.toLowerCase().equals(SWAGGER_FORMAT_BYTE) || format.toLowerCase().equals(SWAGGER_FORMAT_BINARY) ? new BridgeDefinitionClass(this.helpers.getElementHelper().findBaseType("Base Types/Blob", null)) : (format.toLowerCase().equals(SWAGGER_FORMAT_DATETIME) ? new BridgeDefinitionClass(this.helpers.getElementHelper().findBaseType("Base Types/DateTime", null)) : new BridgeDefinitionClass(this.helpers.getElementHelper().findBaseType("Base Types/String", null)))) : new BridgeDefinitionClass(this.helpers.getElementHelper().findBaseType("Base Types/String", null));
                } else if (type.toLowerCase().equals(SWAGGER_BASE_TYPE_ARRAY) && items != null) {
                    bridgeDefinitionClass = new BridgeDefinitionClass(this.getBridgeDefinitionClass((String)new StringBuilder().append((String)className).append((String)"_Items").toString(), (TypeDefinition)items).bridgeClass, true);
                }
            } else {
                bridgeDefinitionClass = new BridgeDefinitionClass(this.helpers.getElementHelper().findBaseType("Base Types/Any", null));
            }
        }
        if (bridgeDefinitionClass != null) {
            this.bridgeDefinitionClassMap.put(className, bridgeDefinitionClass);
        } else if (typeDefinition.getSchema() != null) {
            bridgeDefinitionClass = this.getBridgeDefinitionClass(className, typeDefinition.getSchema(), isDefinition);
        }
        return bridgeDefinitionClass;
    }

    private BridgePackage getTypesPackage() {
        if (this.typesPackage == null) {
            this.typesPackage = this.helpers.getPackagesFactory().createPackages(PACKAGE_TYPES, this.importDataModelRoot, this.helpers.getStereotypeFactory().getStereotype("Repository"));
            this.importDataModel.addElement(this.typesPackage);
        }
        return this.typesPackage;
    }

    private Map<String, BridgeClass> getTagClasses() {
        if (this.tagClasses == null) {
            this.tagClasses = new HashMap<String, BridgeClass>();
            BridgePackage tagsPackage = this.helpers.getPackagesFactory().createPackages(PACKAGE_TAGS, this.getTestServicesPackage(), this.helpers.getStereotypeFactory().getStereotype("Repository"));
            List<TagDefinition> tagDefinitions = this.descriptor.getTags();
            if (tagDefinitions != null) {
                int order = 0;
                for (TagDefinition tagDefinition : tagDefinitions) {
                    String description = tagDefinition.getDescription() != null ? tagDefinition.getDescription() : "";
                    BridgeClass tagClass = new BridgeClass(tagDefinition.getName(), new Comment(description, this.helpers), this.helpers.getStereotypeFactory().getStereotype("RESTOperationTag"), this.helpers);
                    this.tagClasses.put(tagDefinition.getName(), tagClass);
                    tagClass.setOwningPackage(tagsPackage);
                    tagClass.setModule(this.testDataModel.getModule());
                    tagClass.setPropertyValueQuietly("order", order++);
                    if (tagDefinition.getExternalDocs() != null) {
                        if (tagDefinition.getExternalDocs().getUrl() != null) {
                            tagClass.setPropertyValueQuietly("externalDocumentationURL", tagDefinition.getExternalDocs().getUrl());
                        }
                        if (tagDefinition.getExternalDocs().getDescription() != null) {
                            tagClass.setPropertyValueQuietly("externalDocumentationDescription", tagDefinition.getExternalDocs().getDescription());
                        }
                    }
                    this.testDataModel.addElement(tagClass);
                }
            }
        }
        return this.tagClasses;
    }

    private TypeDefinition getTypeDefinitionFromRef(String $ref) {
        TypeDefinition typeDefinition = null;
        if ($ref.startsWith(REF_DEFINITIONS_PREFIX)) {
            String definitionName = $ref.substring(REF_DEFINITIONS_PREFIX.length());
            typeDefinition = this.descriptor.getDefinitions().get(definitionName);
        }
        if (typeDefinition == null) {
            SwaggerImportReferenceNotFoundWarning warning = new SwaggerImportReferenceNotFoundWarning($ref);
            XSLTErrorHandler.getInstance().warning((BuilderWarning)warning);
        }
        return typeDefinition;
    }

    private ParameterObject getParameterObjectFromRef(String $ref) {
        ParameterObject parameterObject = null;
        if ($ref.startsWith(REF_PARAMETERS_PREFIX)) {
            String parameterObjectName = $ref.substring(REF_PARAMETERS_PREFIX.length());
            parameterObject = this.descriptor.getParameters().get(parameterObjectName);
        }
        if (parameterObject == null) {
            SwaggerImportReferenceNotFoundWarning warning = new SwaggerImportReferenceNotFoundWarning($ref);
            XSLTErrorHandler.getInstance().warning((BuilderWarning)warning);
        }
        return parameterObject;
    }

    @Override
    protected void readExtensions(Element importedExtension) {
        block5: {
            super.readExtensions(importedExtension);
            if (importedExtension != null) {
                try {
                    String fullOperationNames = (String)DomUtilities.evaluate((Node)importedExtension, (String)"openApi/@fullOperationNames", (QName)XPathConstants.STRING);
                    if (fullOperationNames != null && !fullOperationNames.equals("")) {
                        this.setFullOperationNames(fullOperationNames.equals("true"));
                        break block5;
                    }
                    this.setFullOperationNames(false);
                }
                catch (Exception ignore) {
                    this.setFullOperationNames(false);
                }
            } else {
                this.setFullOperationNames(false);
            }
        }
    }

    static {
        consumesContentTypes.add(CONTENT_TYPE_APPLICATION_JSON);
        consumesContentTypes.add(CONTENT_TYPE_APPLICATION_XML);
        producesContentTypes.add(CONTENT_TYPE_APPLICATION_JSON);
        producesContentTypes.add(CONTENT_TYPE_APPLICATION_XML);
        inPossibilities.add("query");
        inPossibilities.add("body");
        inPossibilities.add("path");
        inPossibilities.add("header");
    }

    class BridgeDefinitionClass {
        BridgeClass bridgeClass;
        Boolean isArray = false;

        BridgeDefinitionClass(BridgeClass bridgeClass) {
            this.bridgeClass = bridgeClass;
        }

        BridgeDefinitionClass(BridgeClass bridgeClass, Boolean isArray) {
            this(bridgeClass);
            this.isArray = isArray;
        }
    }

    private class Resource {
        private String name;
        private String resourceName;
        private String relativePath;
        public Map<String, Resource> subResources = new HashMap<String, Resource>();
        private PathItem pathItem;
        private PathItem pathItemSlash;
        private String fullPath;
        private String restPath;
        private BridgeClass noResponseBodyClass;

        public Resource(String name, String fullPath, String restPath) throws UnsupportedEncodingException {
            this.name = name;
            this.resourceName = URLDecoder.decode(name, "UTF-8");
            String normalizedName = this.resourceName.replace("{", "").replace("}", "").replaceAll("[^\\p{L}\\p{IsDigit}\\-_]", "_");
            if (!this.resourceName.equals(normalizedName)) {
                this.relativePath = this.resourceName.replace(":", "::").replaceAll("\\{([^}]+)}", ":$1");
                this.resourceName = normalizedName;
            }
            this.fullPath = this.resourceName;
            if (fullPath != null && !fullPath.isEmpty()) {
                this.fullPath = fullPath + "_" + this.resourceName;
            }
            this.restPath = restPath + "/" + name;
        }

        void createResource(UmlElement parent, UmlElement testParent) throws SwaggerNotSupportedException {
            BridgeClass resource = this.createBridgeClass();
            parent.addChild(resource);
            SwaggerImportSource.this.importDataModel.addElement(resource);
            BridgeClass testResource = this.createBridgeClass();
            testParent.addChild(testResource);
            SwaggerImportSource.this.testDataModel.addElement(testResource);
            for (Resource sub : this.subResources.values()) {
                sub.createResource(resource, testResource);
            }
            this.addOperations(this.pathItem, resource, testResource, false);
            this.addOperations(this.pathItemSlash, resource, testResource, true);
        }

        private void addOperations(PathItem pathItem, UmlElement resource, UmlElement testResource, Boolean isSlash) throws SwaggerNotSupportedException {
            if (pathItem != null) {
                if (pathItem.getDelete() != null) {
                    this.addOperation(SwaggerImportSource.METHOD_DELETE_NAME, pathItem.getDelete(), pathItem.getParameters(), resource, testResource, isSlash);
                }
                if (pathItem.getGet() != null) {
                    this.addOperation(SwaggerImportSource.METHOD_GET_NAME, pathItem.getGet(), pathItem.getParameters(), resource, testResource, isSlash);
                }
                if (pathItem.getPatch() != null) {
                    this.addOperation(SwaggerImportSource.METHOD_PATCH_NAME, pathItem.getPatch(), pathItem.getParameters(), resource, testResource, isSlash);
                }
                if (pathItem.getPost() != null) {
                    this.addOperation(SwaggerImportSource.METHOD_POST_NAME, pathItem.getPost(), pathItem.getParameters(), resource, testResource, isSlash);
                }
                if (pathItem.getPut() != null) {
                    this.addOperation(SwaggerImportSource.METHOD_PUT_NAME, pathItem.getPut(), pathItem.getParameters(), resource, testResource, isSlash);
                }
                if (pathItem.getHead() != null) {
                    this.addOperation(SwaggerImportSource.METHOD_HEAD_NAME, pathItem.getHead(), pathItem.getParameters(), resource, testResource, isSlash);
                }
                if (pathItem.getOptions() != null) {
                    this.addOperation(SwaggerImportSource.METHOD_OPTIONS_NAME, pathItem.getOptions(), pathItem.getParameters(), resource, testResource, isSlash);
                }
            }
        }

        private void addOperation(String operationName, OperationObject operationObject, List<ParameterObject> pathParameters, UmlElement resource, UmlElement testResource, Boolean isSlash) throws SwaggerNotSupportedException {
            if (isSlash.booleanValue()) {
                operationName = operationName + "/";
            }
            BridgeOperation bridgeOperation = this.createOperation(SwaggerImportSource.this.importDataModel, operationName, operationObject, pathParameters, resource, SwaggerImportSource.this.getServicesPackage());
            BridgeOperation bridgeTestOperation = this.createOperation(SwaggerImportSource.this.testDataModel, operationName, operationObject, pathParameters, testResource, SwaggerImportSource.this.getTestServicesPackage());
            if (operationObject.getTags() != null) {
                for (String tag : operationObject.getTags()) {
                    if (SwaggerImportSource.this.getTagClasses().get(tag) == null) continue;
                    String usageName = "tag";
                    BridgeUsage bridgeUsage = new BridgeUsage(usageName, bridgeTestOperation, (UmlElement)SwaggerImportSource.this.getTagClasses().get(tag), SwaggerImportSource.this.helpers);
                    bridgeUsage.setOwningPackage(SwaggerImportSource.this.getTestServicesPackage());
                    SwaggerImportSource.this.testDataModel.addElement(bridgeUsage);
                }
            }
            Activity activity = new Activity(bridgeTestOperation, SwaggerImportSource.this.helpers);
            activity.setModule(SwaggerImportSource.this.testDataModel.getModule());
            bridgeTestOperation.setMethod(activity);
            CallOperationAction action = new CallOperationAction(bridgeOperation, SwaggerImportSource.this.testDataModel.getModule(), SwaggerImportSource.this.helpers);
            action.setModule(SwaggerImportSource.this.testDataModel.getModule());
            String adapter = "RESTAdapter";
            action.setStereotype(SwaggerImportSource.this.helpers.getStereotypeFactory().getStereotype(adapter));
            action.setPropertyValueQuietly("alias", SwaggerImportSource.this.getTestAlias());
            activity.appendNode(action);
            SwaggerImportSource.this.testDataModel.addElement(action);
            for (UmlElement child : bridgeOperation.getParameters()) {
                BridgeParameter parameter = (BridgeParameter)child;
                ActivityParameter activityParameter = new ActivityParameter(parameter, SwaggerImportSource.this.helpers);
                activityParameter.setModule(SwaggerImportSource.this.testDataModel.getModule());
                SwaggerImportSource.this.testDataModel.addElement(activityParameter);
                activity.addChild(activityParameter);
                ActivityParameterNode parameterNode = new ActivityParameterNode(activityParameter, SwaggerImportSource.this.helpers);
                parameterNode.setModule(SwaggerImportSource.this.testDataModel.getModule());
                SwaggerImportSource.this.testDataModel.addElement(parameterNode);
                activity.addChild(parameterNode);
                activity.addParameter(parameterNode, action, parameter.getDirection());
            }
            testResource.addChild(activity);
        }

        private BridgeClass createBridgeClass() {
            BridgeClass resource = new BridgeClass(this.resourceName, new Comment("", SwaggerImportSource.this.helpers), SwaggerImportSource.this.helpers.getStereotypeFactory().getStereotype("RESTResource"), SwaggerImportSource.this.helpers);
            if (this.relativePath != null) {
                resource.setPropertyValueQuietly("relativePath", this.relativePath);
            }
            return resource;
        }

        private String getDefaultCode(String methodName) {
            if (methodName.equals(SwaggerImportSource.METHOD_POST_NAME)) {
                return "201";
            }
            return "200";
        }

        private BridgeClass getNoResponseBodyClass() {
            if (this.noResponseBodyClass == null) {
                this.noResponseBodyClass = SwaggerImportSource.this.helpers.getElementHelper().findType("Base Components/Add Ons/REST/NoResponseBody");
            }
            return this.noResponseBodyClass;
        }

        private List<String> getInPossibilities() {
            return inPossibilities;
        }

        private Boolean isContentTypeSupported(List<String> types, List<String> supportedTypes) {
            for (String type : types) {
                if (type.indexOf(";") > 0) {
                    type = type.substring(0, type.indexOf(";"));
                }
                if (!supportedTypes.contains(type.toLowerCase())) continue;
                return true;
            }
            return false;
        }

        private void checkParameterNameExists(String operationPath, Map<String, ParameterObject> parameterObjectMap, ParameterObject parameterObject) throws SwaggerNotSupportedException {
            ParameterObject existing = parameterObjectMap.get(parameterObject.getName());
            if (existing != null && existing.getIn() != null && !existing.getIn().equals(parameterObject.getIn())) {
                SwaggerImportMultiParamSameNameError error = new SwaggerImportMultiParamSameNameError(operationPath, parameterObject.getName());
                XSLTErrorHandler.getInstance().error((AbstractBuilderError)error);
                throw new SwaggerNotSupportedException((BuilderError)error);
            }
        }

        /*
         * WARNING - void declaration
         */
        BridgeOperation createOperation(DataModel dataModel, String operationName, OperationObject operationObject, List<ParameterObject> pathParameters, UmlElement parent, BridgePackage servicesPackage) throws SwaggerNotSupportedException {
            String comment = "";
            if (operationObject.getDescription() != null && !operationObject.getDescription().isEmpty()) {
                comment = operationObject.getDescription();
            } else if (operationObject.getSummary() != null && !operationObject.getSummary().isEmpty()) {
                comment = operationObject.getSummary();
            }
            BridgeOperation bridgeOperation = new BridgeOperation(operationName, new Comment(comment, SwaggerImportSource.this.helpers), SwaggerImportSource.this.helpers);
            parent.addOperation(bridgeOperation);
            bridgeOperation.setStereotype(SwaggerImportSource.this.helpers.getStereotypeFactory().getStereotype("REST"));
            bridgeOperation.setStatic(true);
            bridgeOperation.setModule(dataModel.getModule());
            String fullname = this.fullPath + "_" + operationName;
            String operationPath = this.restPath + " " + operationName;
            LinkedHashMap<String, BridgeParameter> parameters = new LinkedHashMap<String, BridgeParameter>();
            Boolean consumesSupported = true;
            if (operationObject.getConsumes() != null && !this.isContentTypeSupported(operationObject.getConsumes(), consumesContentTypes).booleanValue()) {
                SwaggerImportNoConsumesContentTypeSupportedWarning warning = new SwaggerImportNoConsumesContentTypeSupportedWarning(operationPath);
                XSLTErrorHandler.getInstance().warning((BuilderWarning)warning);
                consumesSupported = false;
            }
            ArrayList<ParameterObject> parameterObjectList = new ArrayList<ParameterObject>();
            HashMap<String, ParameterObject> parameterObjectMap = new HashMap<String, ParameterObject>();
            if (pathParameters != null) {
                for (ParameterObject parameterObject : pathParameters) {
                    this.checkParameterNameExists(operationPath, parameterObjectMap, parameterObject);
                    parameterObjectMap.put(parameterObject.getName(), parameterObject);
                    parameterObjectList.add(parameterObject);
                }
            }
            if (operationObject.getParameters() != null) {
                for (ParameterObject parameterObject : operationObject.getParameters()) {
                    this.checkParameterNameExists(operationPath, parameterObjectMap, parameterObject);
                    parameterObjectMap.put(parameterObject.getName(), parameterObject);
                    parameterObjectList.add(parameterObject);
                }
            }
            for (ParameterObject parameterObject : parameterObjectList) {
                void var16_22;
                ParameterObject refParameterObject;
                String $ref = parameterObject.get$ref();
                if ($ref != null && (refParameterObject = SwaggerImportSource.this.getParameterObjectFromRef($ref)) != null) {
                    ParameterObject parameterObject2 = refParameterObject;
                }
                if (!this.getInPossibilities().contains(var16_22.getIn())) {
                    SwaggerImportUnknowInWarning warning = new SwaggerImportUnknowInWarning(operationPath, var16_22.getName());
                    XSLTErrorHandler.getInstance().warning((BuilderWarning)warning);
                    continue;
                }
                if (var16_22.getIn().equals("body") && !consumesSupported.booleanValue()) continue;
                TypeDefinition typeDefinition = var16_22.getSchema() != null ? var16_22.getSchema() : var16_22;
                BridgeDefinitionClass parameterBridgeDefinitionClass = SwaggerImportSource.this.getBridgeDefinitionClass(fullname + "_" + var16_22.getName(), typeDefinition);
                String string = var16_22.getIn();
                Type type = typeDefinition.getType();
                if (string.equals("body") && typeDefinition.get$ref() == null && type != null && !type.getType().equals(SWAGGER_BASE_TYPE_OBJECT) && !type.getType().equals(SWAGGER_BASE_TYPE_ARRAY)) {
                    SwaggerImportBaseTypeInBodyWarning warning = new SwaggerImportBaseTypeInBodyWarning(operationPath);
                    XSLTErrorHandler.getInstance().warning((BuilderWarning)warning);
                    continue;
                }
                BridgeParameter bridgeParameter = new BridgeParameter(var16_22.getName(), parameterBridgeDefinitionClass.bridgeClass, Direction.IN, SwaggerImportSource.this.helpers);
                bridgeParameter.setModule(dataModel.getModule());
                if (var16_22.getRequired() != null && var16_22.getRequired().isRequired().booleanValue()) {
                    bridgeParameter.setMultiplicity(Multiplicity.createMultiplicity(0));
                } else {
                    bridgeParameter.setMultiplicity(Multiplicity.createMultiplicity(3));
                }
                bridgeParameter.addStereotype(SwaggerImportSource.this.helpers.getStereotypeFactory().getStereotype("RESTParameter"));
                bridgeParameter.setPropertyValueQuietly("in", var16_22.getIn());
                if (parameterBridgeDefinitionClass.isArray.booleanValue()) {
                    bridgeParameter.addStereotype(SwaggerImportSource.this.helpers.getStereotypeFactory().getStereotype("E2EArray"));
                    bridgeParameter.setPropertyValueQuietly("arrayElement", parameterBridgeDefinitionClass.bridgeClass);
                    bridgeParameter.setTypeClass(SwaggerImportSource.this.helpers.getElementHelper().findBaseType("Base Types/Array", null));
                }
                parameters.put(var16_22.getName(), bridgeParameter);
            }
            if (operationObject.getResponses() != null) {
                for (Map.Entry entry : operationObject.getResponses().entrySet()) {
                    void var20_40;
                    Object warning;
                    ResponseObject responseObject = (ResponseObject)entry.getValue();
                    if (responseObject.getSchema() == null) continue;
                    Type type = responseObject.getSchema().getType();
                    if (((String)entry.getKey()).equals("204")) {
                        warning = new SwaggerImport204SchemaWarning(operationPath);
                        XSLTErrorHandler.getInstance().warning((BuilderWarning)warning);
                        BridgeUsage bridgeUsage = new BridgeUsage("204", bridgeOperation, this.getNoResponseBodyClass(), SwaggerImportSource.this.helpers);
                        bridgeUsage.setStereotype(SwaggerImportSource.this.helpers.getStereotypeFactory().getStereotype("RESTResponseDefinition"));
                        bridgeUsage.setDescription(new Comment(responseObject.getDescription(), SwaggerImportSource.this.helpers));
                        bridgeUsage.setOwningPackage(servicesPackage);
                        dataModel.addElement(bridgeUsage);
                        continue;
                    }
                    if (((String)entry.getKey()).equals(this.getDefaultCode(operationName))) {
                        String responseParameterName;
                        if (!(responseObject.getSchema().get$ref() != null || type == null || type.getType().equals(SWAGGER_BASE_TYPE_OBJECT) || type.getType().equals(SWAGGER_BASE_TYPE_ARRAY) || type.getType().equals(SWAGGER_BASE_TYPE_STRING) && responseObject.getSchema().getFormat() != null && responseObject.getSchema().getFormat().equals(SWAGGER_FORMAT_BINARY))) {
                            warning = new SwaggerImportBaseTypeInBodyWarning(operationPath);
                            XSLTErrorHandler.getInstance().warning((BuilderWarning)warning);
                            continue;
                        }
                        if (!(type != null && type.getType().equals(SWAGGER_BASE_TYPE_STRING) && responseObject.getSchema().getFormat() != null && responseObject.getSchema().getFormat().equals(SWAGGER_FORMAT_BINARY) || operationObject.getProduces() == null || this.isContentTypeSupported(operationObject.getProduces(), producesContentTypes).booleanValue())) {
                            warning = new SwaggerImportNoProducesContentTypeSupportedWarning(operationPath);
                            XSLTErrorHandler.getInstance().warning((BuilderWarning)warning);
                            continue;
                        }
                        if (responseObject.getHeaders() != null) {
                            for (Map.Entry entry2 : responseObject.getHeaders().entrySet()) {
                                String name = (String)entry2.getKey();
                                BridgeParameter existingParameter = (BridgeParameter)parameters.get(name);
                                BridgeDefinitionClass definitionClass = SwaggerImportSource.this.getBridgeDefinitionClass(fullname + "_" + name, (TypeDefinition)entry2.getValue());
                                BridgeParameter newParameter = new BridgeParameter(name, definitionClass.bridgeClass, Direction.OUT, SwaggerImportSource.this.helpers);
                                newParameter.setModule(dataModel.getModule());
                                newParameter.setMultiplicity(Multiplicity.createMultiplicity(3));
                                if (definitionClass.isArray.booleanValue()) {
                                    newParameter.addStereotype(SwaggerImportSource.this.helpers.getStereotypeFactory().getStereotype("E2EArray"));
                                    newParameter.setPropertyValueQuietly("arrayElement", definitionClass.bridgeClass);
                                    newParameter.setTypeClass(SwaggerImportSource.this.helpers.getElementHelper().findBaseType("Base Types/Array", null));
                                }
                                BridgeParameter parameter = null;
                                if (existingParameter != null && existingParameter.isInputParameter()) {
                                    BridgeStereotype restParamStereotype = null;
                                    for (BridgeStereotype stereotype : existingParameter.getStereotypes()) {
                                        if (!"RESTParameter".equals(stereotype.getName())) continue;
                                        restParamStereotype = stereotype;
                                        break;
                                    }
                                    if (restParamStereotype != null && "header".equals(existingParameter.getPropertyValueQuietly("in"))) {
                                        boolean isSameType;
                                        boolean bl = isSameType = existingParameter.isArray() == newParameter.isArray();
                                        if (existingParameter.isArray() && isSameType) {
                                            try {
                                                isSameType = existingParameter.getArrayElementType().getName().equals(newParameter.getArrayElementType().getName());
                                            }
                                            catch (ArrayAccessException stereotype) {}
                                        } else if (isSameType) {
                                            isSameType = existingParameter.getTypeClass().getName().equals(newParameter.getTypeClass().getName());
                                        }
                                        if (isSameType) {
                                            parameter = existingParameter;
                                            parameter.setDirection(Direction.INOUT);
                                        }
                                    }
                                }
                                if (parameter != null) continue;
                                parameter = newParameter;
                                parameter.addStereotype(SwaggerImportSource.this.helpers.getStereotypeFactory().getStereotype("RESTParameter"));
                                parameter.setPropertyValueQuietly("in", "header");
                                if (parameters.containsKey(name)) {
                                    String externalName = name;
                                    int counter = 1;
                                    String tmp = name + counter++;
                                    while (parameters.containsKey(tmp)) {
                                        tmp = name + counter++;
                                    }
                                    name = tmp;
                                    parameter.setPropertyValueQuietly("externalName", externalName);
                                }
                                parameters.put(name, parameter);
                            }
                        }
                        if (parameters.containsKey(responseParameterName = SwaggerImportSource.RESPONSE_PARAMETER_NAME)) {
                            void var20_36;
                            boolean bl = true;
                            while (parameters.containsKey(responseParameterName = SwaggerImportSource.RESPONSE_PARAMETER_NAME + (int)(++var20_36))) {
                            }
                        }
                        BridgeDefinitionClass bridgeDefinitionClass = SwaggerImportSource.this.getBridgeDefinitionClass(fullname + "_" + responseParameterName, responseObject.getSchema());
                        BridgeParameter bridgeParameter = new BridgeParameter(responseParameterName, bridgeDefinitionClass.bridgeClass, Direction.OUT, new Comment(responseObject.getDescription(), SwaggerImportSource.this.helpers), SwaggerImportSource.this.helpers);
                        bridgeParameter.setModule(dataModel.getModule());
                        if (bridgeDefinitionClass.isArray.booleanValue()) {
                            bridgeParameter.addStereotype(SwaggerImportSource.this.helpers.getStereotypeFactory().getStereotype("E2EArray"));
                            bridgeParameter.setPropertyValueQuietly("arrayElement", bridgeDefinitionClass.bridgeClass);
                            bridgeParameter.setTypeClass(SwaggerImportSource.this.helpers.getElementHelper().findBaseType("Base Types/Array", null));
                        }
                        parameters.put(responseParameterName, bridgeParameter);
                        continue;
                    }
                    String usageName = (String)entry.getKey();
                    String string = SwaggerImportSource.RESPONSE_PARAMETER_NAME + usageName;
                    if (((String)entry.getKey()).equals("default")) {
                        usageName = "???";
                        String string2 = "responseDefault";
                    }
                    BridgeDefinitionClass parameterBridgeDefinitionClass = SwaggerImportSource.this.getBridgeDefinitionClass(fullname + "_" + (String)var20_40, responseObject.getSchema());
                    if (usageName.equals("???") || Integer.parseInt(usageName) < 400) {
                        parameterBridgeDefinitionClass.bridgeClass.addStereotype(SwaggerImportSource.this.helpers.getStereotypeFactory().getStereotype("RESTResponse"));
                    }
                    if (usageName.equals("???") || Integer.parseInt(usageName) >= 400) {
                        parameterBridgeDefinitionClass.bridgeClass.addStereotype(SwaggerImportSource.this.helpers.getStereotypeFactory().getStereotype("RESTError"));
                    }
                    BridgeUsage bridgeUsage = new BridgeUsage(usageName, bridgeOperation, parameterBridgeDefinitionClass.bridgeClass, SwaggerImportSource.this.helpers);
                    bridgeUsage.setStereotype(SwaggerImportSource.this.helpers.getStereotypeFactory().getStereotype("RESTResponseDefinition"));
                    bridgeUsage.setDescription(new Comment(responseObject.getDescription(), SwaggerImportSource.this.helpers));
                    bridgeUsage.setOwningPackage(servicesPackage);
                    dataModel.addElement(bridgeUsage);
                }
            }
            for (BridgeParameter bridgeParameter : parameters.values()) {
                bridgeOperation.addParameter(bridgeParameter);
                dataModel.addElement(bridgeParameter);
            }
            dataModel.addElement(bridgeOperation);
            return bridgeOperation;
        }
    }
}

