/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.resource;

import ch.e2e.builder.compiler.document.importer.resource.ArchivedFile;
import ch.e2e.builder.compiler.document.importer.resource.Resource;
import ch.e2e.builder.compiler.document.importer.resource.ResourceContainer;
import ch.e2e.builder.compiler.document.importer.resource.ResourceFile;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.Helpers;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ResourceArchive
extends Resource {
    private ResourceContainer resourceContainer;
    private ArrayList<ResourceFile> resources = new ArrayList();

    public ResourceArchive(File archiveFile, BridgeStereotype resourceType, Helpers helpers) throws IOException {
        super(archiveFile, resourceType, helpers);
        this.fillAllResources(archiveFile);
    }

    public ResourceContainer getResourceContainer() {
        return this.resourceContainer;
    }

    public void addAllResources(ArrayList<ResourceFile> resources) {
        this.resources.addAll(resources);
    }

    public void addResource(ResourceFile resource) {
        this.resources.add(resource);
    }

    public ArrayList<ResourceFile> getResources() {
        return this.resources;
    }

    @Override
    public boolean canExtract() {
        return this.hasProperty("extractAll");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillAllResources(File archiveFile) throws IOException {
        this.resourceContainer = new ResourceContainer(archiveFile.getAbsolutePath(), archiveFile);
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archiveFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            HashMap<String, ResourceContainer> containers = new HashMap<String, ResourceContainer>();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    this.findContainer(new File(entry.getName()), archiveFile, containers);
                    continue;
                }
                File file = new File(entry.getName());
                if (file.getParentFile() == null) {
                    this.resourceContainer.addChild(new ArchivedFile(entry.getName()));
                    continue;
                }
                ResourceContainer folder = this.findContainer(file.getParentFile(), archiveFile, containers);
                folder.addChild(new ArchivedFile(entry.getName()));
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private ResourceContainer findContainer(File containerFile, File parent, HashMap<String, ResourceContainer> containers) {
        ResourceContainer container = containers.get(containerFile.getAbsolutePath());
        if (container == null) {
            container = new ResourceContainer(containerFile.getName(), parent);
            if (containerFile.getParent() == null) {
                this.resourceContainer.addChild(container);
            } else {
                ResourceContainer parentContainer = this.findContainer(containerFile.getParentFile(), parent, containers);
                parentContainer.addChild(container);
            }
            containers.put(containerFile.getAbsolutePath(), container);
        }
        return container;
    }
}

