/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.java.asm;

import java.io.InputStream;
import org.objectweb.asm.Type;

public class JavaType {
    private Type type;
    private String bridgeType;
    private Class<?> javaType;

    public JavaType(Type type) {
        this.type = type;
        try {
            this.javaType = Class.forName(type.getClassName());
        }
        catch (ClassNotFoundException e) {
            this.javaType = null;
        }
        this.bridgeType = this.findBridgeType();
    }

    public String getJavaType() {
        return this.javaType.getName();
    }

    private String findBridgeType() {
        String bridgeType = null;
        if (this.javaType == null || InputStream.class.isAssignableFrom(this.javaType) || byte[].class.isAssignableFrom(this.javaType) || Byte[].class.isAssignableFrom(this.javaType)) {
            // empty if block
        }
        return bridgeType;
    }
}

