/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.java;

import ch.e2e.builder.compiler.document.importer.java.ClassLoaderJarfile;
import ch.e2e.builder.compiler.document.importer.java.JarfileFinder;
import ch.e2e.builder.compiler.document.importer.java.JavaCallback;
import ch.e2e.builder.compiler.document.importer.java.JavaClass;
import ch.e2e.builder.compiler.document.importer.java.JavaService;
import ch.e2e.builder.compiler.document.importer.java.Logging;
import ch.e2e.builder.compiler.document.importer.java.Parameter;
import ch.e2e.builder.compiler.document.importer.java.TypeInfo;
import ch.e2e.builder.compiler.document.importer.java.UserAbortedClassSearchException;
import ch.e2e.builder.compiler.document.importer.java.asm.DependencyVisitor;
import ch.e2e.builder.compiler.uml.BridgeOperation;
import ch.e2e.builder.compiler.uml.Generalization;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.builder.jdp.JavaDocParser;
import ch.e2e.builder.jdp.ast.MethodDeclaration;
import ch.e2e.builder.jdp.ast.Xlib;
import ch.e2e.builder.jdp.ast.XlibClass;
import ch.e2e.io.FileUtilities;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ImportClassLoader
extends ClassLoader {
    private static final ArrayList<JarFile> systemJarfiles = new ArrayList();
    private static ClassLoaderJarfile addOnJar;
    private static ClassLoaderJarfile e2etoolsJar;
    private static ClassLoaderJarfile j2eeJarfile;
    private final Map<String, ImportedClass> classes;
    private final Map<String, JavaClass> javaClasses;
    private final List<ClassLoaderJarfile> jarfiles;
    private final List<String> ignoredClasses;
    private UserAbortedClassSearchException abortException;
    private final JarfileFinder jarfileFinder;
    private final List<String> searchStack = new ArrayList<String>();
    private final Helpers helpers;

    public Helpers getHelpers() {
        return this.helpers;
    }

    public ImportClassLoader(JarfileFinder jarfileFinder, Helpers helpers) {
        this.jarfileFinder = jarfileFinder;
        this.helpers = helpers;
        this.classes = new HashMap<String, ImportedClass>();
        this.javaClasses = new HashMap<String, JavaClass>();
        this.jarfiles = new ArrayList<ClassLoaderJarfile>();
        this.ignoredClasses = new ArrayList<String>();
    }

    public ImportClassLoader(Helpers helpers) {
        this(null, helpers);
    }

    public void closeFiles() {
        for (ClassLoaderJarfile jarfile : this.jarfiles) {
            try {
                jarfile.close();
            }
            catch (IOException ex) {
                Logging.logger.fine(ex.getMessage());
            }
        }
    }

    public void removeJarfile(ClassLoaderJarfile jarfile) {
        String[] classnames;
        this.jarfiles.remove(jarfile);
        for (String classname : classnames = jarfile.getClassnames()) {
            this.javaClasses.remove(classname);
        }
    }

    public void addJarfile(ClassLoaderJarfile jarfile) {
        if (!this.jarfiles.contains(jarfile)) {
            this.jarfiles.add(jarfile);
        }
    }

    public UserAbortedClassSearchException getAbortException() {
        return this.abortException;
    }

    public List<ClassLoaderJarfile> getJarfiles() {
        for (JavaClass javaClass : this.javaClasses.values()) {
            String classname = javaClass.getFullName();
            ImportedClass clazz = this.classes.get(classname);
            if (clazz.jarfile == null || this.jarfiles.contains(clazz.jarfile)) continue;
            this.addJarfile(clazz.jarfile);
        }
        return this.jarfiles;
    }

    public JavaClass loadJavaClass(String classname) throws ClassNotFoundException {
        return this.loadAndInitializeJavaClass(classname, true, true);
    }

    public JavaClass loadAndInitializeJavaClass(String className, boolean recursive, boolean loadSystemClass) throws ClassNotFoundException {
        this.abortException = null;
        JavaClass result = this.javaClasses.get(className);
        if (result == null) {
            result = this.loadJavaClass(className, loadSystemClass);
            this.initializeJavaClass(result, className, recursive, loadSystemClass);
        }
        return result;
    }

    public JavaClass loadJavaClass(String className, boolean loadSystemClass) throws ClassNotFoundException {
        Class<?> clazz;
        JavaClass result = this.javaClasses.get(className);
        if (result == null && (loadSystemClass || !this.isSystemClass(className)) && (clazz = this.loadClass(className)) != null) {
            result = TypeInfo.isJavaCallback(clazz) ? new JavaCallback((Class)clazz, this.helpers) : (TypeInfo.isJavaService(clazz) ? new JavaService(clazz, this.helpers) : new JavaClass(clazz, this.helpers));
            this.javaClasses.put(className, result);
        }
        return result;
    }

    public void initializeJavaClass(JavaClass result, String className, boolean recursive, boolean loadSystemClass) throws ClassNotFoundException {
        if (result != null) {
            Class<?> clazz;
            Class<?> superClazz;
            result.initialize(this);
            byte[] bytes = this.getBytes(className);
            if (recursive) {
                try {
                    this.loadUsedClasses(bytes, result);
                }
                catch (ClassNotFoundException e) {
                    throw e;
                }
                catch (Exception e) {
                    Logging.logger.finer("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                }
            }
            if ((superClazz = (clazz = this.loadClass(className)).getSuperclass()) != null && !this.isSystemClass(superClazz.getName())) {
                JavaClass generalization = this.javaClasses.get(superClazz.getName());
                if (generalization == null) {
                    generalization = this.loadJavaClass(superClazz.getName(), loadSystemClass);
                    this.initializeJavaClass(generalization, superClazz.getName(), recursive, loadSystemClass);
                }
                Generalization general = new Generalization(generalization, result, this.helpers);
                result.addGeneral(general);
            }
        }
    }

    public Collection<JavaClass> getJavaClasses() {
        return this.javaClasses.values();
    }

    public List<String> getIgnoredClasses() {
        return this.ignoredClasses;
    }

    public String[] getStandardJavaClasses() throws IOException {
        ArrayList<String> classnames = new ArrayList<String>();
        ZipFile runtimeJar = null;
        int length = systemJarfiles.size();
        for (int i = 0; i < length && runtimeJar == null; ++i) {
            JarFile jarFile = systemJarfiles.get(i);
            if (!jarFile.getName().endsWith("rt.jar")) continue;
            runtimeJar = jarFile;
        }
        if (runtimeJar != null) {
            ClassLoaderJarfile jarFile = ClassLoaderJarfile.getJarfile(new File(runtimeJar.getName()));
            for (String clazz : jarFile.getClassnames()) {
                if (!clazz.startsWith("java.") && !clazz.startsWith("javax.")) continue;
                classnames.add(clazz);
            }
        }
        String[] result = new String[classnames.size()];
        classnames.toArray(result);
        return result;
    }

    public String getDescription(String classname) {
        ImportedClass importedClass = this.classes.get(classname);
        return importedClass == null ? null : importedClass.getDescription();
    }

    public ch.e2e.builder.jdp.ast.Parameter getProperty(String classname, String propertyName) {
        return this.getProperties(classname).stream().filter(p -> p.getName().equals(propertyName)).findFirst().orElse(null);
    }

    public List<ch.e2e.builder.jdp.ast.Parameter> getProperties(String classname) {
        ImportedClass importedClass = this.classes.get(classname);
        return importedClass == null ? Collections.emptyList() : importedClass.getProperties();
    }

    public List<MethodDeclaration> getMethodDeclarations(String classname) {
        ImportedClass importedClass = this.classes.get(classname);
        return importedClass == null ? Collections.emptyList() : importedClass.getMethodDeclarations();
    }

    private boolean isSystemClass(String classname) {
        int length = systemJarfiles.size();
        ZipEntry entry = null;
        for (int i = 0; i < length && entry == null; ++i) {
            JarFile systemJarfile = systemJarfiles.get(i);
            String classfileName = classname.replace('.', '/') + ".class";
            entry = systemJarfile.getEntry(classfileName);
        }
        return entry != null;
    }

    private void loadUsedClasses(byte[] bytes, JavaClass clazz) throws ClassNotFoundException {
        if (bytes != null) {
            ClassReader cr = new ClassReader(bytes);
            DependencyVisitor v = new DependencyVisitor();
            cr.accept((ClassVisitor)v, 0);
            for (String classname : v.getClasses()) {
                this.loadAndInitializeJavaClass(classname, false, false);
            }
            for (BridgeOperation operation : clazz.getOperations()) {
                ArrayList<UmlElement> params = operation.getParameters();
                for (UmlElement parameter : params) {
                    this.loadType((Parameter)parameter);
                }
            }
        }
    }

    private void loadType(Parameter parameter) throws ClassNotFoundException {
        String classname;
        if (!parameter.isPrimitive() && (classname = parameter.getNativeType()) != null) {
            if (parameter.getJavaClass().isArray()) {
                classname = classname.substring(0, classname.length() - 2);
            }
            this.loadAndInitializeJavaClass(classname, false, false);
        }
    }

    private byte[] getBytes(String classname) {
        byte[] result = null;
        ImportedClass importedClass = this.classes.get(classname);
        if (importedClass != null) {
            result = importedClass.bytes;
        }
        return result;
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.findClass(className);
    }

    @Override
    protected Class<?> findClass(String classname) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (!this.ignoredClasses.contains(classname)) {
            ImportedClass classAndBytes = this.classes.get(classname);
            if (classAndBytes == null) {
                this.searchStack.add(classname);
                try {
                    InputStream in = addOnJar.getClassInputStream(classname);
                    if (in == null && (in = e2etoolsJar.getClassInputStream(classname)) == null) {
                        in = j2eeJarfile.getClassInputStream(classname);
                    }
                    ClassLoaderJarfile jarfile = null;
                    int length = this.jarfiles.size();
                    for (int i = 0; i < length && in == null; ++i) {
                        jarfile = this.jarfiles.get(i);
                        in = jarfile.getClassInputStream(classname);
                    }
                    if (in != null) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        FileUtilities.copy((InputStream)in, (OutputStream)out);
                        byte[] bytes = out.toByteArray();
                        clazz = this.loadClass(bytes);
                        if (clazz != null) {
                            this.classes.put(classname, new ImportedClass(clazz, bytes, jarfile));
                        }
                    }
                    if (clazz == null) {
                        length = systemJarfiles.size();
                        ZipEntry entry = null;
                        for (int i = 0; i < length && entry == null; ++i) {
                            JarFile systemJarfile = systemJarfiles.get(i);
                            String classfileName = classname.replace('.', '/') + ".class";
                            entry = systemJarfile.getEntry(classfileName);
                        }
                        if (entry != null) {
                            clazz = ClassLoader.getSystemClassLoader().loadClass(classname);
                            this.classes.put(classname, new ImportedClass(clazz, null, null));
                        }
                    }
                    if (clazz == null && !this.ignoredClasses.contains(classname)) {
                        clazz = this.findAdditionalJarfile(classname);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.searchStack.remove(classname);
            } else {
                clazz = classAndBytes.clazz;
            }
        }
        return clazz;
    }

    private Class<?> findAdditionalJarfile(String classname) throws IOException {
        if (this.jarfileFinder == null) {
            this.ignoredClasses.add(classname);
        } else {
            this.ignoredClasses.add(classname);
            for (String s : this.searchStack) {
                if (this.ignoredClasses.contains(s)) continue;
                this.ignoredClasses.add(classname);
            }
            this.searchStack.clear();
        }
        return null;
    }

    private Class<?> loadClass(byte[] classBytes) throws UserAbortedClassSearchException {
        Class<?> newClass = null;
        try {
            newClass = this.defineClass(null, classBytes, 0, classBytes.length);
            this.resolveClass(newClass);
        }
        catch (NoClassDefFoundError e) {
            if (this.abortException != null) {
                throw this.abortException;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return newClass;
    }

    static {
        String bootClasspath = System.getProperty("sun.boot.class.path");
        if (bootClasspath != null && !bootClasspath.isEmpty()) {
            String[] jars;
            String home = System.getProperty("java.home").toLowerCase();
            for (String jar : jars = bootClasspath.split(File.pathSeparator)) {
                if (!jar.toLowerCase().startsWith(home)) continue;
                try {
                    systemJarfiles.add(new JarFile(jar));
                }
                catch (IOException e) {
                    Logging.logger.warning(jar + " of sun.boot.class.path not found.");
                }
            }
        }
        File libraryPath = new File(System.getProperty("ch.e2e.builder.system.library.path"));
        File addOn = new File(libraryPath, "addon.jar");
        try {
            addOnJar = ClassLoaderJarfile.getJarfile(addOn);
        }
        catch (Exception e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage() + ", when loading " + addOn.getAbsolutePath());
        }
        File e2etools = new File(libraryPath, "e2etools.jar");
        try {
            e2etoolsJar = ClassLoaderJarfile.getJarfile(e2etools);
        }
        catch (Exception e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage() + ", when loading " + e2etools.getAbsolutePath());
        }
        File j2ee = new File(libraryPath, "../contrib/j2ee.jar");
        if (!j2ee.exists()) {
            j2ee = new File(libraryPath, "j2ee.jar");
        }
        try {
            j2eeJarfile = ClassLoaderJarfile.getJarfile(j2ee);
        }
        catch (Exception e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage() + ", when loading " + j2ee.getAbsolutePath());
        }
    }

    private static class ImportedClass {
        private final byte[] bytes;
        private final ClassLoaderJarfile jarfile;
        private final Class<?> clazz;
        private String description;
        private List<ch.e2e.builder.jdp.ast.Parameter> properties = Collections.emptyList();
        private List<MethodDeclaration> methodDeclarations = Collections.emptyList();
        private boolean parsed = false;

        public ImportedClass(Class<?> clazz, byte[] bytes, ClassLoaderJarfile jarfile) {
            this.clazz = clazz;
            this.bytes = bytes;
            this.jarfile = jarfile;
        }

        public String getDescription() {
            this.lazyParseDoc();
            return this.description;
        }

        public List<ch.e2e.builder.jdp.ast.Parameter> getProperties() {
            this.lazyParseDoc();
            return this.properties;
        }

        public List<MethodDeclaration> getMethodDeclarations() {
            this.lazyParseDoc();
            return this.methodDeclarations;
        }

        private void lazyParseDoc() {
            if (!this.parsed) {
                this.parsed = this.parseDoc();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean parseDoc() {
            if (this.jarfile != null) {
                Reader xlibDocReader = this.jarfile.getXlibDocReader();
                if (xlibDocReader != null) {
                    try {
                        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                        XlibClass xlibClass = ((Xlib)mapper.readValue(xlibDocReader, Xlib.class)).getLibraryClass(this.clazz.getName());
                        this.description = xlibClass.getDescription();
                        this.properties = xlibClass.getProperties();
                        this.methodDeclarations = xlibClass.getMethods();
                    }
                    catch (IOException e) {
                        Logging.logger.info("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                    }
                } else {
                    Reader reader = this.jarfile.getJavaDocReader(this.clazz.getName());
                    if (reader != null) {
                        try {
                            this.methodDeclarations = JavaDocParser.parse((Reader)reader);
                        }
                        catch (Exception e) {
                            Logging.logger.info("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                        }
                        finally {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
            return true;
        }
    }
}

