/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.java;

import ch.e2e.builder.compiler.document.importer.java.Completable;
import ch.e2e.builder.compiler.document.importer.java.ElementParent;
import ch.e2e.builder.compiler.document.importer.java.TypeInfo;
import ch.e2e.builder.compiler.uml.BridgeAttribute;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Multiplicity;

public class Attribute
extends BridgeAttribute
implements Completable {
    private ElementParent elementParent;
    private boolean array = false;
    private int arrayDimension = 0;
    private boolean collection = false;
    private boolean map = false;

    public Attribute(String name, TypeInfo typeInfo, String getterPrefix, ElementParent parent, Helpers helpers) {
        this(name, typeInfo, parent, helpers);
        this.setGetterPrefix(getterPrefix);
    }

    public Attribute(String name, TypeInfo typeInfo, ElementParent parent, Helpers helpers) {
        super(name, helpers.getStereotypeFactory().getStereotype("JavaAttribute"), helpers);
        this.elementParent = parent;
        this.setTypeInfo(typeInfo);
    }

    private void setTypeInfo(TypeInfo typeInfo) {
        this.array = typeInfo.isArray();
        this.arrayDimension = typeInfo.getArrayDimension();
        this.collection = typeInfo.isCollection();
        this.map = typeInfo.isMap();
        this.setTypeClass(typeInfo.getBridgeType());
        this.setNativeType(typeInfo.getNativeType());
        if (this.array || this.collection || this.map) {
            this.setArrayElement(typeInfo.getArrayElement(), typeInfo.getNativeArrayElement());
        }
        if (this.collection || this.map) {
            this.setPropertyValueQuietly("nativeArrayType", typeInfo.getNativeType());
        }
    }

    public String getGetterPrefix() {
        return (String)this.getPropertyValueQuietly("getterPrefix");
    }

    public void setGetterPrefix(String prefix) {
        this.setPropertyValueQuietly("getterPrefix", prefix);
    }

    @Override
    public ElementParent getAttributeParent() {
        return this.elementParent;
    }

    @Override
    public BridgeClass getArrayElement() {
        return this.getTypeClass();
    }

    @Override
    public void setArrayElement(BridgeClass bridgeType, String javaType) {
        this.setTypeClass(bridgeType);
        if (bridgeType != null) {
            this.setNativeType(javaType);
        } else {
            this.setNativeType(null);
        }
        this.setMultiplicity(Multiplicity.createMultiplicity(4));
    }

    @Override
    public String getNativeType() {
        return (String)this.getPropertyValueQuietly("nativeType");
    }

    private void setNativeType(String javaType) {
        this.setPropertyValueQuietly("nativeType", javaType);
    }

    @Override
    public String getNativeArrayElement() {
        String result = this.collection ? (String)this.getPropertyValueQuietly("nativeArrayType") : this.getNativeType();
        return result;
    }

    @Override
    public boolean isArray() {
        return this.array;
    }

    public int getArrayDimension() {
        return this.arrayDimension;
    }

    @Override
    public boolean isCollection() {
        return this.collection;
    }

    @Override
    public boolean isMap() {
        return this.map;
    }
}

