/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.idoc;

import ch.e2e.builder.compiler.document.importer.idoc.DocumentationParser;
import ch.e2e.builder.compiler.document.importer.idoc.IDocContainerObject;
import ch.e2e.builder.compiler.document.importer.idoc.IDocObject;
import ch.e2e.builder.compiler.document.importer.idoc.Segment;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Group
extends IDocContainerObject {
    private Segment groupSegment;

    public Group(Element element) {
        super(element);
        this.addTaggedValues();
    }

    @Override
    public void applyFieldMeta(DocumentationParser documentationParser) {
        this.groupSegment.applyFieldMeta(documentationParser);
        super.applyFieldMeta(documentationParser);
    }

    @Override
    public String getStereotype() {
        return IDocContainerObject.getSegmentVersion();
    }

    @Override
    public ArrayList<IDocObject> getChildren() {
        ArrayList<IDocObject> result = new ArrayList<IDocObject>(this.groupSegment.getChildren());
        result.addAll(super.getChildren());
        return result;
    }

    @Override
    public String getName() {
        return this.groupSegment.getName();
    }

    @Override
    public String getType() {
        return this.groupSegment.getType();
    }

    @Override
    public boolean isOptional() {
        return this.groupSegment.isOptional();
    }

    @Override
    public String getStatus() {
        return this.groupSegment.getStatus();
    }

    public String toString() {
        return "Group " + this.getName() + " (" + this.getAttributeList() + ")";
    }

    @Override
    protected void readChildren(NodeList children) {
        boolean first = true;
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equalsIgnoreCase("group")) {
                this.add(new Group((Element)child));
                continue;
            }
            if (name.equalsIgnoreCase("segment")) {
                Segment segment = new Segment((Element)child);
                if (first) {
                    first = false;
                    this.groupSegment = segment;
                    continue;
                }
                this.add(segment);
                continue;
            }
            try {
                String attributeName = child.getNodeName();
                String value = child.getFirstChild().getNodeValue();
                this.setAttribute(attributeName, value);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addTaggedValues() {
        this.addTaggedValue("group", super.getName());
        this.addTaggedValue("hierarchyLevel", String.valueOf(this.readIntValue("level", 1)));
        this.addTaggedValue("type", this.groupSegment.getType());
    }
}

