/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.substitutions;

import ch.e2e.builder.compiler.build.types.SubstitutionsTabfile;
import ch.e2e.builder.compiler.build.types.substitutions.Category;
import ch.e2e.builder.compiler.build.types.substitutions.Enumerator;
import ch.e2e.builder.compiler.build.types.substitutions.MergeStrategy;
import ch.e2e.builder.compiler.build.types.substitutions.Section;
import ch.e2e.builder.compiler.build.types.substitutions.Substitute;
import ch.e2e.builder.compiler.build.types.substitutions.TemplatedFile;
import ch.e2e.builder.compiler.build.types.substitutions.Variable;
import java.util.ArrayList;
import java.util.Map;
import org.w3c.dom.Element;

public class DefaultMergeStrategy
implements MergeStrategy {
    @Override
    public void addSubstitute(SubstitutionsTabfile substitutions, Element element, String categoryName, String sectionName, String targetName, String templateName, String varName, String varFriendlyId, String varLabel, String varDefault, String varType, ArrayList<Enumerator> enumerators) {
        boolean isForwardDeclaration = Boolean.parseBoolean(element.getAttribute("definedElsewhere"));
        Variable variable = this.getVariable(substitutions.getVariables(), varName, varFriendlyId, varLabel, varDefault, varType, enumerators, isForwardDeclaration);
        if ("".equals(targetName)) {
            targetName = templateName;
        }
        if (variable != null) {
            TemplatedFile templatedFile = this.getTemplatedFile(substitutions.getTemplates(), templateName, targetName);
            if (variable.addFile(templatedFile)) {
                Substitute substitute = new Substitute(isForwardDeclaration);
                if (!isForwardDeclaration) {
                    substitute.setCategory(categoryName);
                    substitute.setSection(sectionName);
                    substitute.setMergeStrategy(variable.getMergeStrategyName());
                    substitute.setFriendlyId(varFriendlyId);
                    substitute.setLabel(varLabel);
                    substitute.setDefaultValue(varDefault);
                    substitute.setType(varType);
                    substitute.setEnumerators(enumerators);
                }
                substitute.setTarget(targetName);
                substitute.setTemplate(templateName);
                substitute.setVariableName(variable.getName());
                substitutions.addSubstitute(substitute);
            }
            this.createView(substitutions.getViewStructure(), categoryName, sectionName, variable);
        }
    }

    protected Variable getVariable(Map<String, Variable> variables, String varName, String varFriendlyId, String varLabel, String varDefault, String varType, ArrayList<Enumerator> enumerators, boolean isForwardDeclaration) {
        Variable variable = variables.get(varName);
        if (variable == null) {
            variable = isForwardDeclaration ? new Variable(varName) : new Variable(varName, varFriendlyId, varLabel, varDefault, varType, enumerators);
            variables.put(variable.getName(), variable);
        } else if (!isForwardDeclaration && !variable.isDefined()) {
            variable.setFriendlyId(varFriendlyId);
            variable.setLabel(varLabel);
            variable.setDefaultValue(varDefault);
            variable.setType(varType);
            variable.setEnumerators(enumerators);
            variable.setDefined(true);
        }
        return variable;
    }

    protected TemplatedFile getTemplatedFile(Map<String, TemplatedFile> map, String templateName, String targetName) {
        TemplatedFile templatedFile = map.get(templateName);
        if (templatedFile == null) {
            templatedFile = new TemplatedFile(targetName, templateName);
            map.put(templateName, templatedFile);
        }
        return templatedFile;
    }

    protected void createView(Map<String, Category> viewStructure, String categoryName, String sectionName, Variable variable) {
        if (categoryName == null || categoryName.isEmpty() || sectionName == null || sectionName.isEmpty()) {
            return;
        }
        Category category = viewStructure.get(categoryName);
        if (category == null) {
            category = new Category(categoryName);
            viewStructure.put(categoryName, category);
        }
        Section section = new Section(sectionName);
        section.appendOverride(variable);
        category.mergeSection(section);
    }
}

