/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.substitutions;

import ch.e2e.builder.compiler.build.types.substitutions.Section;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class Category {
    private String label = "Add-Ons";
    private Map<String, Section> sections = new LinkedHashMap<String, Section>();

    public Category() {
    }

    public Category(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void mergeSection(Section section) {
        Section oldSection = this.sections.get(section.getLabel());
        if (oldSection == null) {
            this.sections.put(section.getLabel(), section);
        } else {
            oldSection.appendOverrides(section.getOverrides());
        }
    }

    public void mergeSection(String label) {
        Section section = new Section(label);
        this.mergeSection(section);
    }

    public void appendTo(Element parent) {
        Element element = parent.getOwnerDocument().createElement("Category");
        for (Section section : this.sections.values()) {
            section.appendTo(element);
        }
        if (element.hasChildNodes()) {
            element.setAttribute("label", this.label);
            parent.appendChild(element);
        }
    }

    public Map<String, Section> getSections() {
        return this.sections;
    }
}

