/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.ZipUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmiFile
extends File {
    public static final long serialVersionUID = 1L;
    private UmlDocument umlDocument;

    public XmiFile(UmlDocument umlDocument) {
        super(umlDocument.getOriginalFile().getAbsolutePath());
        this.umlDocument = umlDocument;
    }

    public UmlDocument getUmlDocument() {
        return this.umlDocument;
    }

    public Document getDocument() throws SAXException, ParserConfigurationException, IOException {
        Document xmiDocument;
        try {
            ZipFile zipfile = new ZipFile(this);
            xmiDocument = ZipUtilities.getZippedDocumentFromFile((ZipFile)zipfile);
        }
        catch (IOException e) {
            xmiDocument = DomUtilities.parse((File)this, (boolean)false, (boolean)false, (boolean)false);
        }
        xmiDocument.getDocumentElement().setAttribute("fileid", this.getUmlDocument().getUniqueId());
        return xmiDocument;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        InputStream result;
        try {
            ZipFile zipfile = new ZipFile(this);
            ZipEntry entry = zipfile.entries().nextElement();
            result = zipfile.getInputStream(entry);
        }
        catch (IOException e) {
            result = new FileInputStream(this);
        }
        return result;
    }
}

