/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.types.E2EBuilderDataType;
import ch.e2e.builder.compiler.build.types.Logging;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.document.DependsFile;
import ch.e2e.builder.compiler.document.IncludesFile;
import ch.e2e.builder.compiler.document.UmlDocument;
import java.io.File;
import java.util.Iterator;

public class BridgeXmiFile
implements E2EBuilderDataType,
Logging {
    private DependsFile dependsFile;
    private File srcfile;
    private File targetfile;
    private UmlDocument umlDocument;

    public BridgeXmiFile(UmlDocument umlDocument) {
        this.umlDocument = umlDocument;
        this.srcfile = umlDocument.getBridgeXmiFile();
        this.targetfile = umlDocument.getBridgeXmiWithImportsFile();
        this.dependsFile = umlDocument.getDocumentInfo().getDependsFile();
    }

    public long lastModified() {
        long lastmodified = -1L;
        if (this.targetfile.exists()) {
            lastmodified = this.targetfile.lastModified();
        }
        return lastmodified;
    }

    public UmlDocument getUmlDocument() {
        return this.umlDocument;
    }

    @Override
    public boolean isUpToDate(CompilableObject configuration) {
        boolean result = this.isUpToDate(this.dependsFile.getIncludesFiles().values().iterator());
        if (!result) {
            this.deleteFiles(this.umlDocument);
        }
        return result;
    }

    private boolean isUpToDate(Iterator<IncludesFile> includesFiles) {
        boolean result;
        long srcModified = this.srcfile.lastModified();
        long targetModified = this.targetfile.lastModified();
        boolean bl = result = targetModified > srcModified;
        while (result && includesFiles.hasNext()) {
            IncludesFile includesFile = includesFiles.next();
            UmlDocument includeDoc = this.umlDocument.getUmlDocumentFactory().getUmlDocumentById(includesFile.getUmlFileID());
            result = includeDoc.lastModified() < targetModified;
        }
        return result;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other instanceof BridgeXmiFile) {
            result = this.equals((BridgeXmiFile)other);
        }
        return result;
    }

    public boolean equals(BridgeXmiFile other) {
        return other.getUmlDocument().equals(this.umlDocument);
    }

    public void deleteFiles(UmlDocument umlDocument) {
        this.targetfile.delete();
    }

    public boolean exists() {
        return this.srcfile.exists();
    }
}

