/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.source;

import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.Task;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.control.CompileControl;
import ch.e2e.builder.compiler.build.tasks.source.JavaResourceSource;
import ch.e2e.builder.compiler.build.tasks.source.Logging;
import ch.e2e.builder.compiler.build.tasks.source.ProjectFileSource;
import ch.e2e.builder.compiler.build.tasks.source.Source;
import ch.e2e.builder.compiler.build.tasks.source.SourceFactory;
import ch.e2e.builder.compiler.build.tasks.source.TaskFactory;
import ch.e2e.builder.compiler.build.tasks.source.TaskSourceSetFactory;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SourceManager {
    public static final Double DEFAULT_PRIORITY = 1.0;
    private final File projectFolder;
    private final File workFolder;
    private final List<CompileControl> controls = new ArrayList<CompileControl>();
    private final Map<String, Source> sourceMap = new HashMap<String, Source>();
    private final LinkedList<SourceFactory> sourceFactories;
    private final LinkedList<TaskFactory> taskFactories;
    private final Set<TaskSourceSetFactory> taskSourceSetFactories;
    private final Map<String, Object> customObjects = new HashMap<String, Object>();

    public SourceManager(File projectFolder, LinkedList<SourceFactory> sourceFactories, LinkedList<TaskFactory> taskFactories, Set<TaskSourceSetFactory> taskSourceSetFactories) {
        this.sourceFactories = sourceFactories;
        this.taskFactories = taskFactories;
        this.taskSourceSetFactories = taskSourceSetFactories;
        this.projectFolder = projectFolder;
        this.workFolder = new File(projectFolder, CompilerConstants.WORK_FOLDER);
    }

    public File getProjectFolder() {
        return this.projectFolder;
    }

    public File getWorkFolder() {
        return this.workFolder;
    }

    public List<Task> getTasks() {
        return this.sourceMap.values().stream().filter(source -> source instanceof Task).map(source -> (Task)((Object)source)).collect(Collectors.toList());
    }

    public Source getSource(String id) {
        return id == null ? null : this.sourceMap.computeIfAbsent(id, key -> this.findJavaResourceSource((String)key).orElse(this.findFileSource((String)key).orElse(this.getTask((String)key))));
    }

    public final <T extends Source> T getSource(String id, Class<T> type) {
        return (T)this.getSource(id);
    }

    private Optional<Source> findJavaResourceSource(String id) {
        JavaResourceSource result = null;
        if (id.startsWith(JavaResourceSource.resourceIdPrefix)) {
            result = JavaResourceSource.getResource(id) != null ? new JavaResourceSource(id) : null;
        }
        return Optional.ofNullable(result);
    }

    private Optional<Source> findFileSource(String id) {
        Source result = null;
        File file = new File(this.projectFolder, id);
        if (file.exists()) {
            try {
                SourceFactory sourceFactory = this.getSourceFactory(id);
                if (sourceFactory != null) {
                    result = sourceFactory.createSource(file, this);
                }
            }
            catch (Exception e) {
                result = new ProjectFileSource(file);
            }
        }
        return Optional.ofNullable(result);
    }

    private Source getTask(String id) {
        CacheAbleTask task = null;
        TaskFactory taskFactory = this.getTaskFactory(id);
        if (taskFactory != null) {
            task = taskFactory.createTask(id, this);
        } else {
            Logging.logger.warning("No task factory found for '" + id + "'");
        }
        return task;
    }

    private SourceFactory getSourceFactory(String id) {
        return this.sourceFactories.stream().filter(sourceFactory -> sourceFactory.matchId(id)).findFirst().orElse(null);
    }

    private TaskFactory getTaskFactory(String id) {
        return this.taskFactories.stream().filter(taskFactory -> taskFactory.matchId(id)).findFirst().orElse(null);
    }

    public Stream<TaskSourceSetFactory> getTaskSourceSetFactoryStream(String id) {
        return this.taskSourceSetFactories.stream().filter(taskSourceSetFactory -> taskSourceSetFactory.select(id));
    }

    public CompileControl[] getCompileControls() {
        return this.controls.toArray(new CompileControl[0]);
    }

    public SourceManager addCompileControl(CompileControl control) {
        Optional.ofNullable(control).ifPresent(this.controls::add);
        return this;
    }

    public String relativize(File file) {
        return this.getProjectFolder().toPath().relativize(file.toPath()).toString();
    }

    @Deprecated
    public void putCustomObject(String key, Object object) {
        this.customObjects.put(key, object);
    }

    @Deprecated
    public Object getCustomObject(String key) {
        return this.customObjects.get(key);
    }

    public Stream<Path> getSourceFilesStream() throws IOException {
        Path projectPath = this.getProjectFolder().toPath();
        String workFolder = this.getWorkFolder().toPath().toString();
        return Files.walk(projectPath, new FileVisitOption[0]).filter(path -> !path.toString().startsWith(workFolder));
    }

    public Stream<String> getSourceIdsStream() throws IOException {
        Path projectPath = this.getProjectFolder().toPath();
        return this.getSourceFilesStream().map(path -> projectPath.relativize((Path)path).toString().replace("\\", Folders.SEPARATOR));
    }
}

