/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.testcase;

import ch.e2e.builder.base.io.UniqueIdService;
import ch.e2e.builder.base.io.WrongIDFileVersionException;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.trace.testcase.AbstractAsynchronousTestcaseRoot;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.traceviewer.importer.AsynchronousImporter;
import ch.e2e.builder.traceviewer.testcase.AsynchronousFolder;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AsynchronousTestcaseRoot
extends AbstractAsynchronousTestcaseRoot {
    public AsynchronousTestcaseRoot(String name) {
        super(name);
    }

    public void projectChanged(E2EBuilderProject project) {
        this.clear();
        this.loadChildren();
    }

    public void refresh() {
        this.clear();
        this.loadChildren();
    }

    public AsynchronousFolder importTestcases(Document document, String projectName, String serviceName) throws TransformerException, IOException {
        AsynchronousFolder folder = this.createAsynchronousFolder(projectName, serviceName);
        folder.setTestcaseFolders(AsynchronousImporter.getInstance().createTestcases(document).getDocumentElement().getChildNodes());
        return folder;
    }

    public AsynchronousFolder importInstance(String instance) throws IOException, ParserConfigurationException, SAXException, TransformerException, XPathExpressionException {
        File projectHome = new File(E2EBuilderProject.getProjectFolderName());
        File embeddedServicesFolder = new File(projectHome, "bin/");
        File instanceRoot = new File(embeddedServicesFolder, instance);
        File traceFile = new File(instanceRoot, "asynchronous.trace");
        return this.importTestcases(traceFile, instance, instance);
    }

    private AsynchronousFolder importTestcases(File traceFile, String projectName, String serviceName) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException, TransformerException {
        Document traceDocument = DomUtilities.parse((File)traceFile, (boolean)false, (boolean)false, (boolean)true);
        XPath xpath = DomUtilities.newXPath();
        NodeList xPathResult = (NodeList)xpath.evaluate("/AsynchronousTrace/PersistentStateClass", traceDocument.getDocumentElement(), XPathConstants.NODESET);
        AsynchronousFolder result = null;
        if (xPathResult.getLength() > 0) {
            result = this.importTestcases(traceDocument, projectName, serviceName);
        }
        return result;
    }

    private AsynchronousFolder createAsynchronousFolder(String name, String serviceName) {
        AsynchronousFolder folder = (AsynchronousFolder)this.get(name);
        if (folder == null) {
            String folderName;
            HashMap ids;
            File wsdlIds = new File(this.getHome(), ".wsdl.folder.ids");
            if (wsdlIds.exists()) {
                try {
                    ids = UniqueIdService.loadUniqueIds((File)wsdlIds);
                    folderName = (String)ids.get(name);
                    if (folderName == null) {
                        folderName = this.findNewId(name, ids);
                    }
                }
                catch (WrongIDFileVersionException e) {
                    ids = new HashMap();
                    folderName = this.findNewId(name, ids);
                }
            } else {
                ids = new HashMap();
                folderName = this.findNewId(name, ids);
            }
            UniqueIdService.saveIds(ids, (File)wsdlIds);
            File home = new File(this.getHome(), folderName);
            folder = new AsynchronousFolder(name, home, serviceName);
            this.add((TestcaseObject)folder);
        }
        return folder;
    }

    private void refreshChildren() {
        File wsdlIds = new File(this.getHome(), ".wsdl.folder.ids");
        if (wsdlIds.exists()) {
            try {
                HashMap ids = UniqueIdService.loadUniqueIds((File)wsdlIds);
                for (String name : ids.keySet()) {
                    AsynchronousFolder folder;
                    File directory = new File(this.getHome(), (String)ids.get(name));
                    File idFile = new File(directory, ".asynchronous.id");
                    if (this.exists(name) || !idFile.exists() || (folder = new AsynchronousFolder(directory.getName(), directory, idFile)).getChildCount() <= 0) continue;
                    this.add((TestcaseObject)folder);
                }
            }
            catch (WrongIDFileVersionException wrongIDFileVersionException) {
                // empty catch block
            }
        }
    }

    private void loadChildren() {
        File wsdlIds = new File(this.getHome(), ".wsdl.folder.ids");
        if (wsdlIds.exists()) {
            try {
                HashMap ids = UniqueIdService.loadUniqueIds((File)wsdlIds);
                for (String name : ids.keySet()) {
                    AsynchronousFolder folder;
                    File directory = new File(this.getHome(), (String)ids.get(name));
                    File idFile = new File(directory, ".asynchronous.id");
                    if (!idFile.exists() || (folder = new AsynchronousFolder(name, directory, idFile)).getChildCount() <= 0) continue;
                    this.add((TestcaseObject)folder);
                }
            }
            catch (WrongIDFileVersionException wrongIDFileVersionException) {
                // empty catch block
            }
        }
    }
}

