/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.logimport;

import ch.e2e.builder.trace.testcase.TraceSettings;
import ch.e2e.builder.traceviewer.logimport.Logging;
import ch.e2e.dom.DomUtilities;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LogRequest
implements Logging {
    private int id;
    private Map<String, String> httpHeaders = new LinkedHashMap<String, String>();
    private String host;
    private String path;
    private String httpVersion;
    private String operation;
    private String soapAction;
    private Document request;
    private TraceSettings.TraceLevel traceLevel;
    private Integer traceMaxSize;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void addHttpHeader(String key, String value) {
        this.httpHeaders.put(key, value);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(String version) {
        this.httpVersion = version;
    }

    public Document getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        try {
            Element element;
            this.request = DomUtilities.parse((Reader)new StringReader(request), (boolean)false, (boolean)false, (boolean)true);
            Element bodyElement = this.getBodyElement();
            if (bodyElement != null && (element = DomUtilities.getFirstElement((NodeList)bodyElement.getChildNodes())) != null) {
                this.operation = element.getNamespaceURI() + "." + element.getLocalName();
            }
            this.setTraceInfo();
        }
        catch (ParserConfigurationException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "setRequest", e);
        }
        catch (SAXException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "setRequest", e);
        }
        catch (IOException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "setRequest", e);
        }
    }

    public TraceSettings.TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    public Integer getTraceMaxSize() {
        return this.traceMaxSize;
    }

    public Element getBodyElement() {
        return (Element)this.request.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body").item(0);
    }

    private void setTraceInfo() {
        Element traceElement = this.getTraceElement();
        if (traceElement != null) {
            String value = traceElement.getAttribute("level");
            if (value != null && value.length() > 0) {
                try {
                    this.traceLevel = TraceSettings.TraceLevel.valueOf((String)value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if ((value = traceElement.getAttribute("maxSize")) != null) {
                try {
                    this.traceMaxSize = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private Element getHeaderElement() {
        return (Element)this.request.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header").item(0);
    }

    private Element getTraceElement() {
        Element element = this.getHeaderElement();
        if (element != null) {
            element = (Element)element.getElementsByTagNameNS("http://e2e.ch/bridge", "Trace").item(0);
        }
        return element == null ? null : element;
    }

    public NodeList getParameterList() {
        Element parameterElement = this.getParameterElement();
        return parameterElement == null ? DomUtilities.emptyNodeList() : parameterElement.getChildNodes();
    }

    private Element getParameterElement() {
        return DomUtilities.getFirstElement((NodeList)this.getBodyElement().getChildNodes());
    }

    public void setSoapAction(String action) {
        if (action != null) {
            this.soapAction = action;
        }
    }

    public String getLocation() {
        return "http://" + this.host + this.path;
    }

    public String getQualifiedOperation() {
        return this.soapAction == null ? this.operation : this.soapAction;
    }
}

