/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.gui.uml;

import ch.e2e.builder.analyzer.gui.uml.ObjectWithToolTip;
import ch.e2e.builder.analyzer.model.TransactionLogEntry;

public class Message
implements ObjectWithToolTip {
    private TransactionLogEntry entry;

    public Message(TransactionLogEntry entry) {
        this.entry = entry;
    }

    public String getName() {
        String name;
        if (this.entry.isInterface()) {
            name = this.entry.getOperation();
        } else if (this.entry.isPState()) {
            if (this.entry.isIOEnter() && "Send".equalsIgnoreCase(this.entry.getParam_1())) {
                name = this.entry.getParam_2();
                int index = name.lastIndexOf(46);
                if (index > 0) {
                    name = name.substring(index + 1);
                }
            } else {
                name = this.entry.getParam_1().split("\\Q...\\E")[0];
                if (this.entry.isDoActionEnter() || this.entry.isDoActionExit()) {
                    name = "do / " + name;
                }
            }
        } else {
            name = this.entry.getOperation();
        }
        return name;
    }

    public String getRequestId() {
        return this.entry.getFullRequestId();
    }

    public int getElapsedTime() {
        return this.entry.getElapsedTime();
    }

    public int getLine() {
        return this.entry.getLineNumber();
    }

    public int getIndex() {
        return this.entry.getIndex();
    }

    public boolean hasError() {
        return this.entry.hasState(TransactionLogEntry.State.ERROR);
    }

    @Override
    public String getToolTipText() {
        return !this.entry.isPState() && this.hasError() ? "<html><span style='color:#FF0000'>" + this.entry.getParam_2() + "</span></html>" : null;
    }

    public String toString() {
        return this.getName();
    }
}

