/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.io;

import ch.e2e.io.ProcessStoppedEvent;
import ch.e2e.io.ProcessStoppedEventMulticaster;
import ch.e2e.io.ProcessStoppedListener;
import ch.e2e.io.ProgramRunningException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class ProcessExecuter {
    private StreamThread stderr;
    private StreamThread stdout;
    private int exitValue;
    private ProgramWaiter waiter;
    private OutputStream stdoutWriter;
    private OutputStream stderrWriter;
    private String stdoutResult;
    private String stderrResult;
    private OutputStreamWriter processInput;
    private ProcessStoppedListener stoppedListener;

    public void addProcessStoppedListener(ProcessStoppedListener stoppedListener) {
        this.stoppedListener = ProcessStoppedEventMulticaster.addListener(this.stoppedListener, stoppedListener);
    }

    public void removeProcessStoppedListener(ProcessStoppedListener stoppedListener) {
        this.stoppedListener = ProcessStoppedEventMulticaster.removeListener(this.stoppedListener, stoppedListener);
    }

    public void execute(String[] cmdArray, String[] envp, File dir) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(cmdArray, envp, dir);
        this.setStreams(process);
        this.waiter = new ProgramWaiter(cmdArray[0], process);
        this.waiter.start();
    }

    public void execute(String cmd) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(new String[]{cmd});
        this.setStreams(process);
        this.waiter = new ProgramWaiter(cmd, process);
        this.waiter.start();
    }

    public synchronized int executeAndWait(String[] cmdArray, String[] envp, File executingDir) throws IOException, InterruptedException {
        Process proc = Runtime.getRuntime().exec(cmdArray, envp, executingDir);
        this.setStreams(proc);
        this.exitValue = proc.waitFor();
        if (this.stdoutWriter != null) {
            this.stdoutWriter.flush();
        }
        if (this.stderrWriter != null) {
            this.stderrWriter.flush();
        }
        this.stdoutResult = this.stdout.stream.toString();
        this.stderrResult = this.stderr.stream.toString();
        return this.exitValue;
    }

    public synchronized int executeAndWait(String cmd) throws IOException, InterruptedException {
        Process proc = Runtime.getRuntime().exec(new String[]{cmd});
        this.setStreams(proc);
        this.exitValue = proc.waitFor();
        if (this.stdoutWriter != null) {
            this.stdoutWriter.flush();
        }
        if (this.stderrWriter != null) {
            this.stderrWriter.flush();
        }
        this.stdoutResult = this.stdout.stream.toString();
        this.stderrResult = this.stderr.stream.toString();
        return this.exitValue;
    }

    public String getStdoutResult() {
        return this.stdoutResult;
    }

    public String getStdErrString() {
        return this.stderrResult;
    }

    public void setSystemOut(OutputStream stdoutWriter) {
        this.stdoutWriter = stdoutWriter;
    }

    public void setSystemErr(OutputStream stderrWriter) {
        this.stderrWriter = stderrWriter;
    }

    public boolean isRunning() {
        return this.waiter != null && this.waiter.isAlive();
    }

    public int getExitValue() throws ProgramRunningException {
        if (this.waiter != null && this.waiter.isAlive()) {
            throw new ProgramRunningException(this.waiter.programName);
        }
        return this.exitValue;
    }

    public void writeToProgram(String message) throws IOException {
        this.processInput.write(message);
        this.processInput.flush();
    }

    private void setStreams(Process proc) {
        this.stderr = new StreamThread(proc.getErrorStream());
        this.stdout = new StreamThread(proc.getInputStream());
        this.stderr.out = this.stderrWriter;
        this.stdout.out = this.stdoutWriter;
        this.stderr.start();
        this.stdout.start();
        this.processInput = new OutputStreamWriter(proc.getOutputStream());
    }

    private class ProgramWaiter
    extends Thread {
        private Process process;
        private String programName;

        ProgramWaiter(String programName, Process process) {
            this.programName = programName;
            this.process = process;
        }

        @Override
        public void run() {
            try {
                ProcessExecuter.this.exitValue = this.process.waitFor();
            }
            catch (Exception exception) {
            }
            finally {
                ProcessExecuter.this.waiter = null;
            }
            if (ProcessExecuter.this.stoppedListener != null) {
                ProcessExecuter.this.stoppedListener.processStopped(new ProcessStoppedEvent(ProcessExecuter.this));
            }
        }
    }

    private class StreamThread
    extends Thread {
        private InputStream in;
        private StringBuffer stream = new StringBuffer(1024);
        private OutputStream out;

        StreamThread(InputStream in) {
            this.in = in;
        }

        @Override
        public void run() {
            try {
                int ch;
                while ((ch = this.in.read()) != -1) {
                    this.stream.append((char)ch);
                    if (this.out == null) continue;
                    this.out.write(ch);
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (this.out != null) {
                        this.out.flush();
                    }
                }
                catch (Exception exception) {}
                try {
                    this.in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

