/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmiNodeCollector {
    Document xmiDocument1;
    Document xmiDocument2;
    public Collection<NodeDefinition> ignoredNodes = new ArrayList<NodeDefinition>();
    Set<String> unknown = new HashSet<String>();
    public Collection<NodeDefinition> collectChildrenNodes = new ArrayList<NodeDefinition>();
    public Collection<NodeDefinition> collectNodes = new ArrayList<NodeDefinition>();

    public XmiNodeCollector(Document xmiDocument1, Document xmiDocument2) {
        this(xmiDocument1, xmiDocument2, new ArrayList<NodeDefinition>());
    }

    public XmiNodeCollector(Document xmiDocument1, Document xmiDocument2, Collection<NodeDefinition> ignoredNodes) {
        this.xmiDocument1 = xmiDocument1;
        this.xmiDocument2 = xmiDocument2;
        this.ignoredNodes = ignoredNodes;
        this.collectChildrenNodes.add(new NodeDefinition("uml:Model"));
        this.collectNodes.add(new NodeDefinition("packagedElement"));
        this.collectNodes.add(new NodeDefinition("ownedLiteral"));
        this.collectNodes.add(new NodeDefinition("ownedAttribute"));
        this.collectNodes.add(new NodeDefinition("ownedOperation"));
        this.collectNodes.add(new NodeDefinition("ownedParameter"));
        this.collectNodes.add(new NodeDefinition("ownedRule"));
        this.collectNodes.add(new NodeDefinition("nestedArtifact"));
    }

    private Map<String, Node> collect(Document xmiDocument) {
        HashMap<String, Node> elementMap = new HashMap<String, Node>();
        for (Node child = xmiDocument.getDocumentElement().getFirstChild(); child != null; child = child.getNextSibling()) {
            elementMap.putAll(this.collectElement(child, ""));
        }
        return elementMap;
    }

    public Collection<Object[]> collect() {
        Map<String, Node> allElements1 = this.collect(this.xmiDocument1);
        Map<String, Node> allElements2 = this.collect(this.xmiDocument2);
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(allElements1.keySet());
        keys.addAll(allElements2.keySet());
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (String key : keys) {
            result.add(new Object[]{key, new Node[]{allElements1.get(key), allElements2.get(key)}});
        }
        return result;
    }

    public Set<String> getUnknown() {
        return this.unknown;
    }

    private Map<String, Node> collectElement(Node element, String path) {
        HashMap<String, Node> foundElements = new HashMap<String, Node>();
        Node name = element.getAttributes() != null ? element.getAttributes().getNamedItem("name") : null;
        if (this.isIn(this.ignoredNodes, element, path = path + "::" + (name != null ? name.getTextContent() : "NULL")).booleanValue() || name == null) {
            return foundElements;
        }
        if (this.isIn(this.collectChildrenNodes, element, path).booleanValue()) {
            for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                foundElements.putAll(this.collectElement(child, path));
            }
        } else if (this.isIn(this.collectNodes, element, path).booleanValue()) {
            Node xmiType = element.getAttributes() != null ? element.getAttributes().getNamedItem("xmi:type") : null;
            String pathType = path + ">" + (xmiType != null ? xmiType.getTextContent() : "NULL");
            foundElements.put(pathType, element);
            for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                foundElements.putAll(this.collectElement(child, path));
            }
        } else {
            this.unknown.add(element.getNodeName());
        }
        return foundElements;
    }

    private Boolean isIn(Collection<NodeDefinition> nodeList, Node node, String path) {
        for (NodeDefinition ignoredNode : nodeList) {
            if (ignoredNode.name != null && !node.getNodeName().equals(ignoredNode.name) || ignoredNode.path != null && !path.equals(ignoredNode.path)) continue;
            Boolean ignored = true;
            for (Map.Entry<String, String> entry : ignoredNode.attributes.entrySet()) {
                Node attributeNode = node.getAttributes().getNamedItem(entry.getKey());
                if (attributeNode.getTextContent().equals(entry.getValue())) continue;
                ignored = false;
                break;
            }
            if (!ignored.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static class NodeDefinition {
        public String name;
        public String path;
        public Map<String, String> attributes = new HashMap<String, String>();

        public NodeDefinition() {
        }

        public NodeDefinition(String name) {
            this.name = name;
        }

        public NodeDefinition(String name, String path) {
            this.name = name;
            this.path = path;
        }
    }
}

