/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.activity;

import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.gui.uml.UmlVertexView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.graph.VertexView;

public class ReferenceView
extends UmlVertexView {
    private static final ReferenceRenderer RENDERER = new ReferenceRenderer();

    public ReferenceView() {
    }

    public ReferenceView(Object cell) {
        super(cell);
    }

    @Override
    public CellViewRenderer getRenderer() {
        return RENDERER;
    }

    @Override
    public Point2D getPerimeterPoint(EdgeView edge, Point2D source, Point2D p) {
        return this.getRenderer() instanceof ReferenceRenderer ? ((ReferenceRenderer)this.getRenderer()).getPerimeterPoint(this, source, p) : super.getPerimeterPoint(edge, source, p);
    }

    protected static class ReferenceRenderer
    extends VertexRenderer {
        protected ReferenceRenderer() {
        }

        public void paint(Graphics g) {
            this.setOpaque(true);
            Color color = g.getColor();
            g.setColor(this.getBackground());
            g.fillArc(0, 0, this.getWidth() - 1, this.getHeight() - 1, 0, 360);
            g.setColor(this.bordercolor);
            g.drawArc(0, 0, this.getWidth() - 1, this.getHeight() - 1, 0, 360);
            g.setColor(this.getForeground());
            g.drawString(this.getText(), this.getWidth() / 3, this.getHeight() * 3 / 4);
            g.setColor(color);
            this.paintSelectionBorder(g);
        }

        protected void paintSelectionBorder(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Stroke previousStroke = g2d.getStroke();
            if (this.childrenSelected || this.selected) {
                g2d.setStroke(UmlGraphConstants.SELECTION_STROKE);
                if (this.childrenSelected) {
                    g.setColor(this.gridColor);
                } else if (this.hasFocus && this.selected) {
                    g.setColor(this.lockedHandleColor);
                } else {
                    g.setColor(this.highlightColor);
                }
                g.drawArc(0, 0, this.getWidth() - 1, this.getHeight() - 1, 0, 360);
            } else {
                g2d.setStroke(previousStroke);
            }
        }

        public Point2D getPerimeterPoint(VertexView view, Point2D source, Point2D p) {
            Rectangle2D bounds = view.getBounds();
            double width = bounds.getWidth();
            double height = bounds.getHeight();
            double xCenter = bounds.getX() + width / 2.0;
            double yCenter = bounds.getY() + height / 2.0;
            double dx = p.getX() - xCenter;
            double dy = p.getY() - yCenter;
            double angle = Math.atan2(dy, dx);
            double xOut = xCenter + width / 2.0 * Math.cos(angle);
            double yOut = yCenter + height / 2.0 * Math.sin(angle);
            return new Point2D.Double(xOut, yOut);
        }
    }
}

