/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml;

import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.border.AbstractBorder;

public class UmlLineBorder
extends AbstractBorder {
    private Color borderColor;
    private boolean dashed;
    private int cornerRadius;

    public UmlLineBorder(Color borderColor) {
        this(borderColor, false, -1);
    }

    public UmlLineBorder(Color borderColor, boolean dashed) {
        this(borderColor, dashed, -1);
    }

    public UmlLineBorder(Color borderColor, int cornerRadius) {
        this(borderColor, false, cornerRadius);
    }

    public UmlLineBorder(Color borderColor, boolean dashed, int cornerRadius) {
        this.borderColor = borderColor;
        this.dashed = dashed;
        this.cornerRadius = cornerRadius;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color color = g.getColor();
        g.setColor(this.borderColor);
        Graphics2D g2d = (Graphics2D)g;
        if (this.dashed) {
            g2d.setStroke(UmlGraphConstants.DASHED_STROKE);
        }
        if (this.cornerRadius > 0) {
            g2d.drawRoundRect(x, y, width - 1, height - 1, this.cornerRadius, this.cornerRadius);
        } else {
            g2d.drawRect(x, y, width - 1, height - 1);
        }
        g.setColor(color);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getCornerRadius() {
        return this.cornerRadius;
    }

    public boolean isDashed() {
        return this.dashed;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

