/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.parameter;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.testcase.parameter.DateTimeParameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.TimeZone;
import javax.swing.AbstractCellEditor;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import javax.swing.text.TextAction;
import javax.swing.tree.TreeCellEditor;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class DateTimeCellEditor
extends AbstractCellEditor
implements TreeCellEditor {
    private static DatatypeFactory datatypeFactory;
    private DateTimeEditor realEditor;
    private FallbackEditor fallbackEditor;
    private EditorComponent delegate;
    private E2EBuilderModule module;

    public DateTimeCellEditor(E2EBuilderModule module) {
        this.module = module;
        this.realEditor = new DateTimeEditor();
        this.fallbackEditor = new FallbackEditor();
    }

    @Override
    public Object getCellEditorValue() {
        return this.delegate.getValue();
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        JComponent editorComponent = null;
        if (value instanceof DateTimeParameter) {
            Object parameterValue = ((DateTimeParameter)value).getValue();
            if (parameterValue == null || parameterValue instanceof XMLGregorianCalendar) {
                try {
                    this.realEditor.setValue((XMLGregorianCalendar)parameterValue);
                    editorComponent = this.realEditor;
                    this.delegate = this.realEditor;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            } else {
                this.fallbackEditor.setText(parameterValue.toString());
                editorComponent = this.fallbackEditor;
                this.delegate = this.fallbackEditor;
            }
        }
        return editorComponent;
    }

    @Override
    public boolean stopCellEditing() {
        return this.delegate.stopCellEditing();
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            // empty catch block
        }
    }

    private static interface EditorComponent {
        public Object getValue();

        public boolean stopCellEditing();
    }

    private class FallbackEditor
    extends JTextField
    implements EditorComponent {
        private FallbackEditor() {
            super(40);
        }

        @Override
        public Object getValue() {
            return this.getText();
        }

        @Override
        public boolean stopCellEditing() {
            DateTimeCellEditor.this.fireEditingStopped();
            return true;
        }
    }

    private abstract class DateTimeInputVerifier
    extends InputVerifier {
        private DateTimeInputVerifier() {
        }

        public abstract void setValue() throws IllegalArgumentException, ParseException;

        @Override
        public boolean verify(JComponent input) {
            boolean valid = false;
            try {
                this.setValue();
                valid = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return valid;
        }

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            boolean yieldFocus = false;
            Color foregroundColor = Color.RED;
            if (this.verify(input)) {
                foregroundColor = Color.BLACK;
                yieldFocus = true;
            }
            input.setForeground(foregroundColor);
            return yieldFocus;
        }
    }

    private class TimezoneFormatter
    extends DefaultFormatter {
        private String formatTip;

        public TimezoneFormatter() {
            this("");
        }

        public TimezoneFormatter(String formatTip) {
            this.formatTip = formatTip;
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            return text == null || text.length() == 0 || text.equals(this.formatTip) ? null : (text.equals("+00:00") ? "Z" : super.stringToValue(text));
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            String text;
            if (value == null) {
                text = this.formatTip;
                this.getFormattedTextField().setForeground(Color.GRAY);
            } else {
                text = super.valueToString(value);
                if (text.equals("+00:00")) {
                    text = "Z";
                }
            }
            return text;
        }
    }

    private class DecimalFormatter
    extends NumberFormatter {
        private int length;
        private String formatTip;
        private String filler;

        public DecimalFormatter(int length) {
            this(length, "");
        }

        public DecimalFormatter(int length, String formatTip) {
            NumberFormat fmt = NumberFormat.getNumberInstance();
            fmt.setMaximumFractionDigits(100);
            this.setFormat(fmt);
            this.length = length;
            this.formatTip = formatTip;
            char[] c = new char[length];
            Arrays.fill(c, '0');
            this.filler = new String(c);
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            return text == null || text.length() == 0 || text.equals(this.formatTip) ? null : super.stringToValue(text);
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            String text;
            if (value == null) {
                text = this.formatTip;
                this.getFormattedTextField().setForeground(Color.GRAY);
            } else {
                text = super.valueToString(value);
                int actLength = text.length();
                if (actLength < this.length) {
                    text = this.filler.substring(this.length - actLength) + text;
                } else {
                    int idx = text.indexOf(46);
                    if (idx > -1 && idx < this.length) {
                        text = this.filler.substring(this.length - idx) + text;
                    }
                }
            }
            return text;
        }
    }

    private class IntegerFormatter
    extends NumberFormatter {
        private String format;
        private String formatTip;

        public IntegerFormatter(int length) {
            this(length, "");
        }

        public IntegerFormatter(int length, String formatTip) {
            super(NumberFormat.getIntegerInstance());
            this.format = "%0" + length + "d";
            this.formatTip = formatTip;
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            return text == null || text.length() == 0 || text.equals(this.formatTip) ? null : super.stringToValue(text);
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            String result;
            if (value == null || value.equals(Integer.MIN_VALUE)) {
                result = this.formatTip;
                this.getFormattedTextField().setForeground(Color.GRAY);
            } else {
                result = String.format(this.format, value);
            }
            return result;
        }
    }

    private class DateTimeEditor
    extends JPanel
    implements EditorComponent {
        private static final String FORMATTIP_YEAR = "[-]yyyy";
        private static final String FORMATTIP_MONTH = "mm";
        private static final String FORMATTIP_DAY = "dd";
        private static final String FORMATTIP_HOUR = "hh";
        private static final String FORMATTIP_MINUTE = "mm";
        private static final String FORMATTIP_SECOND = "ss[.S]";
        private static final String FORMATTIP_TIMEZONE = "{+|-}hh:mm";
        private static final String TOOLTIP_YEAR = "Year: [[-]yyyy]";
        private static final String TOOLTIP_MONTH = "Month: [mm]";
        private static final String TOOLTIP_DAY = "Day: [dd]";
        private static final String TOOLTIP_HOUR = "Hour: [hh]";
        private static final String TOOLTIP_MINUTE = "Minute: [mm]";
        private static final String TOOLTIP_SECOND = "Second: [ss(.(s)+)?]";
        private static final String TOOLTIP_TIMEZONE = "Timezone: [(+|-)hh:mm | 'Z']";
        private static final String SEPARATOR_DATE = "-";
        private static final String SEPARATOR_DATETIME = "T";
        private static final String SEPARATOR_TIME = ":";
        private XMLGregorianCalendar value;
        private XMLGregorianCalendar internalValue;
        private EnumMap<DateTimeKeys, JFormattedTextField> items = new EnumMap(DateTimeKeys.class);

        public DateTimeEditor() {
            this.createGui();
        }

        @Override
        public Object getValue() {
            try {
                if (this.isEmpty()) {
                    this.value = null;
                } else {
                    this.internalValue.getXMLSchemaType();
                    this.value = this.internalValue;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return this.value;
        }

        public void setValue(XMLGregorianCalendar value) {
            this.value = value;
            this.internalValue = value == null ? datatypeFactory.newXMLGregorianCalendar() : (XMLGregorianCalendar)value.clone();
            for (JFormattedTextField f : this.items.values()) {
                f.setForeground(Color.BLACK);
            }
            this.setValue(DateTimeKeys.YEAR, this.getYear());
            this.setValue(DateTimeKeys.MONTH, this.getMonth());
            this.setValue(DateTimeKeys.DAY, this.getDay());
            this.setValue(DateTimeKeys.HOUR, this.getHour());
            this.setValue(DateTimeKeys.MINUTE, this.getMinute());
            this.setValue(DateTimeKeys.SECOND, this.getSecond());
            this.setValue(DateTimeKeys.TIMEZONE, this.getTimezone());
        }

        @Override
        public boolean stopCellEditing() {
            for (JFormattedTextField f : this.items.values()) {
                f.getInputVerifier().verify(f);
            }
            DateTimeCellEditor.this.fireEditingStopped();
            return true;
        }

        private boolean isEmpty() {
            return this.getYear() == null && this.getMonth() == null && this.getDay() == null && this.getHour() == null && this.getMinute() == null && this.getSecond() == null;
        }

        private void createGui() {
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(null);
            this.setBackground(Color.WHITE);
            this.setOpaque(true);
            this.items.put(DateTimeKeys.YEAR, this.createItem(new IntegerFormatter(4, FORMATTIP_YEAR), new IntegerFormatter(4), 5, TOOLTIP_YEAR, SEPARATOR_DATE));
            this.items.put(DateTimeKeys.MONTH, this.createItem(new IntegerFormatter(2, "mm"), new IntegerFormatter(2), 2, TOOLTIP_MONTH, SEPARATOR_DATE));
            this.items.put(DateTimeKeys.DAY, this.createItem(new IntegerFormatter(2, FORMATTIP_DAY), new IntegerFormatter(2), 2, TOOLTIP_DAY, SEPARATOR_DATETIME));
            this.items.put(DateTimeKeys.HOUR, this.createItem(new IntegerFormatter(2, FORMATTIP_HOUR), new IntegerFormatter(2), 2, TOOLTIP_HOUR, SEPARATOR_TIME));
            this.items.put(DateTimeKeys.MINUTE, this.createItem(new IntegerFormatter(2, "mm"), new IntegerFormatter(2), 2, TOOLTIP_MINUTE, SEPARATOR_TIME));
            this.items.put(DateTimeKeys.SECOND, this.createItem(new DecimalFormatter(2, FORMATTIP_SECOND), new DecimalFormatter(2), 6, TOOLTIP_SECOND, null));
            this.items.put(DateTimeKeys.TIMEZONE, this.createItem(new TimezoneFormatter(FORMATTIP_TIMEZONE), new TimezoneFormatter(), 6, TOOLTIP_TIMEZONE, null));
            this.setupCloseActions();
            this.setupInputVerifiers();
            this.setupFocusListeners();
        }

        private JFormattedTextField createItem(JFormattedTextField.AbstractFormatter formatter, JFormattedTextField.AbstractFormatter editFormatter, int columns, String tooltip, String separator) {
            DefaultFormatterFactory formatterFactory = new DefaultFormatterFactory(formatter, formatter, editFormatter);
            JFormattedTextField item = new JFormattedTextField(formatterFactory);
            item.setColumns(columns);
            item.setToolTipText(tooltip);
            this.add(item);
            if (separator != null) {
                this.add(new JLabel(separator));
            }
            return item;
        }

        private void setupCloseActions() {
            String key = "close";
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
            TextAction action = new TextAction("close"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFormattedTextField f = (JFormattedTextField)e.getSource();
                    if (f.getInputVerifier().shouldYieldFocus(f)) {
                        DateTimeEditor.this.stopCellEditing();
                    }
                }
            };
            ActionMap actionMap = this.items.get((Object)DateTimeKeys.YEAR).getActionMap();
            actionMap.put("close", action);
            for (JFormattedTextField f : this.items.values()) {
                f.getInputMap().put(keyStroke, "close");
                f.setActionMap(actionMap);
            }
        }

        private void setupInputVerifiers() {
            this.items.get((Object)DateTimeKeys.YEAR).setInputVerifier(new DateTimeInputVerifier(){

                @Override
                public void setValue() throws IllegalArgumentException, ParseException {
                    Object newValue = ((JFormattedTextField)DateTimeEditor.this.items.get((Object)DateTimeKeys.YEAR)).getFormatter().stringToValue(((JFormattedTextField)DateTimeEditor.this.items.get((Object)DateTimeKeys.YEAR)).getText());
                    int year = newValue == null ? Integer.MIN_VALUE : Integer.valueOf(newValue.toString());
                    DateTimeEditor.this.internalValue.setYear(year);
                }
            });
            this.items.get((Object)DateTimeKeys.MONTH).setInputVerifier(new DateTimeInputVerifier(){

                @Override
                public void setValue() throws IllegalArgumentException, ParseException {
                    Object newValue = ((JFormattedTextField)DateTimeEditor.this.items.get((Object)DateTimeKeys.MONTH)).getFormatter().stringToValue(((JFormattedTextField)DateTimeEditor.this.items.get((Object)DateTimeKeys.MONTH)).getText());
                    int month = newValue == null ? Integer.MIN_VALUE : Integer.valueOf(newValue.toString());
                    DateTimeEditor.this.internalValue.setMonth(month);
                }
            });
            this.items.get((Object)DateTimeKeys.DAY).setInputVerifier(new DateTimeInputVerifier(){

                @Override
                public void setValue() throws IllegalArgumentException, ParseException {
                    Object newValue = ((JFormattedTextField)DateTimeEditor.this.items.get((Object)DateTimeKeys.DAY)).getFormatter().stringToValue(((JFormattedTextField)DateTimeEditor.this.items.get((Object)DateTimeKeys.DAY)).getText());
                    int day = newValue == null ? Integer.MIN_VALUE : Integer.valueOf(newValue.toString());
                    DateTimeEditor.this.internalValue.setDay(day);
                }
            });
            this.items.get((Object)DateTimeKeys.HOUR).setInputVerifier(new DateTimeInputVerifier(){

                @Override
                public void setValue() throws IllegalArgumentException, ParseException {
                    Object newValue = ((JFormattedTextField)DateTimeEditor.this.items.get((Object)DateTimeKeys.HOUR)).getFormatter().stringToValue(((JFormattedTextField)DateTimeEditor.this.items.get((Object)DateTimeKeys.HOUR)).getText());
                    int hour = newValue == null ? Integer.MIN_VALUE : Integer.valueOf(newValue.toString());
                    DateTimeEditor.this.internalValue.setHour(hour);
                }
            });
            this.items.get((Object)DateTimeKeys.MINUTE).setInputVerifier(new DateTimeInputVerifier(){

                @Override
                public void setValue() throws IllegalArgumentException, ParseException {
                    Object newValue = ((JFormattedTextField)DateTimeEditor.this.items.get((Object)DateTimeKeys.MINUTE)).getFormatter().stringToValue(((JFormattedTextField)DateTimeEditor.this.items.get((Object)DateTimeKeys.MINUTE)).getText());
                    int minute = newValue == null ? (DateTimeEditor.this.getHour() == null ? Integer.MIN_VALUE : 0) : Integer.valueOf(newValue.toString());
                    DateTimeEditor.this.internalValue.setMinute(minute);
                }
            });
            this.items.get((Object)DateTimeKeys.SECOND).setInputVerifier(new DateTimeInputVerifier(){

                @Override
                public void setValue() throws IllegalArgumentException, ParseException {
                    Integer second;
                    Object newValue = ((JFormattedTextField)DateTimeEditor.this.items.get((Object)DateTimeKeys.SECOND)).getFormatter().stringToValue(((JFormattedTextField)DateTimeEditor.this.items.get((Object)DateTimeKeys.SECOND)).getText());
                    BigDecimal fractionalSecond = null;
                    if (newValue == null) {
                        second = DateTimeEditor.this.getHour() == null ? Integer.MIN_VALUE : 0;
                    } else {
                        String s = newValue.toString();
                        int idx = s.indexOf(46);
                        if (idx > -1) {
                            second = Integer.valueOf(s.substring(0, idx));
                            fractionalSecond = BigDecimal.valueOf(Double.valueOf(s.substring(idx)));
                        } else {
                            second = Integer.valueOf(s);
                        }
                    }
                    DateTimeEditor.this.internalValue.setSecond(second);
                    DateTimeEditor.this.internalValue.setFractionalSecond(fractionalSecond);
                }
            });
            this.items.get((Object)DateTimeKeys.TIMEZONE).setInputVerifier(new DateTimeInputVerifier(){

                @Override
                public void setValue() throws IllegalArgumentException, ParseException {
                    Object newValue = ((JFormattedTextField)DateTimeEditor.this.items.get((Object)DateTimeKeys.TIMEZONE)).getFormatter().stringToValue(((JFormattedTextField)DateTimeEditor.this.items.get((Object)DateTimeKeys.TIMEZONE)).getText());
                    int offset = Integer.MIN_VALUE;
                    if (newValue != null) {
                        String s = newValue.toString();
                        if (!s.equals("Z")) {
                            s = "GMT" + s;
                        }
                        TimeZone timezone = TimeZone.getTimeZone(s);
                        offset = timezone.getRawOffset() / 60000;
                    }
                    DateTimeEditor.this.internalValue.setTimezone(offset);
                }
            });
        }

        private void setupFocusListeners() {
            FocusAdapter focusListener = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    Component opposite = e.getOppositeComponent();
                    if (opposite == null || opposite.getParent() != DateTimeEditor.this) {
                        DateTimeEditor.this.stopCellEditing();
                    }
                }
            };
            for (JFormattedTextField f : this.items.values()) {
                f.addFocusListener(focusListener);
            }
        }

        public Integer getYear() {
            int year = this.internalValue.getYear();
            return year == Integer.MIN_VALUE ? null : Integer.valueOf(year);
        }

        public Integer getMonth() {
            int month = this.internalValue.getMonth();
            return month == Integer.MIN_VALUE ? null : Integer.valueOf(month);
        }

        public Integer getDay() {
            int day = this.internalValue.getDay();
            return day == Integer.MIN_VALUE ? null : Integer.valueOf(day);
        }

        public Integer getHour() {
            int hour = this.internalValue.getHour();
            return hour == Integer.MIN_VALUE ? null : Integer.valueOf(hour);
        }

        public Integer getMinute() {
            int minute = this.internalValue.getMinute();
            return minute == Integer.MIN_VALUE ? null : Integer.valueOf(minute);
        }

        private Double getSecond() {
            int second = this.internalValue.getSecond();
            Double result = null;
            if (second != Integer.MIN_VALUE) {
                result = second;
                BigDecimal fractionalSecond = this.internalValue.getFractionalSecond();
                if (fractionalSecond != null) {
                    result = result + fractionalSecond.doubleValue();
                }
            }
            return result;
        }

        public String getTimezone() {
            TimeZone timezone;
            String result = null;
            if (this.internalValue.getTimezone() != Integer.MIN_VALUE && (timezone = this.internalValue.getTimeZone(0)) != null && (result = timezone.getID().substring(3)).equals("+00:00")) {
                result = "Z";
            }
            return result;
        }

        private void setValue(DateTimeKeys key, Object value) {
            this.items.get((Object)key).setValue(value);
        }
    }

    private static enum DateTimeKeys {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        TIMEZONE;

    }
}

