/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.error.XSLTErrorHandler;
import ch.e2e.builder.compiler.build.AbstractXsltTest;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXException;

public class XsltTest
extends AbstractXsltTest {
    public void doTest() throws Exception {
        File sourceFile = this.getSource();
        File destinationFile = this.getDestinationAndDelete();
        this.defineReferenceFileForComparison();
        File warningControlFile = this.getWarningControl();
        Transformer transformer = this.getTransformer();
        StreamResult result = new StreamResult(destinationFile);
        StreamSource source = new StreamSource(sourceFile);
        File warningFile = this.getWarningDestinationAndDelete();
        this.errorHandler = new AbstractErrorHandler(warningFile){};
        XSLTErrorHandler.getInstance().addErrorHandler(this.errorHandler);
        this.transform(transformer, source, result);
        XSLTErrorHandler.getInstance().removeErrorHandler(this.errorHandler);
        XSLTErrorHandler.getInstance().clear();
        this.assertWarningEqual(this.errorHandler, warningFile, warningControlFile);
    }

    public String getRecommendedCompareType() {
        return "XmlCompare";
    }

    private void assertWarningEqual(AbstractErrorHandler warningHandler, File warningFile, File controlFile) throws TransformerException, IOException, ParserConfigurationException, SAXException {
        if (warningHandler.getErrorAndWarningCount() > 0) {
            warningHandler.serialize(false);
            this.assertEqual(controlFile, warningFile);
        } else if (controlFile.exists()) {
            XsltTest.fail((String)(" missing error or warning (the control file " + controlFile.getAbsolutePath() + " exists but we have no error or warning)"));
        }
    }
}

