/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.template;

import ch.e2e.xuml.template.ResourceTemplate;
import ch.e2e.xuml.template.TemplateConstants;
import ch.e2e.xuml.template.TemplateProcessingException;
import ch.e2e.xuml.utils.ConvertToUnixLineSeparatorLineReader;
import ch.e2e.xuml.utils.OperatingSystemInfo;
import java.io.File;
import java.io.Reader;
import java.nio.charset.Charset;

public class ScriptResourceTemplate
extends ResourceTemplate {
    private static final boolean WINDOWS_OS = OperatingSystemInfo.isWindowsOs();

    public ScriptResourceTemplate(String resourceName, File targetFile) {
        super(resourceName, targetFile);
    }

    public ScriptResourceTemplate(String resourceName, File targetFile, ClassLoader classLoader) {
        super(resourceName, targetFile, classLoader);
    }

    @Override
    public Reader getReader() throws TemplateProcessingException {
        Reader reader = super.getReader();
        return this.isConvertToUnixFileSeparator() ? new ConvertToUnixLineSeparatorLineReader(reader) : reader;
    }

    private boolean isConvertToUnixFileSeparator() {
        return !WINDOWS_OS;
    }

    public boolean isSetExecutableFlags() {
        return !WINDOWS_OS;
    }

    @Override
    protected Charset getTargetFileCharset() {
        return WINDOWS_OS ? Charset.defaultCharset() : TemplateConstants.UTF_8_CHARSET;
    }
}

