/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.settings.utils;

import ch.e2e.xuml.settings.utils.Variable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.text.StrSubstitutor;

public final class GlobalVariables {
    public static final String GLOBAL_VARIABLE_BEGIN = "{{";
    public static final String GLOBAL_VARIABLE_END = "}}";
    private static final String PROPERTIES_FILENAME = "setting.properties";
    private static final ConcurrentMap<File, GlobalVariables> INSTANCES = new ConcurrentHashMap<File, GlobalVariables>();
    private final File propertiesFile;
    private Properties properties;
    private boolean modified;

    public static String replace(String source, Map<String, String> variables) {
        StrSubstitutor substitutor = new StrSubstitutor(variables, GLOBAL_VARIABLE_BEGIN, GLOBAL_VARIABLE_END);
        return substitutor.replace(source);
    }

    public static GlobalVariables getInstance(File directory) {
        GlobalVariables newInstance;
        GlobalVariables instance = (GlobalVariables)INSTANCES.get(directory);
        if (instance == null && (instance = INSTANCES.putIfAbsent(directory, newInstance = new GlobalVariables(directory))) == null) {
            instance = newInstance;
        }
        return instance;
    }

    private GlobalVariables(File directory) {
        this.propertiesFile = new File(directory, PROPERTIES_FILENAME);
    }

    public List<Variable> getVariables() {
        Map<String, String> keysAndValues = this.getKeysAndValues();
        ArrayList<Variable> variables = new ArrayList<Variable>(keysAndValues.size());
        for (Map.Entry<String, String> entry : keysAndValues.entrySet()) {
            Variable variable = new Variable(entry.getKey(), entry.getValue());
            variables.add(variable);
        }
        return variables;
    }

    public Map<String, String> getKeysAndValues() {
        try {
            return this.getProperties();
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties() throws IOException {
        File file = this.propertiesFile;
        synchronized (file) {
            if (this.modified || this.properties == null) {
                this.properties = new Properties();
                FileReader reader = new FileReader(this.propertiesFile);
                try {
                    this.properties.load(reader);
                }
                finally {
                    reader.close();
                }
            }
            this.modified = false;
            return this.properties;
        }
    }

    public void store(Iterable<? extends Variable> variables) throws IOException {
        Properties properties = this.toProperties(variables);
        this.store(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(Properties properties) throws IOException {
        File file = this.propertiesFile;
        synchronized (file) {
            this.modified = true;
            File tmpPropertiesFile = new File(this.propertiesFile.getParentFile(), "setting.properties.new");
            if (tmpPropertiesFile.exists()) {
                tmpPropertiesFile.delete();
            }
            FileWriter writer = new FileWriter(tmpPropertiesFile);
            try {
                properties.store(writer, null);
            }
            finally {
                writer.close();
            }
            if (this.propertiesFile.exists()) {
                this.propertiesFile.delete();
            }
            tmpPropertiesFile.renameTo(this.propertiesFile);
        }
    }

    private Properties toProperties(Iterable<? extends Variable> variables) {
        Properties properties = new Properties();
        for (Variable variable : variables) {
            properties.setProperty(variable.getName(), variable.getValue());
        }
        return properties;
    }
}

