/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.settings.model;

import ch.e2e.util.StringTools;
import ch.e2e.xuml.settings.Settings;
import ch.e2e.xuml.settings.model.Dependent;
import ch.e2e.xuml.settings.model.EnumValue;
import ch.e2e.xuml.settings.model.Reloadable;
import ch.e2e.xuml.settings.model.SettingChange;
import ch.e2e.xuml.settings.utils.GlobalVariables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Setting
implements Reloadable {
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DEFAULT = "default";
    private static final String ATTR_TYPE = "type";
    private static final String NAME_ENUM_VALUE = "EnumValue";
    private static final String TYPE_ENUM = "enum";
    private static final String TYPE_PASSWORD = "password";
    private static final Pattern GLOBAL_VARIABLE_PATTERN = Pattern.compile("\\{\\{(.+)\\}\\}");
    static final String PASSWORD_PLACEHOLDER = "*******";
    private final String id;
    private final String type;
    private final Dependent[] dependents;
    private final String modelValue;
    private final EnumValue[] enumValues;
    private String value;
    private String replacedValue;

    public Setting(Element variable, Dependent[] dependents, Map<String, ? extends SettingChange> settingChanges, Map<String, String> globalVariables) {
        this.id = variable.getAttribute(ATTR_NAME);
        this.type = variable.getAttribute(ATTR_TYPE);
        this.modelValue = variable.getAttribute(ATTR_DEFAULT);
        this.setValue(this.modelValue, settingChanges.get(this.id), globalVariables);
        if (TYPE_ENUM.equalsIgnoreCase(this.type)) {
            this.enumValues = this.enumValues(variable.getElementsByTagName(NAME_ENUM_VALUE));
            Arrays.sort(this.enumValues);
        } else {
            this.enumValues = new EnumValue[0];
        }
        this.dependents = dependents == null ? new Dependent[]{} : dependents;
        Arrays.sort(this.dependents);
    }

    private EnumValue[] enumValues(NodeList valueElements) {
        int nValues = valueElements.getLength();
        EnumValue[] enumValues = new EnumValue[nValues];
        if (nValues > 0) {
            for (int i = 0; i < nValues; ++i) {
                enumValues[i] = new EnumValue((Element)valueElements.item(i));
            }
        }
        return enumValues;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String showValue() {
        if (this.isPassword()) {
            return PASSWORD_PLACEHOLDER;
        }
        if (this.isUsingGlobalVariable()) {
            return this.getReplacedValue() + " (" + this.getValue() + ")";
        }
        return this.getReplacedValue();
    }

    public String toCsv(char separator) {
        StringBuilder sb = new StringBuilder();
        if (this.isPassword()) {
            sb.append(separator);
        } else {
            sb.append(Settings.escapeCsv(this.getValue(), separator)).append(separator);
            if (!this.getValue().equals(this.getReplacedValue())) {
                sb.append(Settings.escapeCsv(this.getReplacedValue(), separator));
            }
        }
        return sb.toString();
    }

    private String getGlobalVariableName(String s) {
        Matcher matcher = GLOBAL_VARIABLE_PATTERN.matcher(s);
        return matcher.find() ? matcher.group(1) : null;
    }

    public boolean isUsingGlobalVariable() {
        return this.isUsingGlobalVariable(this.getValue());
    }

    private boolean isUsingGlobalVariable(String s) {
        Matcher matcher = GLOBAL_VARIABLE_PATTERN.matcher(s);
        return matcher.find();
    }

    private void setValue(String value, SettingChange settingChange, Map<String, String> globalVariables) {
        this.setValue(settingChange == null ? value : settingChange.getValue(), globalVariables);
    }

    private void setValue(String value, Map<String, String> globalVariables) {
        this.setValue(value, Setting.getReplacedValue(value, globalVariables));
    }

    private void setValue(String value, String replacedValue) {
        this.setValue(value);
        if (replacedValue != null) {
            this.replacedValue = replacedValue;
        }
    }

    private void setValue(String value) {
        this.replacedValue = this.value = value == null ? "" : value;
    }

    private static String getReplacedValue(String value, Map<String, String> globalVariables) {
        return GlobalVariables.replace(value, globalVariables);
    }

    public String getReplacedValue() {
        return this.replacedValue;
    }

    public String getModelValue() {
        return this.modelValue;
    }

    private Dependent[] getDependents() {
        return this.dependents;
    }

    public boolean hasDependents() {
        return this.getDependents().length > 0;
    }

    public String getPlaceholderForTemplate(String templateName) {
        for (Dependent dependent : this.getDependents()) {
            if (!dependent.getTemplateName().equals(templateName)) continue;
            return dependent.getPlaceholder();
        }
        return this.getId();
    }

    public EnumValue[] getEnumValues() {
        return this.enumValues;
    }

    public boolean isPassword() {
        return TYPE_PASSWORD.equalsIgnoreCase(this.getType());
    }

    public boolean isModified() {
        return this.isChanged() || this.isUsingGlobalVariable(this.getValue());
    }

    public boolean isChanged() {
        return !this.getModelValue().equals(this.getValue());
    }

    public boolean applySettingChange(SettingChange settingChange, Map<String, String> variables) {
        boolean change;
        SettingChange substitutedSettingChange = settingChange.with(variables);
        boolean bl = change = substitutedSettingChange.getId().equals(this.getId()) && (!substitutedSettingChange.getValue().equals(this.getValue()) || substitutedSettingChange.getReplacedValue() != null && !substitutedSettingChange.getReplacedValue().equals(this.getReplacedValue()));
        if (change) {
            this.setValue(substitutedSettingChange.getValue(), substitutedSettingChange.getReplacedValue());
        }
        return change;
    }

    public boolean substituteGlobalVariables(Map<String, String> variables) {
        boolean replaced;
        String replacedValue = Setting.getReplacedValue(this.getValue(), variables);
        boolean bl = replaced = this.getValue() != replacedValue && !replacedValue.equals(this.getReplacedValue());
        if (replaced) {
            this.replacedValue = replacedValue;
        }
        return replaced;
    }

    public boolean isUsedInTemplate(String templateName) {
        for (Dependent dependent : this.dependents) {
            if (!templateName.equals(dependent.getTemplateName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String reloadCommand() {
        ArrayList<String> lines = new ArrayList<String>(this.dependents.length);
        for (Dependent dependent : this.dependents) {
            String target = dependent.getTargetName().substring("tabfiles".length() + 1);
            String placeholder = this.getPlaceholderForTemplate(dependent.getTemplateName());
            String line = "<Change file=\"" + target + "\" property=\"" + placeholder + "\" value=\"" + this.getValue() + "\"/>";
            lines.add(line);
        }
        return StringTools.join(lines, (String)"\n\t");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Setting setting = (Setting)o;
        return this.getId().equals(setting.getId()) && this.getType().equals(setting.getType()) && Arrays.equals(this.getDependents(), setting.getDependents()) && this.getModelValue().equals(setting.getModelValue()) && Arrays.equals(this.getEnumValues(), setting.getEnumValues()) && (this.getValue() == null ? setting.getValue() == null : this.getValue().equals(setting.getValue())) && (this.getReplacedValue() == null ? setting.getReplacedValue() == null : this.getReplacedValue().equals(setting.getReplacedValue()));
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "Setting{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", modelValue='" + this.modelValue + '\'' + ", value='" + this.value + '\'' + ", replacedValue='" + this.replacedValue + '\'' + '}';
    }

    @Override
    public int compareTo(Reloadable that) {
        return this.toString().compareTo(that.toString());
    }
}

