/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.settings.model;

import ch.e2e.xuml.settings.model.Dependent;
import ch.e2e.xuml.settings.model.Setting;
import ch.e2e.xuml.settings.model.SettingChange;
import ch.e2e.xuml.template.TemplateProcessingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Model {
    private final Document substitutionsDoc;
    private final Map<String, Setting> settings;
    private final Map<String, String> template2target;

    public Model(Document substitutionsDoc, Map<String, ? extends SettingChange> settingChanges, Map<String, String> globalVariables) throws TemplateProcessingException {
        this.substitutionsDoc = substitutionsDoc;
        this.template2target = this.template2target();
        Map<String, Dependent[]> variable2templates = this.variable2templates(this.template2target);
        this.settings = this.variables(variable2templates, settingChanges, globalVariables);
    }

    public Map<String, Setting> getSettings() {
        return Collections.unmodifiableMap(this.settings);
    }

    public Map<String, String> getTemplateToTarget() {
        return Collections.unmodifiableMap(this.template2target);
    }

    private Map<String, String> template2target() {
        NodeList files = this.substitutionsDoc.getElementsByTagName("File");
        HashMap<String, String> fileMapping = new HashMap<String, String>();
        for (int i = 0; i < files.getLength(); ++i) {
            Element file = (Element)files.item(i);
            fileMapping.put(file.getAttribute("template"), file.getAttribute("target"));
        }
        return fileMapping;
    }

    private Map<String, Dependent[]> variable2templates(Map<String, String> template2target) throws TemplateProcessingException {
        NodeList dependencies = this.substitutionsDoc.getElementsByTagName("Depending");
        int nDependencies = dependencies.getLength();
        HashMap<String, Dependent[]> variable2templates = new HashMap<String, Dependent[]>(nDependencies);
        for (int i = 0; i < nDependencies; ++i) {
            Element dependency = (Element)dependencies.item(i);
            String settingId = dependency.getAttribute("on");
            String placeholder = this.placeholder(dependency);
            NodeList elements = dependency.getElementsByTagName("Dependent");
            int nDependents = elements.getLength();
            ArrayList<Dependent> dependents = new ArrayList<Dependent>();
            for (int j = 0; j < nDependents; ++j) {
                Element item = (Element)elements.item(j);
                String template = item.getAttribute("template");
                String target = template2target.get(template);
                if (target == null) {
                    throw new TemplateProcessingException("Missing target for template '" + template + "'.");
                }
                dependents.add(new Dependent(template, target, placeholder));
            }
            variable2templates.put(settingId, dependents.toArray(new Dependent[dependents.size()]));
        }
        return variable2templates;
    }

    private String placeholder(Element dependency) {
        String variableName = dependency.getAttribute("on");
        String placeholder = dependency.getAttribute("as");
        if (placeholder.isEmpty()) {
            placeholder = variableName;
        }
        return placeholder;
    }

    private Map<String, Setting> variables(Map<String, ? extends Dependent[]> variable2templates, Map<String, ? extends SettingChange> settingChanges, Map<String, String> globalVariables) throws TemplateProcessingException {
        NodeList variableElements = this.substitutionsDoc.getElementsByTagName("Variable");
        int nVariables = variableElements.getLength();
        HashMap<String, Setting> variables = new HashMap<String, Setting>(nVariables);
        for (int i = 0; i < nVariables; ++i) {
            Element variableElement = (Element)variableElements.item(i);
            String variableName = variableElement.getAttribute("name");
            Dependent[] dependents = variable2templates.get(variableName);
            if (dependents == null) {
                throw new TemplateProcessingException("Missing dependents for variable '" + variableName + ".");
            }
            Setting setting = new Setting(variableElement, dependents, settingChanges, globalVariables);
            variables.put(setting.getId(), setting);
        }
        return variables;
    }
}

