/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.util;

import ch.e2e.resource.Properties;
import java.awt.Color;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringTools {
    private static String HTML_ENTITIES = String.valueOf(new char[]{'&', '\u00e4', '\u00c4', '\u00f6', '\u00d6', '\u00fc', '\u00dc', '\"', '<', '>', '\u00df'});
    private static String[] HTML_ENTITIES_REPLACE = new String[]{"&amp;", "&auml;", "&Auml;", "&ouml;", "&Ouml;", "&uuml;", "&Uuml;", "&quot;", "&lt;", "&gt;", "&szlig;"};
    private static String XML_ENTITIES = "&\"'<>";
    private static String[] XML_ENTITIES_REPLACE = new String[]{"&amp;", "&quot;", "&apos;", "&lt;", "&gt;"};
    private static HashMap<String, String> hashes = new HashMap();
    private static final Mapper<Object> defaultMapper = new Mapper<Object>(){

        @Override
        public Object map(Object obj) {
            return obj;
        }
    };
    public static final Matcher IS_CONTROL_CHARACTER_MATCHER = Pattern.compile("\\p{Cntrl}").matcher("");

    public static boolean createBoolean(String boolStr) {
        return boolStr != null && (boolStr.equalsIgnoreCase("true") || boolStr.equalsIgnoreCase("yes"));
    }

    public static String createColorString(Color color) {
        return "#" + Integer.toHexString(color.getRed()) + Integer.toHexString(color.getGreen()) + Integer.toHexString(color.getBlue());
    }

    public static String createArrayString(String[] array) {
        return "{" + StringTools.join(Arrays.asList(array), ",") + "}";
    }

    public static <T> String join(Iterator<? extends T> iterator, String delimiter) {
        return StringTools.join(iterator, defaultMapper, delimiter);
    }

    public static <T> String join(Iterable<? extends T> objects, String delimiter) {
        return StringTools.join(objects == null ? null : objects.iterator(), defaultMapper, delimiter);
    }

    public static <T> String join(Iterator<? extends T> iterator, Mapper<? super T> mapper, String delimiter) {
        String result = "";
        if (iterator != null && iterator.hasNext()) {
            StringBuilder builder = new StringBuilder(String.valueOf(mapper.map(iterator.next())));
            while (iterator.hasNext()) {
                builder.append(delimiter).append(mapper.map(iterator.next()));
            }
            result = builder.toString();
        }
        return result;
    }

    public static String concat(String ... strings) {
        StringBuilder builder = new StringBuilder();
        for (String string : strings) {
            builder.append(string);
        }
        return builder.toString();
    }

    public static String concat(Iterable<String> strings) {
        return StringTools.concat(strings.iterator());
    }

    public static String concat(Iterator<String> iterator) {
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
        }
        return builder.toString();
    }

    public static <T> String join(Iterable<? extends T> objects, Mapper<? super T> mapper, String delimiter) {
        return StringTools.join(objects.iterator(), mapper, delimiter);
    }

    public static String trimLeading(String stringToTrim) {
        int i = 0;
        char c = stringToTrim.charAt(i++);
        int length = stringToTrim.length();
        while (i < length && (c == ' ' || c == '\n' || c == '\r' || c == '\t')) {
            c = stringToTrim.charAt(i++);
        }
        return stringToTrim.substring(i - 1);
    }

    public static String removeAllSpaces(String stringToClear) {
        return StringTools.removeAll(stringToClear, ' ');
    }

    public static String removeAll(String stringToClear, char charToRemove) {
        StringBuilder buffer = new StringBuilder(stringToClear.length());
        for (int i = 0; i < stringToClear.length(); ++i) {
            if (stringToClear.charAt(i) == charToRemove) continue;
            buffer.append(stringToClear.charAt(i));
        }
        return buffer.toString();
    }

    public static String getSpaceString(int length) {
        return StringTools.append("", length, ' ');
    }

    public static String getZeroString(int length) {
        return StringTools.append("", length, '0');
    }

    public static String appendZeros(String str, int length) {
        return StringTools.append(str, length, '0');
    }

    public static String appendSpaces(String str, int length) {
        return StringTools.append(str, length, ' ');
    }

    public static String prependZeros(String str, int length) {
        return StringTools.prepend(str, length, '0');
    }

    public static String prependSpaces(String str, int length) {
        return StringTools.prepend(str, length, ' ');
    }

    public static String removeNonDigitChars(String strToRemove) {
        StringBuilder buf = new StringBuilder(strToRemove);
        for (int i = 0; i < buf.length(); ++i) {
            if (Character.isDigit(buf.charAt(i))) continue;
            buf.deleteCharAt(i--);
        }
        return buf.toString();
    }

    public static String replace(String s, String stringToReplace, String stringToInsert, boolean all) {
        StringBuilder buffer = new StringBuilder(s.length() + 128);
        buffer.append(s);
        int index = s.indexOf(stringToReplace);
        if (index != -1) {
            buffer.replace(index, stringToReplace.length() + index, stringToInsert);
            if (all) {
                return StringTools.replace(buffer.toString(), stringToReplace, stringToInsert, true);
            }
            return buffer.toString();
        }
        return s;
    }

    public static String replaceAll(String s, String stringToReplace, String stringToInsert, boolean ignoreCase) {
        StringBuffer indexBuffer;
        if (ignoreCase) {
            stringToReplace = stringToReplace.toUpperCase();
            indexBuffer = new StringBuffer(s.toUpperCase());
        } else {
            indexBuffer = new StringBuffer(s);
        }
        StringBuilder buffer = new StringBuilder(s.length() + 128);
        buffer.append(s);
        int replaceLength = stringToReplace.length();
        int insertLength = stringToInsert.length();
        int index = indexBuffer.indexOf(stringToReplace);
        while (index != -1) {
            buffer.replace(index, index + replaceLength, stringToInsert);
            indexBuffer.replace(index, index + replaceLength, stringToInsert);
            if (index + insertLength < indexBuffer.length()) {
                index = indexBuffer.indexOf(stringToReplace, index + insertLength);
                continue;
            }
            index = -1;
        }
        return buffer.toString();
    }

    public static String replaceHtmlEntities(String stringToReplace) {
        return StringTools.replaceChars(stringToReplace, HTML_ENTITIES, HTML_ENTITIES_REPLACE);
    }

    public static String replaceXMLEntities(String stringToReplace) {
        return StringTools.replaceChars(stringToReplace, XML_ENTITIES, XML_ENTITIES_REPLACE);
    }

    public static String replaceChars(String stringToReplace, String charsToReplace, String[] replaceStrings) {
        StringBuilder sb = new StringBuilder(stringToReplace.length() * 2);
        int length = stringToReplace.length();
        for (int i = 0; i < length; ++i) {
            char c = stringToReplace.charAt(i);
            int index = charsToReplace.indexOf(c);
            if (index == -1) {
                sb.append(c);
                continue;
            }
            sb.append(replaceStrings[index]);
        }
        return sb.toString();
    }

    public static String replaceChars(String stringToReplace, String charsToReplace, char[] replaceChars) {
        StringBuilder sb = new StringBuilder(stringToReplace.length());
        int length = stringToReplace.length();
        for (int i = 0; i < length; ++i) {
            char c = stringToReplace.charAt(i);
            int index = charsToReplace.indexOf(c);
            if (index == -1) {
                sb.append(c);
                continue;
            }
            sb.append(replaceChars[index]);
        }
        return sb.toString();
    }

    public static String replaceChars(String stringToReplace, String charsToReplace, char replaceChar) {
        StringBuilder sb = new StringBuilder(stringToReplace.length());
        int length = stringToReplace.length();
        for (int i = 0; i < length; ++i) {
            char c = stringToReplace.charAt(i);
            int index = charsToReplace.indexOf(c);
            if (index == -1) {
                sb.append(c);
                continue;
            }
            sb.append(replaceChar);
        }
        return sb.toString();
    }

    public static String removeChars(String stringToReplace, String charsToRemove) {
        StringBuilder sb = new StringBuilder(stringToReplace.length());
        int length = stringToReplace.length();
        for (int i = 0; i < length; ++i) {
            char c = stringToReplace.charAt(i);
            int index = charsToRemove.indexOf(c);
            if (index != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String prepend(String str, int length, char c) {
        StringBuilder retStr = new StringBuilder(length);
        for (int i = 0; i < length - str.length(); ++i) {
            retStr.append(c);
        }
        retStr.append(str);
        return retStr.toString();
    }

    public static String append(String str, int length, char c) {
        StringBuilder retStr = new StringBuilder(length);
        retStr.append(str);
        for (int i = 0; i < length - str.length(); ++i) {
            retStr.append(c);
        }
        return retStr.toString();
    }

    public static List createLines(String text, String delim) {
        return StringTools.createLines(text, delim, false);
    }

    public static List createLines(String text, String delim, boolean trim) {
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(text, delim, true);
        boolean ignoreSeparator = false;
        while (tokenizer.hasMoreElements()) {
            String line = tokenizer.nextToken();
            if (line.length() == 1 && delim.contains(line)) {
                if (!ignoreSeparator) {
                    line = "";
                } else {
                    ignoreSeparator = false;
                    continue;
                }
            }
            if (line.length() > 0) {
                ignoreSeparator = true;
            }
            if (trim) {
                lines.add(line.trim());
                continue;
            }
            lines.add(line);
        }
        return lines;
    }

    public static ArrayList<String> splitString(String text, String delim) {
        ArrayList<String> lines = new ArrayList<String>();
        int length = text.length();
        StringBuffer line = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (delim.indexOf(c) == -1) {
                line.append(c);
                continue;
            }
            lines.add(line.toString());
            line = new StringBuffer();
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        return lines;
    }

    public static String[] split(String text, String delim) {
        ArrayList<String> lines = StringTools.splitString(text, delim);
        String[] result = new String[lines.size()];
        lines.toArray(result);
        return result;
    }

    public static String[] createStringArray(String stringToParse) throws ParseException {
        if (stringToParse.startsWith("{") && stringToParse.endsWith("}")) {
            ArrayList<String> strings = new ArrayList<String>();
            StringBuffer nextString = null;
            int length = (stringToParse = stringToParse.substring(1, stringToParse.length() - 1).trim()).length();
            if (length > 0) {
                nextString = new StringBuffer();
                block4: for (int i = 0; i < length; ++i) {
                    char testChar = stringToParse.charAt(i);
                    switch (stringToParse.charAt(i)) {
                        case '\\': {
                            if (i >= length - 1) continue block4;
                            if (stringToParse.charAt(i + 1) == ',') {
                                ++i;
                                nextString.append(',');
                                continue block4;
                            }
                            nextString.append('\\');
                            continue block4;
                        }
                        case ',': {
                            strings.add(nextString.toString());
                            nextString = new StringBuffer();
                            continue block4;
                        }
                        default: {
                            nextString.append(testChar);
                        }
                    }
                }
            }
            if (nextString != null) {
                strings.add(nextString.toString());
            }
            String[] stringArray = new String[strings.size()];
            strings.toArray(stringArray);
            return stringArray;
        }
        throw new ParseException("No matching braces found.", 0);
    }

    public static String replaceProperty(String value, String propertyName, String propertyValue) {
        return StringTools.replaceAll(value, "${" + propertyName + "}", propertyValue, false);
    }

    public static String replaceProperties(String value, Map properties) {
        return StringTools.replaceProperties(value, properties, "${", "}");
    }

    public static String replaceProperties(String value, Map properties, String beginToken, String endToken) {
        StringBuilder cleanValue = new StringBuilder();
        if (properties == null) {
            cleanValue.append(value);
        } else {
            int oldIndex = 0;
            int index = value.indexOf(beginToken);
            do {
                int nextEnd;
                if (index == -1) continue;
                cleanValue.append(value.substring(oldIndex, index));
                int endIndex = value.indexOf(endToken, index);
                if (endIndex == -1) {
                    return value;
                }
                String propertyName = value.substring(index + beginToken.length(), endIndex);
                if (propertyName.contains(beginToken) && (nextEnd = value.indexOf(endToken, endIndex + 1)) != -1) {
                    endIndex = nextEnd;
                    propertyName = value.substring(index + beginToken.length(), endIndex);
                    propertyName = StringTools.replaceProperties(propertyName, properties, beginToken, endToken);
                }
                String propertyValue = null;
                Object valueObject = properties.get(propertyName);
                if (valueObject != null) {
                    propertyValue = valueObject.toString();
                }
                if (propertyValue == null && propertyName.length() > 0) {
                    propertyValue = System.getProperty(propertyName);
                }
                if (propertyValue != null) {
                    cleanValue.append(propertyValue);
                } else {
                    cleanValue.append(beginToken).append(propertyName).append(endToken);
                }
                oldIndex = endIndex + endToken.length();
                index = value.indexOf(beginToken, endIndex);
            } while (index != -1);
            cleanValue.append(value.substring(oldIndex));
            index = cleanValue.indexOf(beginToken);
            if (index != -1 && !value.equals(cleanValue.toString())) {
                return StringTools.replaceProperties(cleanValue.toString(), properties, beginToken, endToken);
            }
        }
        return cleanValue.toString();
    }

    public static boolean checkIfUnless(String ifString, String unless, Properties properties) {
        boolean result = true;
        if (ifString != null) {
            String ifProperty = properties.getProperty(ifString);
            boolean bl = result = ifProperty != null;
        }
        if (result && unless != null) {
            String unlessProperty = properties.getProperty(unless);
            result = unlessProperty == null;
        }
        return result;
    }

    public static boolean checkIfUnless(String ifString, String unless, Map<String, String> properties) {
        boolean result = true;
        if (ifString != null) {
            String ifProperty = properties.get(ifString);
            boolean bl = result = ifProperty != null;
        }
        if (result && unless != null) {
            String unlessProperty = properties.get(unless);
            result = unlessProperty == null;
        }
        return result;
    }

    public static String toHexString(byte[] data) {
        StringBuilder result = new StringBuilder();
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            result.append(StringTools.byte2hex(data[i]));
            if (i >= len - 1) continue;
            result.append(":");
        }
        return result.toString();
    }

    public static boolean isDisplayable(String s) {
        return s == null || !IS_CONTROL_CHARACTER_MATCHER.reset(s).find();
    }

    public static String getHashCode(String stringToHash) {
        return String.valueOf(stringToHash.hashCode());
    }

    public static String getHashCodeAndCache(String stringToHash) {
        String hash = hashes.get(stringToHash);
        if (hash == null) {
            int hashCode = stringToHash.hashCode();
            hash = String.valueOf(hashCode);
            while (hashes.containsValue(hash)) {
                hash = String.valueOf(++hashCode);
            }
            hashes.put(stringToHash, hash);
        }
        return hash;
    }

    public static void clearHashes() {
        hashes.clear();
    }

    private static String byte2hex(byte b) {
        char[] ac = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        return new String(new char[]{ac[(b & 0xF0) >> 4], ac[b & 0xF]});
    }

    public static String escapeXpath(String s) {
        return s.replace("'", "''");
    }

    public static interface Mapper<T> {
        public Object map(T var1);
    }
}

