/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.secure;

import ch.e2e.secure.TrustAllManager;
import ch.e2e.secure.UntrustedTrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class UntrustedSSLProtocolFactory
implements ProtocolSocketFactory {
    private SSLContext sslcontext = null;
    private UntrustedTrustManager trustManager;

    public UntrustedSSLProtocolFactory() throws CertificateException, NoSuchAlgorithmException, KeyStoreException {
        this.trustManager = new TrustAllManager();
    }

    public UntrustedSSLProtocolFactory(UntrustedTrustManager trustManager) {
        this.trustManager = trustManager;
    }

    private SSLContext createUntrustedSSLContext() {
        SSLContext context = null;
        try {
            context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{this.trustManager}, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return context;
    }

    public SSLContext getSSLContext() {
        if (this.sslcontext == null) {
            this.sslcontext = this.createUntrustedSSLContext();
        }
        return this.sslcontext;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        SSLSocketFactory socketfactory = this.getSSLContext().getSocketFactory();
        if (timeout == 0) {
            return socketfactory.createSocket(host, port, localAddress, localPort);
        }
        Socket socket = socketfactory.createSocket();
        InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        socket.bind(localaddr);
        socket.connect(remoteaddr, timeout);
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(host, port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(UntrustedSSLProtocolFactory.class);
    }

    public int hashCode() {
        return UntrustedSSLProtocolFactory.class.hashCode();
    }
}

