/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.resource;

import ch.e2e.resource.Properties;
import java.util.Locale;
import java.util.MissingResourceException;

public class MultiMapProperties
extends Properties {
    private String mapKey;
    private ClassLoader classLoader;

    public MultiMapProperties(String propertyName, String mapKey) {
        this(propertyName, mapKey, Locale.getDefault());
    }

    public MultiMapProperties(String propertyName, String mapKey, Locale locale) {
        this(propertyName, mapKey, locale, MultiMapProperties.class.getClassLoader());
    }

    public MultiMapProperties(String propertyName, String mapKey, ClassLoader classLoader) {
        this(propertyName, mapKey, Locale.getDefault(), classLoader);
    }

    public MultiMapProperties(String propertyName, String mapKey, Locale locale, ClassLoader classLoader) {
        super(propertyName, locale, classLoader);
        this.mapKey = mapKey;
        this.classLoader = classLoader;
        if (this.exists()) {
            this.readMaps(locale);
        }
    }

    @Override
    public void reload(Locale locale) {
        super.reload(locale);
        this.readMaps(locale);
    }

    public String getMapKey() {
        return this.mapKey;
    }

    private void readMaps(Locale locale) throws MissingResourceException {
        String[] maps;
        for (String map : maps = this.getStringArray(this.mapKey, new String[0])) {
            this.addProperties(new Properties(map, locale, this.classLoader));
        }
    }
}

