/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.logging;

import ch.e2e.logging.LogManager;
import ch.e2e.logging.LoggingCanvas;
import ch.e2e.logging.LoggingFrame;
import java.awt.Color;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class LoggingCanvasHandler
extends Handler {
    private LoggingCanvas canvas;

    public LoggingCanvasHandler() {
        if (this.canvas == null) {
            this.canvas = new LoggingCanvas();
        }
        this.configure();
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (this.isLoggable(record) && this.canvas != null) {
            Formatter formatter = this.getFormatter();
            String message = formatter == null ? record.getMessage() : formatter.format(record);
            if (record.getLevel().equals(Level.CONFIG)) {
                this.canvas.config(message);
            } else if (record.getLevel().equals(Level.FINE)) {
                this.canvas.fine(message);
            } else if (record.getLevel().equals(Level.FINER)) {
                this.canvas.finer(message);
            } else if (record.getLevel().equals(Level.FINEST)) {
                this.canvas.finest(message);
            } else if (record.getLevel().equals(Level.INFO)) {
                this.canvas.info(message);
            } else if (record.getLevel().equals(Level.SEVERE)) {
                this.canvas.severe(message);
            } else if (record.getLevel().equals(Level.WARNING)) {
                this.canvas.warning(message);
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    private void configure() {
        String cname = this.getClass().getName();
        this.setLevel(LogManager.getLevelProperty(cname + ".level", Level.INFO));
        this.setFilter(this.getFilterProperty(LogManager.getProperty(cname + ".filter"), null));
        this.setFormatter(this.getFormatterProperty(LogManager.getProperty(cname + ".formatter"), new SimpleFormatter()));
        try {
            this.setEncoding(LogManager.getProperty(cname + ".encoding"));
        }
        catch (Exception ex) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.readLoggingFrameParameter(cname);
        this.setColors(cname);
    }

    private void readLoggingFrameParameter(String cname) {
        String framePrefix = cname + ".loggingframe.";
        try {
            boolean systemerr;
            boolean systemout;
            String frameClass = LogManager.getProperty(framePrefix + "class");
            LoggingFrame loggingFrame = (LoggingFrame)Class.forName(frameClass).newInstance();
            loggingFrame.initialize(this.canvas);
            try {
                boolean open = new Boolean(LogManager.getProperty(framePrefix + "open"));
                if (open) {
                    loggingFrame.open();
                }
            }
            catch (Exception open) {
                // empty catch block
            }
            try {
                systemout = new Boolean(LogManager.getProperty(framePrefix + "systemout"));
            }
            catch (Exception ex) {
                systemout = false;
            }
            loggingFrame.setSystemOutEnabled(systemout);
            try {
                systemerr = new Boolean(LogManager.getProperty(framePrefix + "systemerr"));
            }
            catch (Exception ex) {
                systemerr = false;
            }
            loggingFrame.setSystemErrEnabled(systemerr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setColors(String cname) {
        String colorProperty = cname + ".color.";
        this.canvas.setColor(Level.CONFIG, this.getColorProperty(LogManager.getProperty(colorProperty + "config")));
        this.canvas.setColor(Level.FINE, this.getColorProperty(LogManager.getProperty(colorProperty + "fine")));
        this.canvas.setColor(Level.FINER, this.getColorProperty(LogManager.getProperty(colorProperty + "finer")));
        this.canvas.setColor(Level.FINEST, this.getColorProperty(LogManager.getProperty(colorProperty + "finest")));
        this.canvas.setColor(Level.INFO, this.getColorProperty(LogManager.getProperty(colorProperty + "info")));
        this.canvas.setColor(Level.SEVERE, this.getColorProperty(LogManager.getProperty(colorProperty + "severe")));
        this.canvas.setColor(Level.WARNING, this.getColorProperty(LogManager.getProperty(colorProperty + "warning")));
    }

    private Color getColorProperty(String color) {
        Color result = null;
        if (color != null) {
            result = new Color(Integer.parseInt(color.substring(1), 16));
        }
        return result;
    }

    private Formatter getFormatterProperty(String formatter, Formatter defaultFormatter) {
        Formatter result = defaultFormatter;
        if (formatter != null) {
            try {
                Class<?> formatterClass = Class.forName(formatter);
                result = (Formatter)formatterClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private Filter getFilterProperty(String filter, Filter defaultFilter) {
        Filter result = defaultFilter;
        if (filter != null) {
            try {
                Class<?> filterClass = Class.forName(filter);
                result = (Filter)filterClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }
}

